/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.datamatrix.decoder.BitMatrixParser;
import com.google.zxing.datamatrix.decoder.DataBlock;
import com.google.zxing.datamatrix.decoder.DecodedBitStreamParser;
import com.google.zxing.datamatrix.decoder.Version;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.DATA_MATRIX_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) throws FormatException, ChecksumException {
        int n2 = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!blArray[i2][i3]) continue;
                bitMatrix.set(i3, i2);
            }
        }
        return this.decode(bitMatrix);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        Version version = bitMatrixParser.getVersion();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version);
        int n2 = dataBlockArray.length;
        int n3 = 0;
        DataBlock[] objectArray = dataBlockArray;
        int n4 = objectArray.length;
        for (int dataBlock = 0; dataBlock < n4; ++dataBlock) {
            DataBlock dataBlock2 = objectArray[dataBlock];
            n3 += dataBlock2.getNumDataCodewords();
        }
        byte[] byArray2 = new byte[n3];
        for (n4 = 0; n4 < n2; ++n4) {
            DataBlock dataBlock = dataBlockArray[n4];
            byte[] byArray3 = dataBlock.getCodewords();
            int n5 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray3, n5);
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray2[i2 * n2 + n4] = byArray3[i2];
            }
        }
        return DecodedBitStreamParser.decode(byArray2);
    }

    private void correctErrors(byte[] byArray, int n2) throws ChecksumException {
        int n3;
        int n4 = byArray.length;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        n3 = byArray.length - n2;
        try {
            this.rsDecoder.decode(nArray, n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)nArray[i2];
        }
    }
}

