/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

final class Base256Encoder
implements Encoder {
    Base256Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 5;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        boolean bl2;
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\u0000');
        while (encoderContext.hasMoreCharacters()) {
            n3 = encoderContext.getCurrentChar();
            stringBuilder.append((char)n3);
            ++encoderContext.pos;
            n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode());
            if (n2 == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n2);
            break;
        }
        n3 = stringBuilder.length() - 1;
        n2 = 1;
        int n4 = encoderContext.getCodewordCount() + n3 + n2;
        encoderContext.updateSymbolInfo(n4);
        boolean bl3 = bl2 = encoderContext.getSymbolInfo().getDataCapacity() - n4 > 0;
        if (encoderContext.hasMoreCharacters() || bl2) {
            if (n3 <= 249) {
                stringBuilder.setCharAt(0, (char)n3);
            } else if (n3 > 249 && n3 <= 1555) {
                stringBuilder.setCharAt(0, (char)(n3 / 250 + 249));
                stringBuilder.insert(1, (char)(n3 % 250));
            } else {
                throw new IllegalStateException("Message length not in valid ranges: " + n3);
            }
        }
        int n5 = stringBuilder.length();
        for (int i2 = 0; i2 < n5; ++i2) {
            encoderContext.writeCodeword(Base256Encoder.randomize255State(stringBuilder.charAt(i2), encoderContext.getCodewordCount() + 1));
        }
    }

    private static char randomize255State(char c2, int n2) {
        int n3 = 149 * n2 % 255 + 1;
        int n4 = c2 + n3;
        if (n4 <= 255) {
            return (char)n4;
        }
        return (char)(n4 - 256);
    }
}

