/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

class C40Encoder
implements Encoder {
    C40Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 1;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            int n2;
            char c2 = encoderContext.getCurrentChar();
            ++encoderContext.pos;
            int n3 = this.encodeChar(c2, stringBuilder);
            int n4 = stringBuilder.length() / 3 * 2;
            int n5 = encoderContext.getCodewordCount() + n4;
            encoderContext.updateSymbolInfo(n5);
            int n6 = encoderContext.getSymbolInfo().getDataCapacity() - n5;
            if (!encoderContext.hasMoreCharacters()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if (stringBuilder.length() % 3 == 2 && (n6 < 2 || n6 > 2)) {
                    n3 = this.backtrackOneCharacter(encoderContext, stringBuilder, stringBuilder2, n3);
                }
                while (stringBuilder.length() % 3 == 1 && (n3 <= 3 && n6 != 1 || n3 > 3)) {
                    n3 = this.backtrackOneCharacter(encoderContext, stringBuilder, stringBuilder2, n3);
                }
                break;
            }
            int n7 = stringBuilder.length();
            if (n7 % 3 != 0 || (n2 = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode())) == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n2);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder);
    }

    private int backtrackOneCharacter(EncoderContext encoderContext, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n2) {
        int n3 = stringBuilder.length();
        stringBuilder.delete(n3 - n2, n3);
        --encoderContext.pos;
        char c2 = encoderContext.getCurrentChar();
        n2 = this.encodeChar(c2, stringBuilder2);
        encoderContext.resetSymbolInfo();
        return n2;
    }

    static void writeNextTriplet(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.writeCodewords(C40Encoder.encodeToCodewords(stringBuilder, 0));
        stringBuilder.delete(0, 3);
    }

    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length() / 3 * 2;
        int n3 = stringBuilder.length() % 3;
        int n4 = encoderContext.getCodewordCount() + n2;
        encoderContext.updateSymbolInfo(n4);
        int n5 = encoderContext.getSymbolInfo().getDataCapacity() - n4;
        if (n3 == 2) {
            stringBuilder.append('\u0000');
            while (stringBuilder.length() >= 3) {
                C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
            }
            if (encoderContext.hasMoreCharacters()) {
                encoderContext.writeCodeword('\u00fe');
            }
        } else if (n5 == 1 && n3 == 1) {
            while (stringBuilder.length() >= 3) {
                C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
            }
            if (encoderContext.hasMoreCharacters()) {
                encoderContext.writeCodeword('\u00fe');
            }
            --encoderContext.pos;
        } else if (n3 == 0) {
            while (stringBuilder.length() >= 3) {
                C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
            }
            if (n5 > 0 || encoderContext.hasMoreCharacters()) {
                encoderContext.writeCodeword('\u00fe');
            }
        } else {
            throw new IllegalStateException("Unexpected case. Please report!");
        }
        encoderContext.signalEncoderChange(0);
    }

    int encodeChar(char c2, StringBuilder stringBuilder) {
        if (c2 == ' ') {
            stringBuilder.append('\u0003');
            return 1;
        }
        if (c2 >= '0' && c2 <= '9') {
            stringBuilder.append((char)(c2 - 48 + 4));
            return 1;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            stringBuilder.append((char)(c2 - 65 + 14));
            return 1;
        }
        if (c2 >= '\u0000' && c2 <= '\u001f') {
            stringBuilder.append('\u0000');
            stringBuilder.append(c2);
            return 2;
        }
        if (c2 >= '!' && c2 <= '/') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c2 - 33));
            return 2;
        }
        if (c2 >= ':' && c2 <= '@') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c2 - 58 + 15));
            return 2;
        }
        if (c2 >= '[' && c2 <= '_') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c2 - 91 + 22));
            return 2;
        }
        if (c2 >= '`' && c2 <= '\u007f') {
            stringBuilder.append('\u0002');
            stringBuilder.append((char)(c2 - 96));
            return 2;
        }
        if (c2 >= '\u0080') {
            stringBuilder.append("\u0001\u001e");
            int n2 = 2;
            return n2 += this.encodeChar((char)(c2 - 128), stringBuilder);
        }
        throw new IllegalArgumentException("Illegal character: " + c2);
    }

    private static String encodeToCodewords(CharSequence charSequence, int n2) {
        char c2 = charSequence.charAt(n2);
        char c3 = charSequence.charAt(n2 + 1);
        char c4 = charSequence.charAt(n2 + 2);
        int n3 = 1600 * c2 + 40 * c3 + c4 + 1;
        char c5 = (char)(n3 / 256);
        char c6 = (char)(n3 % 256);
        return new String(new char[]{c5, c6});
    }
}

