/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import java.util.Arrays;

public class DefaultPlacement {
    private final CharSequence codewords;
    private final int numrows;
    private final int numcols;
    private final byte[] bits;

    public DefaultPlacement(CharSequence charSequence, int n2, int n3) {
        this.codewords = charSequence;
        this.numcols = n2;
        this.numrows = n3;
        this.bits = new byte[n2 * n3];
        Arrays.fill(this.bits, (byte)-1);
    }

    final int getNumrows() {
        return this.numrows;
    }

    final int getNumcols() {
        return this.numcols;
    }

    final byte[] getBits() {
        return this.bits;
    }

    public final boolean getBit(int n2, int n3) {
        return this.bits[n3 * this.numcols + n2] == 1;
    }

    final void setBit(int n2, int n3, boolean bl2) {
        this.bits[n3 * this.numcols + n2] = bl2 ? (byte)1 : 0;
    }

    final boolean hasBit(int n2, int n3) {
        return this.bits[n3 * this.numcols + n2] >= 0;
    }

    public final void place() {
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        do {
            if (n3 == this.numrows && n4 == 0) {
                this.corner1(n2++);
            }
            if (n3 == this.numrows - 2 && n4 == 0 && this.numcols % 4 != 0) {
                this.corner2(n2++);
            }
            if (n3 == this.numrows - 2 && n4 == 0 && this.numcols % 8 == 4) {
                this.corner3(n2++);
            }
            if (n3 == this.numrows + 4 && n4 == 2 && this.numcols % 8 == 0) {
                this.corner4(n2++);
            }
            do {
                if (n3 >= this.numrows || n4 < 0 || this.hasBit(n4, n3)) continue;
                this.utah(n3, n4, n2++);
            } while ((n3 -= 2) >= 0 && (n4 += 2) < this.numcols);
            ++n3;
            n4 += 3;
            do {
                if (n3 < 0 || n4 >= this.numcols || this.hasBit(n4, n3)) continue;
                this.utah(n3, n4, n2++);
            } while ((n3 += 2) < this.numrows && (n4 -= 2) >= 0);
        } while ((n3 += 3) < this.numrows || ++n4 < this.numcols);
        if (!this.hasBit(this.numcols - 1, this.numrows - 1)) {
            this.setBit(this.numcols - 1, this.numrows - 1, true);
            this.setBit(this.numcols - 2, this.numrows - 2, true);
        }
    }

    private void module(int n2, int n3, int n4, int n5) {
        if (n2 < 0) {
            n2 += this.numrows;
            n3 += 4 - (this.numrows + 4) % 8;
        }
        if (n3 < 0) {
            n3 += this.numcols;
            n2 += 4 - (this.numcols + 4) % 8;
        }
        int n6 = this.codewords.charAt(n4);
        this.setBit(n3, n2, (n6 &= 1 << 8 - n5) != 0);
    }

    private void utah(int n2, int n3, int n4) {
        this.module(n2 - 2, n3 - 2, n4, 1);
        this.module(n2 - 2, n3 - 1, n4, 2);
        this.module(n2 - 1, n3 - 2, n4, 3);
        this.module(n2 - 1, n3 - 1, n4, 4);
        this.module(n2 - 1, n3, n4, 5);
        this.module(n2, n3 - 2, n4, 6);
        this.module(n2, n3 - 1, n4, 7);
        this.module(n2, n3, n4, 8);
    }

    private void corner1(int n2) {
        this.module(this.numrows - 1, 0, n2, 1);
        this.module(this.numrows - 1, 1, n2, 2);
        this.module(this.numrows - 1, 2, n2, 3);
        this.module(0, this.numcols - 2, n2, 4);
        this.module(0, this.numcols - 1, n2, 5);
        this.module(1, this.numcols - 1, n2, 6);
        this.module(2, this.numcols - 1, n2, 7);
        this.module(3, this.numcols - 1, n2, 8);
    }

    private void corner2(int n2) {
        this.module(this.numrows - 3, 0, n2, 1);
        this.module(this.numrows - 2, 0, n2, 2);
        this.module(this.numrows - 1, 0, n2, 3);
        this.module(0, this.numcols - 4, n2, 4);
        this.module(0, this.numcols - 3, n2, 5);
        this.module(0, this.numcols - 2, n2, 6);
        this.module(0, this.numcols - 1, n2, 7);
        this.module(1, this.numcols - 1, n2, 8);
    }

    private void corner3(int n2) {
        this.module(this.numrows - 3, 0, n2, 1);
        this.module(this.numrows - 2, 0, n2, 2);
        this.module(this.numrows - 1, 0, n2, 3);
        this.module(0, this.numcols - 2, n2, 4);
        this.module(0, this.numcols - 1, n2, 5);
        this.module(1, this.numcols - 1, n2, 6);
        this.module(2, this.numcols - 1, n2, 7);
        this.module(3, this.numcols - 1, n2, 8);
    }

    private void corner4(int n2) {
        this.module(this.numrows - 1, 0, n2, 1);
        this.module(this.numrows - 1, this.numcols - 1, n2, 2);
        this.module(0, this.numcols - 3, n2, 3);
        this.module(0, this.numcols - 2, n2, 4);
        this.module(0, this.numcols - 1, n2, 5);
        this.module(1, this.numcols - 3, n2, 6);
        this.module(1, this.numcols - 2, n2, 7);
        this.module(1, this.numcols - 1, n2, 8);
    }
}

