/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.Dimension;
import com.google.zxing.datamatrix.encoder.ASCIIEncoder;
import com.google.zxing.datamatrix.encoder.Base256Encoder;
import com.google.zxing.datamatrix.encoder.C40Encoder;
import com.google.zxing.datamatrix.encoder.EdifactEncoder;
import com.google.zxing.datamatrix.encoder.Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.datamatrix.encoder.TextEncoder;
import com.google.zxing.datamatrix.encoder.X12Encoder;
import java.util.Arrays;

public final class HighLevelEncoder {
    private static final char PAD = '\u0081';
    static final char LATCH_TO_C40 = '\u00e6';
    static final char LATCH_TO_BASE256 = '\u00e7';
    static final char UPPER_SHIFT = '\u00eb';
    private static final char MACRO_05 = '\u00ec';
    private static final char MACRO_06 = '\u00ed';
    static final char LATCH_TO_ANSIX12 = '\u00ee';
    static final char LATCH_TO_TEXT = '\u00ef';
    static final char LATCH_TO_EDIFACT = '\u00f0';
    static final char C40_UNLATCH = '\u00fe';
    static final char X12_UNLATCH = '\u00fe';
    private static final String MACRO_05_HEADER = "[)>\u001e05\u001d";
    private static final String MACRO_06_HEADER = "[)>\u001e06\u001d";
    private static final String MACRO_TRAILER = "\u001e\u0004";
    static final int ASCII_ENCODATION = 0;
    static final int C40_ENCODATION = 1;
    static final int TEXT_ENCODATION = 2;
    static final int X12_ENCODATION = 3;
    static final int EDIFACT_ENCODATION = 4;
    static final int BASE256_ENCODATION = 5;

    private HighLevelEncoder() {
    }

    private static char randomize253State(char c2, int n2) {
        int n3 = 149 * n2 % 253 + 1;
        int n4 = c2 + n3;
        return n4 <= 254 ? (char)n4 : (char)(n4 - 254);
    }

    public static String encodeHighLevel(String string2) {
        return HighLevelEncoder.encodeHighLevel(string2, SymbolShapeHint.FORCE_NONE, null, null);
    }

    public static String encodeHighLevel(String string2, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2) {
        StringBuilder stringBuilder;
        Encoder[] encoderArray = new Encoder[]{new ASCIIEncoder(), new C40Encoder(), new TextEncoder(), new X12Encoder(), new EdifactEncoder(), new Base256Encoder()};
        EncoderContext encoderContext = new EncoderContext(string2);
        encoderContext.setSymbolShape(symbolShapeHint);
        encoderContext.setSizeConstraints(dimension, dimension2);
        if (string2.startsWith(MACRO_05_HEADER) && string2.endsWith(MACRO_TRAILER)) {
            encoderContext.writeCodeword('\u00ec');
            encoderContext.setSkipAtEnd(2);
            encoderContext.pos += MACRO_05_HEADER.length();
        } else if (string2.startsWith(MACRO_06_HEADER) && string2.endsWith(MACRO_TRAILER)) {
            encoderContext.writeCodeword('\u00ed');
            encoderContext.setSkipAtEnd(2);
            encoderContext.pos += MACRO_06_HEADER.length();
        }
        int n2 = 0;
        while (encoderContext.hasMoreCharacters()) {
            encoderArray[n2].encode(encoderContext);
            if (encoderContext.getNewEncoding() < 0) continue;
            n2 = encoderContext.getNewEncoding();
            encoderContext.resetEncoderSignal();
        }
        int n3 = encoderContext.getCodewordCount();
        encoderContext.updateSymbolInfo();
        int n4 = encoderContext.getSymbolInfo().getDataCapacity();
        if (n3 < n4 && n2 != 0 && n2 != 5) {
            encoderContext.writeCodeword('\u00fe');
        }
        if ((stringBuilder = encoderContext.getCodewords()).length() < n4) {
            stringBuilder.append('\u0081');
        }
        while (stringBuilder.length() < n4) {
            stringBuilder.append(HighLevelEncoder.randomize253State('\u0081', stringBuilder.length() + 1));
        }
        return encoderContext.getCodewords().toString();
    }

    static int lookAheadTest(CharSequence charSequence, int n2, int n3) {
        float[] fArray;
        if (n2 >= charSequence.length()) {
            return n3;
        }
        if (n3 == 0) {
            fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.25f};
        } else {
            fArray = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.25f};
            fArray[n3] = 0.0f;
        }
        int n4 = 0;
        while (true) {
            int n5;
            Object[] objectArray;
            Object[] objectArray2;
            if (n2 + n4 == charSequence.length()) {
                int n6 = Integer.MAX_VALUE;
                objectArray2 = new byte[6];
                objectArray = new int[6];
                int n7 = HighLevelEncoder.findMinimums(fArray, objectArray, n6, objectArray2);
                n5 = HighLevelEncoder.getMinimumCount(objectArray2);
                if (objectArray[0] == n7) {
                    return 0;
                }
                if (n5 == 1 && objectArray2[5] > 0) {
                    return 5;
                }
                if (n5 == 1 && objectArray2[4] > 0) {
                    return 4;
                }
                if (n5 == 1 && objectArray2[2] > 0) {
                    return 2;
                }
                if (n5 == 1 && objectArray2[3] > 0) {
                    return 3;
                }
                return 1;
            }
            char c2 = charSequence.charAt(n2 + n4);
            ++n4;
            if (HighLevelEncoder.isDigit(c2)) {
                fArray[0] = (float)((double)fArray[0] + 0.5);
            } else if (HighLevelEncoder.isExtendedASCII(c2)) {
                fArray[0] = (int)Math.ceil(fArray[0]);
                fArray[0] = fArray[0] + 2.0f;
            } else {
                fArray[0] = (int)Math.ceil(fArray[0]);
                fArray[0] = fArray[0] + 1.0f;
            }
            fArray[1] = HighLevelEncoder.isNativeC40(c2) ? fArray[1] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[1] + 2.6666667f : fArray[1] + 1.3333334f);
            fArray[2] = HighLevelEncoder.isNativeText(c2) ? fArray[2] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[2] + 2.6666667f : fArray[2] + 1.3333334f);
            fArray[3] = HighLevelEncoder.isNativeX12(c2) ? fArray[3] + 0.6666667f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[3] + 4.3333335f : fArray[3] + 3.3333333f);
            fArray[4] = HighLevelEncoder.isNativeEDIFACT(c2) ? fArray[4] + 0.75f : (HighLevelEncoder.isExtendedASCII(c2) ? fArray[4] + 4.25f : fArray[4] + 3.25f);
            fArray[5] = HighLevelEncoder.isSpecialB256(c2) ? fArray[5] + 4.0f : fArray[5] + 1.0f;
            if (n4 < 4) continue;
            objectArray2 = new int[6];
            objectArray = new byte[6];
            HighLevelEncoder.findMinimums(fArray, objectArray2, Integer.MAX_VALUE, (byte[])objectArray);
            n5 = HighLevelEncoder.getMinimumCount((byte[])objectArray);
            if (objectArray2[0] < objectArray2[5] && objectArray2[0] < objectArray2[1] && objectArray2[0] < objectArray2[2] && objectArray2[0] < objectArray2[3] && objectArray2[0] < objectArray2[4]) {
                return 0;
            }
            if (objectArray2[5] < objectArray2[0] || objectArray[1] + objectArray[2] + objectArray[3] + objectArray[4] == 0) {
                return 5;
            }
            if (n5 == 1 && objectArray[4] > 0) {
                return 4;
            }
            if (n5 == 1 && objectArray[2] > 0) {
                return 2;
            }
            if (n5 == 1 && objectArray[3] > 0) {
                return 3;
            }
            if (objectArray2[1] + 1 >= objectArray2[0] || objectArray2[1] + 1 >= objectArray2[5] || objectArray2[1] + 1 >= objectArray2[4] || objectArray2[1] + 1 >= objectArray2[2]) continue;
            if (objectArray2[1] < objectArray2[3]) {
                return 1;
            }
            if (objectArray2[1] == objectArray2[3]) break;
        }
        for (int i2 = n2 + n4 + 1; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (HighLevelEncoder.isX12TermSep(c2)) {
                return 3;
            }
            if (!HighLevelEncoder.isNativeX12(c2)) break;
        }
        return 1;
    }

    private static int findMinimums(float[] fArray, int[] nArray, int n2, byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = (int)Math.ceil(fArray[i2]);
            int n3 = nArray[i2];
            if (n2 > n3) {
                n2 = n3;
                Arrays.fill(byArray, (byte)0);
            }
            if (n2 != n3) continue;
            int n4 = i2;
            byArray[n4] = (byte)(byArray[n4] + 1);
        }
        return n2;
    }

    private static int getMinimumCount(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            n2 += byArray[i2];
        }
        return n2;
    }

    static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    static boolean isExtendedASCII(char c2) {
        return c2 >= '\u0080' && c2 <= '\u00ff';
    }

    private static boolean isNativeC40(char c2) {
        return c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isNativeText(char c2) {
        return c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isNativeX12(char c2) {
        return HighLevelEncoder.isX12TermSep(c2) || c2 == ' ' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isX12TermSep(char c2) {
        return c2 == '\r' || c2 == '*' || c2 == '>';
    }

    private static boolean isNativeEDIFACT(char c2) {
        return c2 >= ' ' && c2 <= '^';
    }

    private static boolean isSpecialB256(char c2) {
        return false;
    }

    public static int determineConsecutiveDigitCount(CharSequence charSequence, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = charSequence.length();
        if (n4 < n5) {
            char c2 = charSequence.charAt(n4);
            while (HighLevelEncoder.isDigit(c2) && n4 < n5) {
                ++n3;
                if (++n4 >= n5) continue;
                c2 = charSequence.charAt(n4);
            }
        }
        return n3;
    }

    static void illegalCharacter(char c2) {
        String string2 = Integer.toHexString(c2);
        string2 = "0000".substring(0, 4 - string2.length()) + string2;
        throw new IllegalArgumentException("Illegal character: " + c2 + " (0x" + string2 + ')');
    }
}

