/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.maxicode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.maxicode.decoder.BitMatrixParser;
import com.google.zxing.maxicode.decoder.DecodedBitStreamParser;
import java.util.Map;

public final class Decoder {
    private static final int ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.MAXICODE_FIELD_64);

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        byte[] byArray;
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        byte[] byArray2 = bitMatrixParser.readCodewords();
        this.correctErrors(byArray2, 0, 10, 10, 0);
        int n2 = byArray2[0] & 0xF;
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                this.correctErrors(byArray2, 20, 84, 40, 1);
                this.correctErrors(byArray2, 20, 84, 40, 2);
                byArray = new byte[94];
                break;
            }
            case 5: {
                this.correctErrors(byArray2, 20, 68, 56, 1);
                this.correctErrors(byArray2, 20, 68, 56, 2);
                byArray = new byte[78];
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        System.arraycopy(byArray2, 0, byArray, 0, 10);
        System.arraycopy(byArray2, 20, byArray, 10, byArray.length - 10);
        return DecodedBitStreamParser.decode(byArray, n2);
    }

    private void correctErrors(byte[] byArray, int n2, int n3, int n4, int n5) throws ChecksumException {
        int n6;
        int n7 = n3 + n4;
        int n8 = n5 == 0 ? 1 : 2;
        int[] nArray = new int[n7 / n8];
        for (n6 = 0; n6 < n7; ++n6) {
            if (n5 != 0 && n6 % 2 != n5 - 1) continue;
            nArray[n6 / n8] = byArray[n6 + n2] & 0xFF;
        }
        try {
            this.rsDecoder.decode(nArray, n4 / n8);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n6 = 0; n6 < n3; ++n6) {
            if (n5 != 0 && n6 % 2 != n5 - 1) continue;
            byArray[n6 + n2] = (byte)nArray[n6 / n8];
        }
    }
}

