/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import java.util.Map;

public final class ByQuadrantReader
implements Reader {
    private final Reader delegate;

    public ByQuadrantReader(Reader reader) {
        this.delegate = reader;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n2 = binaryBitmap.getWidth();
        int n3 = binaryBitmap.getHeight();
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        BinaryBitmap binaryBitmap2 = binaryBitmap.crop(0, 0, n4, n5);
        try {
            return this.delegate.decode(binaryBitmap2, map);
        }
        catch (NotFoundException notFoundException) {
            BinaryBitmap binaryBitmap3 = binaryBitmap.crop(n4, 0, n4, n5);
            try {
                return this.delegate.decode(binaryBitmap3, map);
            }
            catch (NotFoundException notFoundException2) {
                BinaryBitmap binaryBitmap4 = binaryBitmap.crop(0, n5, n4, n5);
                try {
                    return this.delegate.decode(binaryBitmap4, map);
                }
                catch (NotFoundException notFoundException3) {
                    BinaryBitmap binaryBitmap5 = binaryBitmap.crop(n4, n5, n4, n5);
                    try {
                        return this.delegate.decode(binaryBitmap5, map);
                    }
                    catch (NotFoundException notFoundException4) {
                        int n6 = n4 / 2;
                        int n7 = n5 / 2;
                        BinaryBitmap binaryBitmap6 = binaryBitmap.crop(n6, n7, n4, n5);
                        return this.delegate.decode(binaryBitmap6, map);
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

