/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.multi.qrcode.detector.MultiDetector;
import com.google.zxing.qrcode.QRCodeReader;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class QRCodeMultiReader
extends QRCodeReader
implements MultipleBarcodeReader {
    private static final Result[] EMPTY_RESULT_ARRAY = new Result[0];
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException {
        DetectorResult[] detectorResultArray;
        List<Result> list = new ArrayList<Result>();
        for (DetectorResult detectorResult : detectorResultArray = new MultiDetector(binaryBitmap.getBlackMatrix()).detectMulti(map)) {
            try {
                String string2;
                DecoderResult decoderResult = this.getDecoder().decode(detectorResult.getBits(), map);
                ResultPoint[] resultPointArray = detectorResult.getPoints();
                if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
                    ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(resultPointArray);
                }
                Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
                List<byte[]> list2 = decoderResult.getByteSegments();
                if (list2 != null) {
                    result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, list2);
                }
                if ((string2 = decoderResult.getECLevel()) != null) {
                    result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string2);
                }
                if (decoderResult.hasStructuredAppend()) {
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
                    result.putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
                }
                list.add(result);
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
        }
        if (list.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        list = QRCodeMultiReader.processStructuredAppend(list);
        return list.toArray(new Result[list.size()]);
    }

    private static List<Result> processStructuredAppend(List<Result> list) {
        Object object;
        Object object22;
        boolean bl2 = false;
        for (Result object42 : list) {
            if (!object42.getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Result> arrayList2 = new ArrayList<Result>();
        for (Result n2 : list) {
            arrayList.add(n2);
            if (!n2.getResultMetadata().containsKey((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)) continue;
            arrayList2.add(n2);
        }
        Collections.sort(arrayList2, new SAComparator());
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        for (Object object22 : arrayList2) {
            stringBuilder.append(((Result)object22).getText());
            n2 += ((Result)object22).getRawBytes().length;
            if (!((Result)object22).getResultMetadata().containsKey((Object)ResultMetadataType.BYTE_SEGMENTS)) continue;
            Iterable n4 = (Iterable)((Result)object22).getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS);
            Iterator n5 = n4.iterator();
            while (n5.hasNext()) {
                object = (byte[])n5.next();
                n3 += ((Object)object).length;
            }
        }
        Object object3 = new byte[n2];
        object22 = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        for (Object object4 : arrayList2) {
            System.arraycopy(((Result)object4).getRawBytes(), 0, object3, n4, ((Result)object4).getRawBytes().length);
            n4 += ((Result)object4).getRawBytes().length;
            if (!((Result)object4).getResultMetadata().containsKey((Object)ResultMetadataType.BYTE_SEGMENTS)) continue;
            Iterable iterable = (Iterable)((Result)object4).getResultMetadata().get((Object)ResultMetadataType.BYTE_SEGMENTS);
            for (byte[] byArray : iterable) {
                System.arraycopy(byArray, 0, object22, n5, byArray.length);
                n5 += byArray.length;
            }
        }
        object = new Result(stringBuilder.toString(), (byte[])object3, NO_POINTS, BarcodeFormat.QR_CODE);
        if (n3 > 0) {
            Object object4;
            object4 = new ArrayList();
            object4.add(object22);
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, object4);
        }
        arrayList.add(object);
        return arrayList;
    }

    private static final class SAComparator
    implements Serializable,
    Comparator<Result> {
        private SAComparator() {
        }

        @Override
        public int compare(Result result, Result result2) {
            int n2;
            int n3 = (Integer)result.getResultMetadata().get((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE);
            if (n3 < (n2 = ((Integer)result2.getResultMetadata().get((Object)ResultMetadataType.STRUCTURED_APPEND_SEQUENCE)).intValue())) {
                return -1;
            }
            if (n3 > n2) {
                return 1;
            }
            return 0;
        }
    }
}

