/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectMutipleBestPatterns() throws NotFoundException {
        List<FinderPattern> list = this.getPossibleCenters();
        int n2 = list.size();
        if (n2 < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n2 == 3) {
            return new FinderPattern[][]{{list.get(0), list.get(1), list.get(2)}};
        }
        Collections.sort(list, new ModuleSizeComparator());
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        block0: for (int i2 = 0; i2 < n2 - 2; ++i2) {
            FinderPattern finderPattern = list.get(i2);
            if (finderPattern == null) continue;
            block1: for (int i3 = i2 + 1; i3 < n2 - 1; ++i3) {
                FinderPattern finderPattern2 = list.get(i3);
                if (finderPattern2 == null) continue;
                float f2 = (finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                float f3 = Math.abs(finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize());
                if (f3 > 0.5f && f2 >= 0.05f) continue block0;
                for (int i4 = i3 + 1; i4 < n2; ++i4) {
                    float f4;
                    float f5;
                    float f6;
                    FinderPattern finderPattern3 = list.get(i4);
                    if (finderPattern3 == null) continue;
                    float f7 = (finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), finderPattern3.getEstimatedModuleSize());
                    float f8 = Math.abs(finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize());
                    if (f8 > 0.5f && f7 >= 0.05f) continue block1;
                    ResultPoint[] resultPointArray = new FinderPattern[]{finderPattern, finderPattern2, finderPattern3};
                    ResultPoint.orderBestPatterns(resultPointArray);
                    FinderPatternInfo finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
                    float f9 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getBottomLeft());
                    float f10 = ResultPoint.distance(finderPatternInfo.getTopRight(), finderPatternInfo.getBottomLeft());
                    float f11 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getTopRight());
                    float f12 = (f9 + f11) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                    if (f12 > 180.0f || f12 < 9.0f || (f6 = Math.abs((f9 - f11) / Math.min(f9, f11))) >= 0.1f || (f5 = Math.abs((f10 - (f4 = (float)Math.sqrt(f9 * f9 + f11 * f11))) / Math.min(f10, f4))) >= 0.1f) continue;
                    arrayList.add(resultPointArray);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            return (FinderPattern[][])arrayList.toArray((T[])new FinderPattern[arrayList.size()][]);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> map) throws NotFoundException {
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl3 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        BitMatrix bitMatrix = this.getImage();
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        int n4 = (int)((float)n2 / 228.0f * 3.0f);
        if (n4 < 3 || bl2) {
            n4 = 3;
        }
        int[] nArray = new int[5];
        for (int i2 = n4 - 1; i2 < n2; i2 += n4) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n5 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (bitMatrix.get(i3, i2)) {
                    if (n5 & true) {
                        // empty if block
                    }
                    int n6 = ++n5;
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                if (!(n5 & true)) {
                    if (n5 == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(nArray) && this.handlePossibleCenter(nArray, i2, i3, bl3)) {
                            n5 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = nArray[3];
                        nArray[2] = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n5 = 3;
                        continue;
                    }
                    int n7 = ++n5;
                    nArray[n7] = nArray[n7] + 1;
                    continue;
                }
                int n8 = n5;
                nArray[n8] = nArray[n8] + 1;
            }
            if (!MultiFinderPatternFinder.foundPatternCross(nArray)) continue;
            this.handlePossibleCenter(nArray, i2, n3, bl3);
        }
        FinderPattern[][] finderPatternArray = this.selectMutipleBestPatterns();
        ArrayList<FinderPatternInfo> arrayList = new ArrayList<FinderPatternInfo>();
        for (ResultPoint[] resultPointArray : finderPatternArray) {
            ResultPoint.orderBestPatterns(resultPointArray);
            arrayList.add(new FinderPatternInfo((FinderPattern[])resultPointArray));
        }
        if (arrayList.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        return arrayList.toArray(new FinderPatternInfo[arrayList.size()]);
    }

    private static final class ModuleSizeComparator
    implements Serializable,
    Comparator<FinderPattern> {
        private ModuleSizeComparator() {
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            float f2 = finderPattern2.getEstimatedModuleSize() - finderPattern.getEstimatedModuleSize();
            return (double)f2 < 0.0 ? -1 : ((double)f2 > 0.0 ? 1 : 0);
        }
    }
}

