/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class CodaBarReader
extends OneDReader {
    private static final float MAX_ACCEPTABLE = 2.0f;
    private static final float PADDING = 1.5f;
    private static final String ALPHABET_STRING = "0123456789-$:/.+ABCD";
    static final char[] ALPHABET = "0123456789-$:/.+ABCD".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{3, 6, 9, 96, 18, 66, 33, 36, 48, 72, 12, 24, 69, 81, 84, 21, 26, 41, 11, 14};
    private static final int MIN_CHARACTER_LENGTH = 3;
    private static final char[] STARTEND_ENCODING = new char[]{'A', 'B', 'C', 'D'};
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private int[] counters = new int[80];
    private int counterLength = 0;

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        int n3;
        int n4;
        int n5;
        Arrays.fill(this.counters, 0);
        this.setCounters(bitArray);
        int n6 = n5 = this.findStartPattern();
        this.decodeRowResult.setLength(0);
        do {
            if ((n4 = this.toNarrowWidePattern(n6)) == -1) {
                throw NotFoundException.getNotFoundInstance();
            }
            this.decodeRowResult.append((char)n4);
        } while ((this.decodeRowResult.length() <= 1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n4])) && (n6 += 8) < this.counterLength);
        n4 = this.counters[n6 - 1];
        int n7 = 0;
        for (n3 = -8; n3 < -1; ++n3) {
            n7 += this.counters[n6 + n3];
        }
        if (n6 < this.counterLength && n4 < n7 / 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.validatePattern(n5);
        for (n3 = 0; n3 < this.decodeRowResult.length(); ++n3) {
            this.decodeRowResult.setCharAt(n3, ALPHABET[this.decodeRowResult.charAt(n3)]);
        }
        n3 = this.decodeRowResult.charAt(0);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, (char)n3)) {
            throw NotFoundException.getNotFoundInstance();
        }
        char c2 = this.decodeRowResult.charAt(this.decodeRowResult.length() - 1);
        if (!CodaBarReader.arrayContains(STARTEND_ENCODING, c2)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.decodeRowResult.length() <= 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (map == null || !map.containsKey((Object)DecodeHintType.RETURN_CODABAR_START_END)) {
            this.decodeRowResult.deleteCharAt(this.decodeRowResult.length() - 1);
            this.decodeRowResult.deleteCharAt(0);
        }
        int n8 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            n8 += this.counters[i2];
        }
        float f2 = n8;
        for (int i3 = n5; i3 < n6 - 1; ++i3) {
            n8 += this.counters[i3];
        }
        float f3 = n8;
        return new Result(this.decodeRowResult.toString(), null, new ResultPoint[]{new ResultPoint(f2, n2), new ResultPoint(f3, n2)}, BarcodeFormat.CODABAR);
    }

    void validatePattern(int n2) throws NotFoundException {
        int n3;
        int n4;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[]{0, 0, 0, 0};
        int n5 = this.decodeRowResult.length() - 1;
        int n6 = n2;
        int n7 = 0;
        while (true) {
            int n8 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n7)];
            for (n4 = 6; n4 >= 0; --n4) {
                int n9 = n3 = (n4 & 1) + (n8 & 1) * 2;
                nArray[n9] = nArray[n9] + this.counters[n6 + n4];
                int n10 = n3;
                nArray2[n10] = nArray2[n10] + 1;
                n8 >>= 1;
            }
            if (n7 >= n5) break;
            n6 += 8;
            ++n7;
        }
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        for (n4 = 0; n4 < 2; ++n4) {
            fArray2[n4] = 0.0f;
            fArray2[n4 + 2] = ((float)nArray[n4] / (float)nArray2[n4] + (float)nArray[n4 + 2] / (float)nArray2[n4 + 2]) / 2.0f;
            fArray[n4] = fArray2[n4 + 2];
            fArray[n4 + 2] = ((float)nArray[n4 + 2] * 2.0f + 1.5f) / (float)nArray2[n4 + 2];
        }
        n6 = n2;
        n4 = 0;
        while (true) {
            n3 = CHARACTER_ENCODINGS[this.decodeRowResult.charAt(n4)];
            for (int i2 = 6; i2 >= 0; --i2) {
                int n11 = this.counters[n6 + i2];
                int n12 = (i2 & 1) + (n3 & 1) * 2;
                if ((float)n11 < fArray2[n12] || (float)n11 > fArray[n12]) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n3 >>= 1;
            }
            if (n4 >= n5) break;
            n6 += 8;
            ++n4;
        }
    }

    private void setCounters(BitArray bitArray) throws NotFoundException {
        int n2;
        this.counterLength = 0;
        int n3 = bitArray.getNextUnset(0);
        if (n3 >= (n2 = bitArray.getSize())) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl2 = true;
        int n4 = 0;
        while (n3 < n2) {
            if (bitArray.get(n3) ^ bl2) {
                ++n4;
            } else {
                this.counterAppend(n4);
                n4 = 1;
                bl2 = !bl2;
            }
            ++n3;
        }
        this.counterAppend(n4);
    }

    private void counterAppend(int n2) {
        this.counters[this.counterLength] = n2;
        ++this.counterLength;
        if (this.counterLength >= this.counters.length) {
            int[] nArray = new int[this.counterLength * 2];
            System.arraycopy(this.counters, 0, nArray, 0, this.counterLength);
            this.counters = nArray;
        }
    }

    private int findStartPattern() throws NotFoundException {
        for (int i2 = 1; i2 < this.counterLength; i2 += 2) {
            int n2 = this.toNarrowWidePattern(i2);
            if (n2 == -1 || !CodaBarReader.arrayContains(STARTEND_ENCODING, ALPHABET[n2])) continue;
            int n3 = 0;
            for (int i3 = i2; i3 < i2 + 7; ++i3) {
                n3 += this.counters[i3];
            }
            if (i2 != 1 && this.counters[i2 - 1] < n3 / 2) continue;
            return i2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static boolean arrayContains(char[] cArray, char c2) {
        if (cArray != null) {
            for (char c3 : cArray) {
                if (c3 != c2) continue;
                return true;
            }
        }
        return false;
    }

    private int toNarrowWidePattern(int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n2 + 7;
        if (n8 >= this.counterLength) {
            return -1;
        }
        int[] nArray = this.counters;
        int n9 = 0;
        int n10 = Integer.MAX_VALUE;
        for (n7 = n2; n7 < n8; n7 += 2) {
            n6 = nArray[n7];
            if (n6 < n10) {
                n10 = n6;
            }
            if (n6 <= n9) continue;
            n9 = n6;
        }
        n7 = (n10 + n9) / 2;
        n6 = 0;
        int n11 = Integer.MAX_VALUE;
        for (n5 = n2 + 1; n5 < n8; n5 += 2) {
            n4 = nArray[n5];
            if (n4 < n11) {
                n11 = n4;
            }
            if (n4 <= n6) continue;
            n6 = n4;
        }
        n5 = (n11 + n6) / 2;
        n4 = 128;
        int n12 = 0;
        for (n3 = 0; n3 < 7; ++n3) {
            int n13 = (n3 & 1) == 0 ? n7 : n5;
            n4 >>= 1;
            if (nArray[n2 + n3] <= n13) continue;
            n12 |= n4;
        }
        for (n3 = 0; n3 < CHARACTER_ENCODINGS.length; ++n3) {
            if (CHARACTER_ENCODINGS[n3] != n12) continue;
            return n3;
        }
        return -1;
    }
}

