/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Arrays;

public final class CodaBarWriter
extends OneDimensionalCodeWriter {
    private static final char[] START_END_CHARS = new char[]{'A', 'B', 'C', 'D'};
    private static final char[] ALT_START_END_CHARS = new char[]{'T', 'N', '*', 'E'};
    private static final char[] CHARS_WHICH_ARE_TEN_LENGTH_EACH_AFTER_DECODED = new char[]{'/', ':', '+', '.'};

    @Override
    public boolean[] encode(String string2) {
        boolean bl2;
        if (string2.length() < 2) {
            throw new IllegalArgumentException("Codabar should start/end with start/stop symbols");
        }
        char c2 = Character.toUpperCase(string2.charAt(0));
        char c3 = Character.toUpperCase(string2.charAt(string2.length() - 1));
        boolean bl3 = CodaBarReader.arrayContains(START_END_CHARS, c2) && CodaBarReader.arrayContains(START_END_CHARS, c3);
        boolean bl4 = bl2 = CodaBarReader.arrayContains(ALT_START_END_CHARS, c2) && CodaBarReader.arrayContains(ALT_START_END_CHARS, c3);
        if (!bl3 && !bl2) {
            throw new IllegalArgumentException("Codabar should start/end with " + Arrays.toString(START_END_CHARS) + ", or start/end with " + Arrays.toString(ALT_START_END_CHARS));
        }
        int n2 = 20;
        for (int i2 = 1; i2 < string2.length() - 1; ++i2) {
            if (Character.isDigit(string2.charAt(i2)) || string2.charAt(i2) == '-' || string2.charAt(i2) == '$') {
                n2 += 9;
                continue;
            }
            if (CodaBarReader.arrayContains(CHARS_WHICH_ARE_TEN_LENGTH_EACH_AFTER_DECODED, string2.charAt(i2))) {
                n2 += 10;
                continue;
            }
            throw new IllegalArgumentException("Cannot encode : '" + string2.charAt(i2) + '\'');
        }
        boolean[] blArray = new boolean[n2 += string2.length() - 1];
        int n3 = 0;
        for (int i3 = 0; i3 < string2.length(); ++i3) {
            int n4;
            char c4 = Character.toUpperCase(string2.charAt(i3));
            if (i3 == 0 || i3 == string2.length() - 1) {
                switch (c4) {
                    case 'T': {
                        c4 = 'A';
                        break;
                    }
                    case 'N': {
                        c4 = 'B';
                        break;
                    }
                    case '*': {
                        c4 = 'C';
                        break;
                    }
                    case 'E': {
                        c4 = 'D';
                    }
                }
            }
            int n5 = 0;
            for (n4 = 0; n4 < CodaBarReader.ALPHABET.length; ++n4) {
                if (c4 != CodaBarReader.ALPHABET[n4]) continue;
                n5 = CodaBarReader.CHARACTER_ENCODINGS[n4];
                break;
            }
            n4 = 1;
            int n6 = 0;
            int n7 = 0;
            while (n7 < 7) {
                blArray[n3] = n4;
                ++n3;
                if ((n5 >> 6 - n7 & 1) == 0 || n6 == 1) {
                    n4 = n4 == 0 ? 1 : 0;
                    ++n7;
                    n6 = 0;
                    continue;
                }
                ++n6;
            }
            if (i3 >= string2.length() - 1) continue;
            blArray[n3] = false;
            ++n3;
        }
        return blArray;
    }
}

