/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Reader
extends OneDReader {
    static final int[][] CODE_PATTERNS = new int[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}, {2, 3, 3, 1, 1, 1, 2}};
    private static final float MAX_AVG_VARIANCE = 0.25f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.7f;
    private static final int CODE_SHIFT = 98;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_A = 101;
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_A = 101;
    private static final int CODE_FNC_4_B = 100;
    private static final int CODE_START_A = 103;
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_STOP = 106;

    private static int[] findStartPattern(BitArray bitArray) throws NotFoundException {
        int n2 = bitArray.getSize();
        int n3 = bitArray.getNextSet(0);
        int n4 = 0;
        int[] nArray = new int[6];
        int n5 = n3;
        boolean bl2 = false;
        int n6 = nArray.length;
        for (int i2 = n3; i2 < n2; ++i2) {
            if (bitArray.get(i2) ^ bl2) {
                int n7 = n4;
                nArray[n7] = nArray[n7] + 1;
                continue;
            }
            if (n4 == n6 - 1) {
                float f2 = 0.25f;
                int n8 = -1;
                for (int i3 = 103; i3 <= 105; ++i3) {
                    float f3 = Code128Reader.patternMatchVariance(nArray, CODE_PATTERNS[i3], 0.7f);
                    if (!(f3 < f2)) continue;
                    f2 = f3;
                    n8 = i3;
                }
                if (n8 >= 0 && bitArray.isRange(Math.max(0, n5 - (i2 - n5) / 2), n5, false)) {
                    return new int[]{n5, i2, n8};
                }
                n5 += nArray[0] + nArray[1];
                System.arraycopy(nArray, 2, nArray, 0, n6 - 2);
                nArray[n6 - 2] = 0;
                nArray[n6 - 1] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray[n4] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeCode(BitArray bitArray, int[] nArray, int n2) throws NotFoundException {
        Code128Reader.recordPattern(bitArray, n2, nArray);
        float f2 = 0.25f;
        int n3 = -1;
        for (int i2 = 0; i2 < CODE_PATTERNS.length; ++i2) {
            int[] nArray2 = CODE_PATTERNS[i2];
            float f3 = Code128Reader.patternMatchVariance(nArray, nArray2, 0.7f);
            if (!(f3 < f2)) continue;
            f2 = f3;
            n3 = i2;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException, ChecksumException {
        int n32;
        int n4;
        int n5;
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.ASSUME_GS1);
        int[] nArray = Code128Reader.findStartPattern(bitArray);
        int n6 = nArray[2];
        ArrayList<Byte> arrayList = new ArrayList<Byte>(20);
        arrayList.add((byte)n6);
        switch (n6) {
            case 103: {
                n5 = 101;
                break;
            }
            case 104: {
                n5 = 100;
                break;
            }
            case 105: {
                n5 = 99;
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        boolean bl3 = false;
        int n7 = 0;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n8 = nArray[0];
        int n9 = nArray[1];
        int[] nArray2 = new int[6];
        int n10 = 0;
        int n11 = 0;
        int n12 = n6;
        int n13 = 0;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        while (!bl3) {
            block70: {
                n4 = n7;
                n7 = 0;
                n10 = n11;
                n11 = Code128Reader.decodeCode(bitArray, nArray2, n9);
                arrayList.add((byte)n11);
                if (n11 != 106) {
                    bl4 = true;
                }
                if (n11 != 106) {
                    n12 += ++n13 * n11;
                }
                n8 = n9;
                for (int n32 : nArray2) {
                    n9 += n32;
                }
                switch (n11) {
                    case 103: 
                    case 104: 
                    case 105: {
                        throw FormatException.getFormatInstance();
                    }
                }
                block8 : switch (n5) {
                    case 101: {
                        if (n11 < 64) {
                            if (bl6 == bl5) {
                                stringBuilder.append((char)(32 + n11));
                            } else {
                                stringBuilder.append((char)(32 + n11 + 128));
                            }
                            bl6 = false;
                            break;
                        }
                        if (n11 < 96) {
                            if (bl6 == bl5) {
                                stringBuilder.append((char)(n11 - 64));
                            } else {
                                stringBuilder.append((char)(n11 + 64));
                            }
                            bl6 = false;
                            break;
                        }
                        if (n11 != 106) {
                            bl4 = false;
                        }
                        switch (n11) {
                            case 102: {
                                if (!bl2) break;
                                if (stringBuilder.length() == 0) {
                                    stringBuilder.append("]C1");
                                    break;
                                }
                                stringBuilder.append('\u001d');
                                break;
                            }
                            case 96: 
                            case 97: {
                                break;
                            }
                            case 101: {
                                if (!bl5 && bl6) {
                                    bl5 = true;
                                    bl6 = false;
                                    break;
                                }
                                if (bl5 && bl6) {
                                    bl5 = false;
                                    bl6 = false;
                                    break;
                                }
                                bl6 = true;
                                break;
                            }
                            case 98: {
                                n7 = 1;
                                n5 = 100;
                                break;
                            }
                            case 100: {
                                n5 = 100;
                                break;
                            }
                            case 99: {
                                n5 = 99;
                                break;
                            }
                            case 106: {
                                bl3 = true;
                            }
                        }
                        break;
                    }
                    case 100: {
                        if (n11 < 96) {
                            if (bl6 == bl5) {
                                stringBuilder.append((char)(32 + n11));
                            } else {
                                stringBuilder.append((char)(32 + n11 + 128));
                            }
                            bl6 = false;
                            break;
                        }
                        if (n11 != 106) {
                            bl4 = false;
                        }
                        switch (n11) {
                            case 102: {
                                if (!bl2) break;
                                if (stringBuilder.length() == 0) {
                                    stringBuilder.append("]C1");
                                    break;
                                }
                                stringBuilder.append('\u001d');
                                break;
                            }
                            case 96: 
                            case 97: {
                                break;
                            }
                            case 100: {
                                if (!bl5 && bl6) {
                                    bl5 = true;
                                    bl6 = false;
                                    break;
                                }
                                if (bl5 && bl6) {
                                    bl5 = false;
                                    bl6 = false;
                                    break;
                                }
                                bl6 = true;
                                break;
                            }
                            case 98: {
                                n7 = 1;
                                n5 = 101;
                                break;
                            }
                            case 101: {
                                n5 = 101;
                                break;
                            }
                            case 99: {
                                n5 = 99;
                                break;
                            }
                            case 106: {
                                bl3 = true;
                            }
                        }
                        break;
                    }
                    case 99: {
                        if (n11 < 100) {
                            if (n11 < 10) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(n11);
                            break;
                        }
                        if (n11 != 106) {
                            bl4 = false;
                        }
                        switch (n11) {
                            case 102: {
                                if (bl2) {
                                    if (stringBuilder.length() == 0) {
                                        stringBuilder.append("]C1");
                                        break block8;
                                    }
                                    stringBuilder.append('\u001d');
                                    break block8;
                                }
                                break block70;
                            }
                            case 101: {
                                n5 = 101;
                                break block8;
                            }
                            case 100: {
                                n5 = 100;
                                break block8;
                            }
                            case 106: {
                                bl3 = true;
                            }
                        }
                    }
                }
            }
            if (n4 == 0) continue;
            n5 = n5 == 101 ? 100 : 101;
        }
        n4 = n9 - n8;
        if (!bitArray.isRange(n9 = bitArray.getNextUnset(n9), Math.min(bitArray.getSize(), n9 + (n9 - n8) / 2), false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if ((n12 -= n13 * n10) % 103 != n10) {
            throw ChecksumException.getChecksumInstance();
        }
        int n14 = stringBuilder.length();
        if (n14 == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n14 > 0 && bl4) {
            if (n5 == 99) {
                stringBuilder.delete(n14 - 2, n14);
            } else {
                stringBuilder.delete(n14 - 1, n14);
            }
        }
        float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f3 = (float)n8 + (float)n4 / 2.0f;
        n32 = arrayList.size();
        byte[] byArray = new byte[n32];
        for (int i2 = 0; i2 < n32; ++i2) {
            byArray[i2] = (Byte)arrayList.get(i2);
        }
        return new Result(stringBuilder.toString(), byArray, new ResultPoint[]{new ResultPoint(f2, n2), new ResultPoint(f3, n2)}, BarcodeFormat.CODE_128);
    }
}

