/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_B = 100;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string2, barcodeFormat, n2, n3, map);
    }

    @Override
    public boolean[] encode(String string2) {
        int n2;
        int n3;
        int n4 = string2.length();
        if (n4 < 1 || n4 > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n4);
        }
        block9: for (int i2 = 0; i2 < n4; ++i2) {
            n3 = string2.charAt(i2);
            if (n3 >= 32 && n3 <= 126) continue;
            switch (n3) {
                case 241: 
                case 242: 
                case 243: 
                case 244: {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Bad character in input: " + (char)n3);
                }
            }
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        n3 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            n2 = n6 == 99 ? 2 : 4;
            int n9 = Code128Writer.isDigits(string2, n7, n2) ? 99 : 100;
            if (n9 == n6) {
                switch (string2.charAt(n7)) {
                    case '\u00f1': {
                        n8 = 102;
                        break;
                    }
                    case '\u00f2': {
                        n8 = 97;
                        break;
                    }
                    case '\u00f3': {
                        n8 = 96;
                        break;
                    }
                    case '\u00f4': {
                        n8 = 100;
                        break;
                    }
                    default: {
                        if (n6 == 100) {
                            n8 = string2.charAt(n7) - 32;
                            break;
                        }
                        n8 = Integer.parseInt(string2.substring(n7, n7 + 2));
                        ++n7;
                    }
                }
                ++n7;
            } else {
                n8 = n6 == 0 ? (n9 == 100 ? 104 : 105) : n9;
                n6 = n9;
            }
            arrayList.add(Code128Reader.CODE_PATTERNS[n8]);
            n3 += n8 * n5;
            if (n7 == 0) continue;
            ++n5;
        }
        arrayList.add(Code128Reader.CODE_PATTERNS[n3 %= 103]);
        arrayList.add(Code128Reader.CODE_PATTERNS[106]);
        n2 = 0;
        for (int[] nArray : arrayList) {
            for (int n10 : nArray) {
                n2 += n10;
            }
        }
        Object object = new boolean[n2];
        int n11 = 0;
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            int[] nArray = (int[])object2.next();
            n11 += Code128Writer.appendPattern((boolean[])object, n11, nArray, true);
        }
        return object;
    }

    private static boolean isDigits(CharSequence charSequence, int n2, int n3) {
        int n4 = n2 + n3;
        int n5 = charSequence.length();
        for (int i2 = n2; i2 < n4 && i2 < n5; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= '0' && c2 <= '9') continue;
            if (c2 != '\u00f1') {
                return false;
            }
            ++n4;
        }
        return n4 <= n5;
    }
}

