/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code39Reader
extends OneDReader {
    static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".toCharArray();
    static final int[] CHARACTER_ENCODINGS = new int[]{52, 289, 97, 352, 49, 304, 112, 37, 292, 100, 265, 73, 328, 25, 280, 88, 13, 268, 76, 28, 259, 67, 322, 19, 274, 82, 7, 262, 70, 22, 385, 193, 448, 145, 400, 208, 133, 388, 196, 148, 168, 162, 138, 42};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[39];
    private final boolean usingCheckDigit;
    private final boolean extendedMode;
    private final StringBuilder decodeRowResult;
    private final int[] counters;

    public Code39Reader() {
        this(false);
    }

    public Code39Reader(boolean bl2) {
        this(bl2, false);
    }

    public Code39Reader(boolean bl2, boolean bl3) {
        this.usingCheckDigit = bl2;
        this.extendedMode = bl3;
        this.decodeRowResult = new StringBuilder(20);
        this.counters = new int[9];
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n3;
        int n4;
        char c2;
        int[] nArray = this.counters;
        Arrays.fill(nArray, 0);
        StringBuilder stringBuilder = this.decodeRowResult;
        stringBuilder.setLength(0);
        int[] nArray2 = Code39Reader.findAsteriskPattern(bitArray, nArray);
        int n5 = bitArray.getNextSet(nArray2[1]);
        int n6 = bitArray.getSize();
        do {
            Code39Reader.recordPattern(bitArray, n5, nArray);
            n4 = Code39Reader.toNarrowWidePattern(nArray);
            if (n4 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c2 = Code39Reader.patternToChar(n4);
            stringBuilder.append(c2);
            n3 = n5;
            for (int n7 : nArray) {
                n5 += n7;
            }
            n5 = bitArray.getNextSet(n5);
        } while (c2 != '*');
        stringBuilder.setLength(stringBuilder.length() - 1);
        n4 = 0;
        for (int n7 : nArray) {
            n4 += n7;
        }
        int n8 = n5 - n3 - n4;
        if (n5 != n6 && n8 * 2 < n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.usingCheckDigit) {
            int n9 = stringBuilder.length() - 1;
            int n10 = 0;
            for (int n7 = 0; n7 < n9; ++n7) {
                n10 += ALPHABET_STRING.indexOf(this.decodeRowResult.charAt(n7));
            }
            if (stringBuilder.charAt(n9) != ALPHABET[n10 % 43]) {
                throw ChecksumException.getChecksumInstance();
            }
            stringBuilder.setLength(n9);
        }
        if (stringBuilder.length() == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string2 = this.extendedMode ? Code39Reader.decodeExtended(stringBuilder) : stringBuilder.toString();
        float f2 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        float f3 = (float)n3 + (float)n4 / 2.0f;
        return new Result(string2, null, new ResultPoint[]{new ResultPoint(f2, n2), new ResultPoint(f3, n2)}, BarcodeFormat.CODE_39);
    }

    private static int[] findAsteriskPattern(BitArray bitArray, int[] nArray) throws NotFoundException {
        int n2 = bitArray.getSize();
        int n3 = bitArray.getNextSet(0);
        int n4 = 0;
        int n5 = n3;
        boolean bl2 = false;
        int n6 = nArray.length;
        for (int i2 = n3; i2 < n2; ++i2) {
            if (bitArray.get(i2) ^ bl2) {
                int n7 = n4;
                nArray[n7] = nArray[n7] + 1;
                continue;
            }
            if (n4 == n6 - 1) {
                if (Code39Reader.toNarrowWidePattern(nArray) == ASTERISK_ENCODING && bitArray.isRange(Math.max(0, n5 - (i2 - n5) / 2), n5, false)) {
                    return new int[]{n5, i2};
                }
                n5 += nArray[0] + nArray[1];
                System.arraycopy(nArray, 2, nArray, 0, n6 - 2);
                nArray[n6 - 2] = 0;
                nArray[n6 - 1] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray[n4] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toNarrowWidePattern(int[] nArray) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        do {
            int n5;
            int n62;
            int n7 = Integer.MAX_VALUE;
            for (int n62 : nArray) {
                if (n62 >= n7 || n62 <= n4) continue;
                n7 = n62;
            }
            n4 = n7;
            n2 = 0;
            int n8 = 0;
            int n9 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                n62 = nArray[n5];
                if (n62 <= n4) continue;
                n9 |= 1 << n3 - 1 - n5;
                ++n2;
                n8 += n62;
            }
            if (n2 != 3) continue;
            for (n5 = 0; n5 < n3 && n2 > 0; ++n5) {
                n62 = nArray[n5];
                if (n62 <= n4) continue;
                --n2;
                if (n62 * 2 < n8) continue;
                return -1;
            }
            return n9;
        } while (n2 > 3);
        return -1;
    }

    private static char patternToChar(int n2) throws NotFoundException {
        for (int i2 = 0; i2 < CHARACTER_ENCODINGS.length; ++i2) {
            if (CHARACTER_ENCODINGS[i2] != n2) continue;
            return ALPHABET[i2];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '+' || c2 == '$' || c2 == '%' || c2 == '/') {
                char c3 = charSequence.charAt(i2 + 1);
                int n3 = 0;
                switch (c2) {
                    case '+': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '$': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '%': {
                        if (c3 >= 'A' && c3 <= 'E') {
                            n3 = (char)(c3 - 38);
                            break;
                        }
                        if (c3 >= 'F' && c3 <= 'W') {
                            n3 = (char)(c3 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case '/': {
                        if (c3 >= 'A' && c3 <= 'O') {
                            n3 = (char)(c3 - 32);
                            break;
                        }
                        if (c3 == 'Z') {
                            n3 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuilder.append((char)n3);
                ++i2;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

