/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string2, barcodeFormat, n2, n3, map);
    }

    @Override
    public boolean[] encode(String string2) {
        int n2;
        int n3 = string2.length();
        if (n3 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n3);
        }
        int[] nArray = new int[9];
        int n4 = 25 + n3;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string2.charAt(i2));
            if (n2 < 0) {
                throw new IllegalArgumentException("Bad contents: " + string2);
            }
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n2], nArray);
            for (int n5 : nArray) {
                n4 += n5;
            }
        }
        boolean[] blArray = new boolean[n4];
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n2 = Code39Writer.appendPattern(blArray, 0, nArray, true);
        int[] nArray2 = new int[]{1};
        n2 += Code39Writer.appendPattern(blArray, n2, nArray2, false);
        for (int i3 = 0; i3 < n3; ++i3) {
            int n6 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string2.charAt(i3));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n6], nArray);
            n2 += Code39Writer.appendPattern(blArray, n2, nArray, true);
            n2 += Code39Writer.appendPattern(blArray, n2, nArray2, false);
        }
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        Code39Writer.appendPattern(blArray, n2, nArray, true);
        return blArray;
    }

    private static void toIntArray(int n2, int[] nArray) {
        for (int i2 = 0; i2 < 9; ++i2) {
            int n3 = n2 & 1 << 8 - i2;
            nArray[i2] = n3 == 0 ? 1 : 2;
        }
    }
}

