/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code93Reader
extends OneDReader {
    private static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[47];
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private final int[] counters = new int[6];

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n3;
        int n4;
        char c2;
        int[] nArray = this.findAsteriskPattern(bitArray);
        int n5 = bitArray.getNextSet(nArray[1]);
        int n6 = bitArray.getSize();
        int[] nArray2 = this.counters;
        Arrays.fill(nArray2, 0);
        StringBuilder stringBuilder = this.decodeRowResult;
        stringBuilder.setLength(0);
        do {
            Code93Reader.recordPattern(bitArray, n5, nArray2);
            n4 = Code93Reader.toPattern(nArray2);
            if (n4 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c2 = Code93Reader.patternToChar(n4);
            stringBuilder.append(c2);
            n3 = n5;
            for (int n7 : nArray2) {
                n5 += n7;
            }
            n5 = bitArray.getNextSet(n5);
        } while (c2 != '*');
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        n4 = 0;
        for (int n7 : nArray2) {
            n4 += n7;
        }
        if (n5 == n6 || !bitArray.get(n5)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (stringBuilder.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        Code93Reader.checkChecksums(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - 2);
        String string2 = Code93Reader.decodeExtended(stringBuilder);
        float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f3 = (float)n3 + (float)n4 / 2.0f;
        return new Result(string2, null, new ResultPoint[]{new ResultPoint(f2, n2), new ResultPoint(f3, n2)}, BarcodeFormat.CODE_93);
    }

    private int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n2 = bitArray.getSize();
        int n3 = bitArray.getNextSet(0);
        Arrays.fill(this.counters, 0);
        int[] nArray = this.counters;
        int n4 = n3;
        boolean bl2 = false;
        int n5 = nArray.length;
        int n6 = 0;
        for (int i2 = n3; i2 < n2; ++i2) {
            if (bitArray.get(i2) ^ bl2) {
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                continue;
            }
            if (n6 == n5 - 1) {
                if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                    return new int[]{n4, i2};
                }
                n4 += nArray[0] + nArray[1];
                System.arraycopy(nArray, 2, nArray, 0, n5 - 2);
                nArray[n5 - 2] = 0;
                nArray[n5 - 1] = 0;
                --n6;
            } else {
                ++n6;
            }
            nArray[n6] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n2;
        int n3;
        int n4 = nArray.length;
        int n5 = 0;
        int[] nArray2 = nArray;
        int n6 = nArray2.length;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = nArray2[n3];
            n5 += n2;
        }
        int n7 = 0;
        for (n6 = 0; n6 < n4; ++n6) {
            n3 = Math.round((float)nArray[n6] * 9.0f / (float)n5);
            if (n3 < 1 || n3 > 4) {
                return -1;
            }
            if ((n6 & 1) == 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    n7 = n7 << 1 | 1;
                }
                continue;
            }
            n7 <<= n3;
        }
        return n7;
    }

    private static char patternToChar(int n2) throws NotFoundException {
        for (int i2 = 0; i2 < CHARACTER_ENCODINGS.length; ++i2) {
            if (CHARACTER_ENCODINGS[i2] != n2) continue;
            return ALPHABET[i2];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= 'a' && c2 <= 'd') {
                if (i2 >= n2 - 1) {
                    throw FormatException.getFormatInstance();
                }
                char c3 = charSequence.charAt(i2 + 1);
                int n3 = 0;
                switch (c2) {
                    case 'd': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'a': {
                        if (c3 >= 'A' && c3 <= 'Z') {
                            n3 = (char)(c3 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'b': {
                        if (c3 >= 'A' && c3 <= 'E') {
                            n3 = (char)(c3 - 38);
                            break;
                        }
                        if (c3 >= 'F' && c3 <= 'W') {
                            n3 = (char)(c3 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'c': {
                        if (c3 >= 'A' && c3 <= 'O') {
                            n3 = (char)(c3 - 32);
                            break;
                        }
                        if (c3 == 'Z') {
                            n3 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuilder.append((char)n3);
                ++i2;
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private static void checkChecksums(CharSequence charSequence) throws ChecksumException {
        int n2 = charSequence.length();
        Code93Reader.checkOneChecksum(charSequence, n2 - 2, 20);
        Code93Reader.checkOneChecksum(charSequence, n2 - 1, 15);
    }

    private static void checkOneChecksum(CharSequence charSequence, int n2, int n3) throws ChecksumException {
        int n4 = 1;
        int n5 = 0;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            n5 += n4 * ALPHABET_STRING.indexOf(charSequence.charAt(i2));
            if (++n4 <= n3) continue;
            n4 = 1;
        }
        if (charSequence.charAt(n2) != ALPHABET[n5 % 47]) {
            throw ChecksumException.getChecksumInstance();
        }
    }
}

