/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n2;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n3 = bitArray.getSize();
        int n4 = nArray[1];
        int n5 = 0;
        for (int i2 = 0; i2 < 6 && n4 < n3; ++i2) {
            n2 = EAN13Reader.decodeDigit(bitArray, nArray2, n4, L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n2 % 10));
            for (int n6 : nArray2) {
                n4 += n6;
            }
            if (n2 < 10) continue;
            n5 |= 1 << 5 - i2;
        }
        EAN13Reader.determineFirstDigit(stringBuilder, n5);
        int[] nArray3 = EAN13Reader.findGuardPattern(bitArray, n4, true, MIDDLE_PATTERN);
        n4 = nArray3[1];
        for (n2 = 0; n2 < 6 && n4 < n3; ++n2) {
            int n7 = EAN13Reader.decodeDigit(bitArray, nArray2, n4, L_PATTERNS);
            stringBuilder.append((char)(48 + n7));
            for (int n8 : nArray2) {
                n4 += n8;
            }
        }
        return n4;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuilder stringBuilder, int n2) throws NotFoundException {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (n2 != FIRST_DIGIT_ENCODINGS[i2]) continue;
            stringBuilder.insert(0, (char)(48 + i2));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

