/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Map;

public final class ITFReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.38f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.78f;
    private static final int W = 3;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{6, 8, 10, 12, 14};
    private int narrowLineWidth = -1;
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN_REVERSED = new int[]{1, 1, 3};
    static final int[][] PATTERNS = new int[][]{{1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws FormatException, NotFoundException {
        int[] nArray = this.decodeStart(bitArray);
        int[] nArray2 = this.decodeEnd(bitArray);
        StringBuilder stringBuilder = new StringBuilder(20);
        ITFReader.decodeMiddle(bitArray, nArray[1], nArray2[0], stringBuilder);
        String string2 = stringBuilder.toString();
        int[] nArray3 = null;
        if (map != null) {
            nArray3 = (int[])map.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (nArray3 == null) {
            nArray3 = DEFAULT_ALLOWED_LENGTHS;
        }
        int n3 = string2.length();
        boolean bl2 = false;
        int n4 = 0;
        for (int n5 : nArray3) {
            if (n3 == n5) {
                bl2 = true;
                break;
            }
            if (n5 <= n4) continue;
            n4 = n5;
        }
        if (!bl2 && n3 > n4) {
            bl2 = true;
        }
        if (!bl2) {
            throw FormatException.getFormatInstance();
        }
        return new Result(string2, null, new ResultPoint[]{new ResultPoint(nArray[1], n2), new ResultPoint(nArray2[0], n2)}, BarcodeFormat.ITF);
    }

    private static void decodeMiddle(BitArray bitArray, int n2, int n3, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray = new int[10];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        while (n2 < n3) {
            int n4;
            ITFReader.recordPattern(bitArray, n2, nArray);
            for (n4 = 0; n4 < 5; ++n4) {
                int n5 = 2 * n4;
                nArray2[n4] = nArray[n5];
                nArray3[n4] = nArray[n5 + 1];
            }
            n4 = ITFReader.decodeDigit(nArray2);
            stringBuilder.append((char)(48 + n4));
            n4 = ITFReader.decodeDigit(nArray3);
            stringBuilder.append((char)(48 + n4));
            for (int n6 : nArray) {
                n2 += n6;
            }
        }
    }

    int[] decodeStart(BitArray bitArray) throws NotFoundException {
        int n2 = ITFReader.skipWhiteSpace(bitArray);
        int[] nArray = ITFReader.findGuardPattern(bitArray, n2, START_PATTERN);
        this.narrowLineWidth = (nArray[1] - nArray[0]) / 4;
        this.validateQuietZone(bitArray, nArray[0]);
        return nArray;
    }

    private void validateQuietZone(BitArray bitArray, int n2) throws NotFoundException {
        int n3 = this.narrowLineWidth * 10;
        n3 = n3 < n2 ? n3 : n2;
        for (int i2 = n2 - 1; n3 > 0 && i2 >= 0 && !bitArray.get(i2); --n3, --i2) {
        }
        if (n3 != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static int skipWhiteSpace(BitArray bitArray) throws NotFoundException {
        int n2 = bitArray.getSize();
        int n3 = bitArray.getNextSet(0);
        if (n3 == n2) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] decodeEnd(BitArray bitArray) throws NotFoundException {
        bitArray.reverse();
        try {
            int n2 = ITFReader.skipWhiteSpace(bitArray);
            int[] nArray = ITFReader.findGuardPattern(bitArray, n2, END_PATTERN_REVERSED);
            this.validateQuietZone(bitArray, nArray[0]);
            int n3 = nArray[0];
            nArray[0] = bitArray.getSize() - nArray[1];
            nArray[1] = bitArray.getSize() - n3;
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            bitArray.reverse();
        }
    }

    private static int[] findGuardPattern(BitArray bitArray, int n2, int[] nArray) throws NotFoundException {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int n4 = bitArray.getSize();
        boolean bl2 = false;
        int n5 = 0;
        int n6 = n2;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (bitArray.get(i2) ^ bl2) {
                int n7 = n5;
                nArray2[n7] = nArray2[n7] + 1;
                continue;
            }
            if (n5 == n3 - 1) {
                if (ITFReader.patternMatchVariance(nArray2, nArray, 0.78f) < 0.38f) {
                    return new int[]{n6, i2};
                }
                n6 += nArray2[0] + nArray2[1];
                System.arraycopy(nArray2, 2, nArray2, 0, n3 - 2);
                nArray2[n3 - 2] = 0;
                nArray2[n3 - 1] = 0;
                --n5;
            } else {
                ++n5;
            }
            nArray2[n5] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] nArray) throws NotFoundException {
        float f2 = 0.38f;
        int n2 = -1;
        int n3 = PATTERNS.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int[] nArray2 = PATTERNS[i2];
            float f3 = ITFReader.patternMatchVariance(nArray, nArray2, 0.78f);
            if (!(f3 < f2)) continue;
            f2 = f3;
            n2 = i2;
        }
        if (n2 >= 0) {
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

