/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

public abstract class OneDReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        try {
            return this.doDecode(binaryBitmap, map);
        }
        catch (NotFoundException notFoundException) {
            boolean bl2;
            boolean bl3 = bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
            if (bl2 && binaryBitmap.isRotateSupported()) {
                BinaryBitmap binaryBitmap2 = binaryBitmap.rotateCounterClockwise();
                Result result = this.doDecode(binaryBitmap2, map);
                Map<ResultMetadataType, Object> map2 = result.getResultMetadata();
                int n2 = 270;
                if (map2 != null && map2.containsKey((Object)ResultMetadataType.ORIENTATION)) {
                    n2 = (n2 + (Integer)map2.get((Object)ResultMetadataType.ORIENTATION)) % 360;
                }
                result.putMetadata(ResultMetadataType.ORIENTATION, n2);
                ResultPoint[] resultPointArray = result.getResultPoints();
                if (resultPointArray != null) {
                    int n3 = binaryBitmap2.getHeight();
                    for (int i2 = 0; i2 < resultPointArray.length; ++i2) {
                        resultPointArray[i2] = new ResultPoint((float)n3 - resultPointArray[i2].getY() - 1.0f, resultPointArray[i2].getX());
                    }
                }
                return result;
            }
            throw notFoundException;
        }
    }

    @Override
    public void reset() {
    }

    private Result doDecode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> object) throws NotFoundException {
        int n2 = binaryBitmap.getWidth();
        int n3 = binaryBitmap.getHeight();
        BitArray bitArray = new BitArray(n2);
        int n4 = n3 >> 1;
        boolean bl2 = object != null && object.containsKey((Object)DecodeHintType.TRY_HARDER);
        int n5 = Math.max(1, n3 >> (bl2 ? 8 : 5));
        int n6 = bl2 ? n3 : 15;
        for (int i2 = 0; i2 < n6; ++i2) {
            int n7 = (i2 + 1) / 2;
            boolean bl3 = (i2 & 1) == 0;
            int n8 = n4 + n5 * (bl3 ? n7 : -n7);
            if (n8 < 0 || n8 >= n3) break;
            try {
                bitArray = binaryBitmap.getBlackRow(n8, bitArray);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            for (int i3 = 0; i3 < 2; ++i3) {
                Object object2;
                if (i3 == 1) {
                    bitArray.reverse();
                    if (object != null && object.containsKey((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) {
                        object2 = new EnumMap(DecodeHintType.class);
                        object2.putAll(object);
                        object2.remove((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
                        object = object2;
                    }
                }
                try {
                    object2 = this.decodeRow(n8, bitArray, (Map<DecodeHintType, ?>)object);
                    if (i3 == 1) {
                        ((Result)object2).putMetadata(ResultMetadataType.ORIENTATION, 180);
                        ResultPoint[] resultPointArray = ((Result)object2).getResultPoints();
                        if (resultPointArray != null) {
                            resultPointArray[0] = new ResultPoint((float)n2 - resultPointArray[0].getX() - 1.0f, resultPointArray[0].getY());
                            resultPointArray[1] = new ResultPoint((float)n2 - resultPointArray[1].getX() - 1.0f, resultPointArray[1].getY());
                        }
                    }
                    return object2;
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static void recordPattern(BitArray bitArray, int n2, int[] nArray) throws NotFoundException {
        int n3;
        int n4 = nArray.length;
        Arrays.fill(nArray, 0, n4, 0);
        int n5 = bitArray.getSize();
        if (n2 >= n5) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl2 = !bitArray.get(n2);
        int n6 = 0;
        for (n3 = n2; n3 < n5; ++n3) {
            if (bitArray.get(n3) ^ bl2) {
                int n7 = n6;
                nArray[n7] = nArray[n7] + 1;
                continue;
            }
            if (++n6 == n4) break;
            nArray[n6] = 1;
            bl2 = !bl2;
        }
        if (n6 != n4 && (n6 != n4 - 1 || n3 != n5)) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    protected static void recordPatternInReverse(BitArray bitArray, int n2, int[] nArray) throws NotFoundException {
        int n3 = nArray.length;
        boolean bl2 = bitArray.get(n2);
        while (n2 > 0 && n3 >= 0) {
            if (bitArray.get(--n2) == bl2) continue;
            --n3;
            bl2 = !bl2;
        }
        if (n3 >= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        OneDReader.recordPattern(bitArray, n2 + 1, nArray);
    }

    protected static float patternMatchVariance(int[] nArray, int[] nArray2, float f2) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += nArray[i2];
            n4 += nArray2[i2];
        }
        if (n3 < n4) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = (float)n3 / (float)n4;
        f2 *= f3;
        float f4 = 0.0f;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f5;
            int n5 = nArray[i3];
            float f6 = (float)nArray2[i3] * f3;
            float f7 = f5 = (float)n5 > f6 ? (float)n5 - f6 : f6 - (float)n5;
            if (f5 > f2) {
                return Float.POSITIVE_INFINITY;
            }
            f4 += f5;
        }
        return f4 / (float)n3;
    }

    public abstract Result decodeRow(int var1, BitArray var2, Map<DecodeHintType, ?> var3) throws NotFoundException, ChecksumException, FormatException;
}

