/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.Map;

public abstract class OneDimensionalCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        Object object;
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Negative size is not allowed. Input: " + n2 + 'x' + n3);
        }
        int n4 = this.getDefaultMargin();
        if (map != null && (object = (Object)((Integer)map.get((Object)EncodeHintType.MARGIN))) != null) {
            n4 = (Integer)object;
        }
        object = this.encode(string2);
        return OneDimensionalCodeWriter.renderResult((boolean[])object, n2, n3, n4);
    }

    private static BitMatrix renderResult(boolean[] blArray, int n2, int n3, int n4) {
        int n5 = blArray.length;
        int n6 = n5 + n4;
        int n7 = Math.max(n2, n6);
        int n8 = Math.max(1, n3);
        int n9 = n7 / n6;
        int n10 = (n7 - n5 * n9) / 2;
        BitMatrix bitMatrix = new BitMatrix(n7, n8);
        int n11 = 0;
        int n12 = n10;
        while (n11 < n5) {
            if (blArray[n11]) {
                bitMatrix.setRegion(n12, 0, n9, n8);
            }
            ++n11;
            n12 += n9;
        }
        return bitMatrix;
    }

    protected static int appendPattern(boolean[] blArray, int n2, int[] nArray, boolean bl2) {
        boolean bl3 = bl2;
        int n3 = 0;
        for (int n4 : nArray) {
            for (int i2 = 0; i2 < n4; ++i2) {
                blArray[n2++] = bl3;
            }
            n3 += n4;
            bl3 = !bl3;
        }
        return n3;
    }

    public int getDefaultMargin() {
        return 10;
    }

    public abstract boolean[] encode(String var1);
}

