/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension2Support {
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension2Support() {
    }

    Result decodeRow(int n2, BitArray bitArray, int[] nArray) throws NotFoundException {
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n3 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        String string2 = stringBuilder.toString();
        Map<ResultMetadataType, Object> map = UPCEANExtension2Support.parseExtensionString(string2);
        Result result = new Result(string2, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n2), new ResultPoint(n3, n2)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (map != null) {
            result.putAllMetadata(map);
        }
        return result;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n2 = bitArray.getSize();
        int n3 = nArray[1];
        int n4 = 0;
        for (int i2 = 0; i2 < 2 && n3 < n2; ++i2) {
            int n5 = UPCEANReader.decodeDigit(bitArray, nArray2, n3, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n5 % 10));
            for (int n6 : nArray2) {
                n3 += n6;
            }
            if (n5 >= 10) {
                n4 |= 1 << 1 - i2;
            }
            if (i2 == 1) continue;
            n3 = bitArray.getNextSet(n3);
            n3 = bitArray.getNextUnset(n3);
        }
        if (stringBuilder.length() != 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (Integer.parseInt(stringBuilder.toString()) % 4 != n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n3;
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String string2) {
        if (string2.length() != 2) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> enumMap = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.ISSUE_NUMBER, Integer.valueOf(string2));
        return enumMap;
    }
}

