/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    Result decodeRow(int n2, BitArray bitArray, int[] nArray) throws NotFoundException {
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n3 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        String string2 = stringBuilder.toString();
        Map<ResultMetadataType, Object> map = UPCEANExtension5Support.parseExtensionString(string2);
        Result result = new Result(string2, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n2), new ResultPoint(n3, n2)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (map != null) {
            result.putAllMetadata(map);
        }
        return result;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n2;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n3 = bitArray.getSize();
        int n4 = nArray[1];
        int n5 = 0;
        for (n2 = 0; n2 < 5 && n4 < n3; ++n2) {
            int n6 = UPCEANReader.decodeDigit(bitArray, nArray2, n4, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n6 % 10));
            for (int n7 : nArray2) {
                n4 += n7;
            }
            if (n6 >= 10) {
                n5 |= 1 << 4 - n2;
            }
            if (n2 == 4) continue;
            n4 = bitArray.getNextSet(n4);
            n4 = bitArray.getNextUnset(n4);
        }
        if (stringBuilder.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        n2 = UPCEANExtension5Support.determineCheckDigit(n5);
        if (UPCEANExtension5Support.extensionChecksum(stringBuilder.toString()) != n2) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n4;
    }

    private static int extensionChecksum(CharSequence charSequence) {
        int n2;
        int n3 = charSequence.length();
        int n4 = 0;
        for (n2 = n3 - 2; n2 >= 0; n2 -= 2) {
            n4 += charSequence.charAt(n2) - 48;
        }
        n4 *= 3;
        for (n2 = n3 - 1; n2 >= 0; n2 -= 2) {
            n4 += charSequence.charAt(n2) - 48;
        }
        return (n4 *= 3) % 10;
    }

    private static int determineCheckDigit(int n2) throws NotFoundException {
        for (int i2 = 0; i2 < 10; ++i2) {
            if (n2 != CHECK_DIGIT_ENCODINGS[i2]) continue;
            return i2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String string2) {
        if (string2.length() != 5) {
            return null;
        }
        String string3 = UPCEANExtension5Support.parseExtension5String(string2);
        if (string3 == null) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> enumMap = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.SUGGESTED_PRICE, string3);
        return enumMap;
    }

    private static String parseExtension5String(String string2) {
        String string3;
        switch (string2.charAt(0)) {
            case '0': {
                string3 = "\u00a3";
                break;
            }
            case '5': {
                string3 = "$";
                break;
            }
            case '9': {
                if ("90000".equals(string2)) {
                    return null;
                }
                if ("99991".equals(string2)) {
                    return "0.00";
                }
                if ("99990".equals(string2)) {
                    return "Used";
                }
                string3 = "";
                break;
            }
            default: {
                string3 = "";
            }
        }
        int n2 = Integer.parseInt(string2.substring(1));
        String string4 = String.valueOf(n2 / 100);
        int n3 = n2 % 100;
        String string5 = n3 < 10 ? "0" + n3 : String.valueOf(n3);
        return string3 + string4 + '.' + string5;
    }
}

