/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EANManufacturerOrgSupport;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.UPCEANExtensionSupport;
import java.util.Arrays;
import java.util.Map;

public abstract class UPCEANReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.48f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.7f;
    static final int[] START_END_PATTERN = new int[]{1, 1, 1};
    static final int[] MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
    static final int[][] L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    static final int[][] L_AND_G_PATTERNS = new int[20][];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder(20);
    private final UPCEANExtensionSupport extensionReader = new UPCEANExtensionSupport();
    private final EANManufacturerOrgSupport eanManSupport = new EANManufacturerOrgSupport();

    protected UPCEANReader() {
    }

    static int[] findStartGuardPattern(BitArray bitArray) throws NotFoundException {
        boolean bl2 = false;
        int[] nArray = null;
        int n2 = 0;
        int[] nArray2 = new int[START_END_PATTERN.length];
        while (!bl2) {
            Arrays.fill(nArray2, 0, START_END_PATTERN.length, 0);
            nArray = UPCEANReader.findGuardPattern(bitArray, n2, false, START_END_PATTERN, nArray2);
            int n3 = nArray[0];
            int n4 = n3 - ((n2 = nArray[1]) - n3);
            if (n4 < 0) continue;
            bl2 = bitArray.isRange(n4, n3, false);
        }
        return nArray;
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(n2, bitArray, UPCEANReader.findStartGuardPattern(bitArray), map);
    }

    public Result decodeRow(int n2, BitArray bitArray, int[] nArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        String string2;
        Result result;
        int n3;
        int n4;
        ResultPointCallback resultPointCallback;
        ResultPointCallback resultPointCallback2 = resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n2));
        }
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n5 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(n5, n2));
        }
        int[] nArray2 = this.decodeEnd(bitArray, n5);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray2[0] + nArray2[1]) / 2.0f, n2));
        }
        if ((n4 = (n3 = nArray2[1]) + (n3 - nArray2[0])) >= bitArray.getSize() || !bitArray.isRange(n3, n4, false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string3 = stringBuilder.toString();
        if (string3.length() < 8) {
            throw FormatException.getFormatInstance();
        }
        if (!this.checkChecksum(string3)) {
            throw ChecksumException.getChecksumInstance();
        }
        float f2 = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f3 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        BarcodeFormat barcodeFormat = this.getBarcodeFormat();
        Result result2 = new Result(string3, null, new ResultPoint[]{new ResultPoint(f2, n2), new ResultPoint(f3, n2)}, barcodeFormat);
        int n6 = 0;
        try {
            result = this.extensionReader.decodeRow(n2, bitArray, nArray2[1]);
            result2.putMetadata(ResultMetadataType.UPC_EAN_EXTENSION, result.getText());
            result2.putAllMetadata(result.getResultMetadata());
            result2.addResultPoints(result.getResultPoints());
            n6 = result.getText().length();
        }
        catch (ReaderException readerException) {
            // empty catch block
        }
        Result result3 = result = map == null ? null : (Result)((int[])map.get((Object)DecodeHintType.ALLOWED_EAN_EXTENSIONS));
        if (result != null) {
            boolean bl2 = false;
            for (Result result4 : result) {
                if (n6 != result4) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        if ((barcodeFormat == BarcodeFormat.EAN_13 || barcodeFormat == BarcodeFormat.UPC_A) && (string2 = this.eanManSupport.lookupCountryIdentifier(string3)) != null) {
            result2.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, string2);
        }
        return result2;
    }

    boolean checkChecksum(String string2) throws FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(string2);
    }

    static boolean checkStandardUPCEANChecksum(CharSequence charSequence) throws FormatException {
        int n2;
        int n3;
        int n4 = charSequence.length();
        if (n4 == 0) {
            return false;
        }
        int n5 = 0;
        for (n3 = n4 - 2; n3 >= 0; n3 -= 2) {
            n2 = charSequence.charAt(n3) - 48;
            if (n2 < 0 || n2 > 9) {
                throw FormatException.getFormatInstance();
            }
            n5 += n2;
        }
        n5 *= 3;
        for (n3 = n4 - 1; n3 >= 0; n3 -= 2) {
            n2 = charSequence.charAt(n3) - 48;
            if (n2 < 0 || n2 > 9) {
                throw FormatException.getFormatInstance();
            }
            n5 += n2;
        }
        return n5 % 10 == 0;
    }

    int[] decodeEnd(BitArray bitArray, int n2) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n2, false, START_END_PATTERN);
    }

    static int[] findGuardPattern(BitArray bitArray, int n2, boolean bl2, int[] nArray) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n2, bl2, nArray, new int[nArray.length]);
    }

    private static int[] findGuardPattern(BitArray bitArray, int n2, boolean bl2, int[] nArray, int[] nArray2) throws NotFoundException {
        int n3 = nArray.length;
        int n4 = bitArray.getSize();
        boolean bl3 = bl2;
        n2 = bl2 ? bitArray.getNextUnset(n2) : bitArray.getNextSet(n2);
        int n5 = 0;
        int n6 = n2;
        for (int i2 = n2; i2 < n4; ++i2) {
            if (bitArray.get(i2) ^ bl3) {
                int n7 = n5;
                nArray2[n7] = nArray2[n7] + 1;
                continue;
            }
            if (n5 == n3 - 1) {
                if (UPCEANReader.patternMatchVariance(nArray2, nArray, 0.7f) < 0.48f) {
                    return new int[]{n6, i2};
                }
                n6 += nArray2[0] + nArray2[1];
                System.arraycopy(nArray2, 2, nArray2, 0, n3 - 2);
                nArray2[n3 - 2] = 0;
                nArray2[n3 - 1] = 0;
                --n5;
            } else {
                ++n5;
            }
            nArray2[n5] = 1;
            bl3 = !bl3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n2, int[][] nArray2) throws NotFoundException {
        UPCEANReader.recordPattern(bitArray, n2, nArray);
        float f2 = 0.48f;
        int n3 = -1;
        int n4 = nArray2.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            int[] nArray3 = nArray2[i2];
            float f3 = UPCEANReader.patternMatchVariance(nArray, nArray3, 0.7f);
            if (!(f3 < f2)) continue;
            f2 = f3;
            n3 = i2;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3) throws NotFoundException;

    static {
        System.arraycopy(L_PATTERNS, 0, L_AND_G_PATTERNS, 0, 10);
        for (int i2 = 10; i2 < 20; ++i2) {
            int[] nArray = L_PATTERNS[i2 - 10];
            int[] nArray2 = new int[nArray.length];
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                nArray2[i3] = nArray[nArray.length - i3 - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[i2] = nArray2;
        }
    }
}

