/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.AbstractRSSReader;
import com.google.zxing.oned.rss.DataCharacter;
import com.google.zxing.oned.rss.FinderPattern;
import com.google.zxing.oned.rss.Pair;
import com.google.zxing.oned.rss.RSSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class RSS14Reader
extends AbstractRSSReader {
    private static final int[] OUTSIDE_EVEN_TOTAL_SUBSET = new int[]{1, 10, 34, 70, 126};
    private static final int[] INSIDE_ODD_TOTAL_SUBSET = new int[]{4, 20, 48, 81};
    private static final int[] OUTSIDE_GSUM = new int[]{0, 161, 961, 2015, 2715};
    private static final int[] INSIDE_GSUM = new int[]{0, 336, 1036, 1516};
    private static final int[] OUTSIDE_ODD_WIDEST = new int[]{8, 6, 4, 3, 1};
    private static final int[] INSIDE_ODD_WIDEST = new int[]{2, 4, 6, 8};
    private static final int[][] FINDER_PATTERNS = new int[][]{{3, 8, 2, 1}, {3, 5, 5, 1}, {3, 3, 7, 1}, {3, 1, 9, 1}, {2, 7, 4, 1}, {2, 5, 6, 1}, {2, 3, 8, 1}, {1, 5, 7, 1}, {1, 3, 9, 1}};
    private final List<Pair> possibleLeftPairs = new ArrayList<Pair>();
    private final List<Pair> possibleRightPairs = new ArrayList<Pair>();

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException {
        Pair pair = this.decodePair(bitArray, false, n2, map);
        RSS14Reader.addOrTally(this.possibleLeftPairs, pair);
        bitArray.reverse();
        Pair pair2 = this.decodePair(bitArray, true, n2, map);
        RSS14Reader.addOrTally(this.possibleRightPairs, pair2);
        bitArray.reverse();
        int n3 = this.possibleLeftPairs.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            Pair pair3 = this.possibleLeftPairs.get(i2);
            if (pair3.getCount() <= 1) continue;
            int n4 = this.possibleRightPairs.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                Pair pair4 = this.possibleRightPairs.get(i3);
                if (pair4.getCount() <= 1 || !RSS14Reader.checkChecksum(pair3, pair4)) continue;
                return RSS14Reader.constructResult(pair3, pair4);
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void addOrTally(Collection<Pair> collection, Pair pair) {
        if (pair == null) {
            return;
        }
        boolean bl2 = false;
        for (Pair pair2 : collection) {
            if (pair2.getValue() != pair.getValue()) continue;
            pair2.incrementCount();
            bl2 = true;
            break;
        }
        if (!bl2) {
            collection.add(pair);
        }
    }

    @Override
    public void reset() {
        this.possibleLeftPairs.clear();
        this.possibleRightPairs.clear();
    }

    private static Result constructResult(Pair pair, Pair pair2) {
        int n2;
        long l2 = 4537077L * (long)pair.getValue() + (long)pair2.getValue();
        String string2 = String.valueOf(l2);
        StringBuilder stringBuilder = new StringBuilder(14);
        for (n2 = 13 - string2.length(); n2 > 0; --n2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string2);
        n2 = 0;
        for (int i2 = 0; i2 < 13; ++i2) {
            int n3 = stringBuilder.charAt(i2) - 48;
            n2 += (i2 & 1) == 0 ? 3 * n3 : n3;
        }
        if ((n2 = 10 - n2 % 10) == 10) {
            n2 = 0;
        }
        stringBuilder.append(n2);
        ResultPoint[] resultPointArray = pair.getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = pair2.getFinderPattern().getResultPoints();
        return new Result(String.valueOf(stringBuilder.toString()), null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_14);
    }

    private static boolean checkChecksum(Pair pair, Pair pair2) {
        int n2 = (pair.getChecksumPortion() + 16 * pair2.getChecksumPortion()) % 79;
        int n3 = 9 * pair.getFinderPattern().getValue() + pair2.getFinderPattern().getValue();
        if (n3 > 72) {
            --n3;
        }
        if (n3 > 8) {
            --n3;
        }
        return n2 == n3;
    }

    private Pair decodePair(BitArray bitArray, boolean bl2, int n2, Map<DecodeHintType, ?> map) {
        try {
            ResultPointCallback resultPointCallback;
            int[] nArray = this.findFinderPattern(bitArray, 0, bl2);
            FinderPattern finderPattern = this.parseFoundFinderPattern(bitArray, n2, bl2, nArray);
            ResultPointCallback resultPointCallback2 = resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
            if (resultPointCallback != null) {
                float f2 = (float)(nArray[0] + nArray[1]) / 2.0f;
                if (bl2) {
                    f2 = (float)(bitArray.getSize() - 1) - f2;
                }
                resultPointCallback.foundPossibleResultPoint(new ResultPoint(f2, n2));
            }
            DataCharacter dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, true);
            DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, false);
            return new Pair(1597 * dataCharacter.getValue() + dataCharacter2.getValue(), dataCharacter.getChecksumPortion() + 4 * dataCharacter2.getChecksumPortion(), finderPattern);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    private DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl2) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = this.getDataCharacterCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl2) {
            RSS14Reader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSS14Reader.recordPattern(bitArray, finderPattern.getStartEnd()[1] + 1, nArray);
            n6 = 0;
            for (int i2 = nArray.length - 1; n6 < i2; ++n6, --i2) {
                int n7 = nArray[n6];
                nArray[n6] = nArray[i2];
                nArray[i2] = n7;
            }
        }
        n6 = bl2 ? 16 : 15;
        float f2 = (float)RSS14Reader.count(nArray) / (float)n6;
        int[] nArray2 = this.getOddCounts();
        int[] nArray3 = this.getEvenCounts();
        float[] fArray = this.getOddRoundingErrors();
        float[] fArray2 = this.getEvenRoundingErrors();
        for (n5 = 0; n5 < nArray.length; ++n5) {
            float f3 = (float)nArray[n5] / f2;
            n4 = (int)(f3 + 0.5f);
            if (n4 < 1) {
                n4 = 1;
            } else if (n4 > 8) {
                n4 = 8;
            }
            n3 = n5 / 2;
            if ((n5 & 1) == 0) {
                nArray2[n3] = n4;
                fArray[n3] = f3 - (float)n4;
                continue;
            }
            nArray3[n3] = n4;
            fArray2[n3] = f3 - (float)n4;
        }
        this.adjustOddEvenCounts(bl2, n6);
        n5 = 0;
        int n8 = 0;
        for (n4 = nArray2.length - 1; n4 >= 0; --n4) {
            n8 *= 9;
            n8 += nArray2[n4];
            n5 += nArray2[n4];
        }
        n4 = 0;
        n3 = 0;
        for (n2 = nArray3.length - 1; n2 >= 0; --n2) {
            n4 *= 9;
            n4 += nArray3[n2];
            n3 += nArray3[n2];
        }
        n2 = n8 + 3 * n4;
        if (bl2) {
            if ((n5 & 1) != 0 || n5 > 12 || n5 < 4) {
                throw NotFoundException.getNotFoundInstance();
            }
            int n9 = (12 - n5) / 2;
            int n10 = OUTSIDE_ODD_WIDEST[n9];
            int n11 = 9 - n10;
            int n12 = RSSUtils.getRSSvalue(nArray2, n10, false);
            int n13 = RSSUtils.getRSSvalue(nArray3, n11, true);
            int n14 = OUTSIDE_EVEN_TOTAL_SUBSET[n9];
            int n15 = OUTSIDE_GSUM[n9];
            return new DataCharacter(n12 * n14 + n13 + n15, n2);
        }
        if ((n3 & 1) != 0 || n3 > 10 || n3 < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n16 = (10 - n3) / 2;
        int n17 = INSIDE_ODD_WIDEST[n16];
        int n18 = 9 - n17;
        int n19 = RSSUtils.getRSSvalue(nArray2, n17, true);
        int n20 = RSSUtils.getRSSvalue(nArray3, n18, false);
        int n21 = INSIDE_ODD_TOTAL_SUBSET[n16];
        int n22 = INSIDE_GSUM[n16];
        return new DataCharacter(n20 * n21 + n19 + n22, n2);
    }

    private int[] findFinderPattern(BitArray bitArray, int n2, boolean bl2) throws NotFoundException {
        int[] nArray = this.getDecodeFinderCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n3 = bitArray.getSize();
        boolean bl3 = false;
        while (n2 < n3) {
            boolean bl4 = bl3 = !bitArray.get(n2);
            if (bl2 == bl3) break;
            ++n2;
        }
        int n4 = 0;
        int n5 = n2;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (bitArray.get(i2) ^ bl3) {
                int n6 = n4;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n4 == 3) {
                if (RSS14Reader.isFinderPattern(nArray)) {
                    return new int[]{n5, i2};
                }
                n5 += nArray[0] + nArray[1];
                nArray[0] = nArray[2];
                nArray[1] = nArray[3];
                nArray[2] = 0;
                nArray[3] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray[n4] = 1;
            bl3 = !bl3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n2, boolean bl2, int[] nArray) throws NotFoundException {
        int n3;
        boolean bl3 = bitArray.get(nArray[0]);
        for (n3 = nArray[0] - 1; n3 >= 0 && bl3 ^ bitArray.get(n3); --n3) {
        }
        int n4 = nArray[0] - ++n3;
        int[] nArray2 = this.getDecodeFinderCounters();
        System.arraycopy(nArray2, 0, nArray2, 1, nArray2.length - 1);
        nArray2[0] = n4;
        int n5 = RSS14Reader.parseFinderValue(nArray2, FINDER_PATTERNS);
        int n6 = n3;
        int n7 = nArray[1];
        if (bl2) {
            n6 = bitArray.getSize() - 1 - n6;
            n7 = bitArray.getSize() - 1 - n7;
        }
        return new FinderPattern(n5, new int[]{n3, nArray[1]}, n6, n7, n2);
    }

    private void adjustOddEvenCounts(boolean bl2, int n2) throws NotFoundException {
        int n3 = RSS14Reader.count(this.getOddCounts());
        int n4 = RSS14Reader.count(this.getEvenCounts());
        int n5 = n3 + n4 - n2;
        boolean bl3 = (n3 & 1) == (bl2 ? 1 : 0);
        boolean bl4 = (n4 & 1) == 1;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (bl2) {
            if (n3 > 12) {
                bl6 = true;
            } else if (n3 < 4) {
                bl5 = true;
            }
            if (n4 > 12) {
                bl8 = true;
            } else if (n4 < 4) {
                bl7 = true;
            }
        } else {
            if (n3 > 11) {
                bl6 = true;
            } else if (n3 < 5) {
                bl5 = true;
            }
            if (n4 > 10) {
                bl8 = true;
            } else if (n4 < 4) {
                bl7 = true;
            }
        }
        if (n5 == 1) {
            if (bl3) {
                if (bl4) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            } else {
                if (!bl4) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl8 = true;
            }
        } else if (n5 == -1) {
            if (bl3) {
                if (bl4) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            } else {
                if (!bl4) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl7 = true;
            }
        } else if (n5 == 0) {
            if (bl3) {
                if (!bl4) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n3 < n4) {
                    bl5 = true;
                    bl8 = true;
                } else {
                    bl6 = true;
                    bl7 = true;
                }
            } else if (bl4) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl5) {
            if (bl6) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl6) {
            RSS14Reader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl7) {
            if (bl8) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (bl8) {
            RSS14Reader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

