/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.AbstractRSSReader;
import com.google.zxing.oned.rss.DataCharacter;
import com.google.zxing.oned.rss.FinderPattern;
import com.google.zxing.oned.rss.RSSUtils;
import com.google.zxing.oned.rss.expanded.BitArrayBuilder;
import com.google.zxing.oned.rss.expanded.ExpandedPair;
import com.google.zxing.oned.rss.expanded.ExpandedRow;
import com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM = new int[]{0, 348, 1388, 2948, 3988};
    private static final int[][] FINDER_PATTERNS = new int[][]{{1, 8, 4, 1}, {3, 6, 4, 1}, {3, 4, 6, 1}, {3, 2, 8, 1}, {2, 6, 5, 1}, {2, 2, 9, 1}};
    private static final int[][] WEIGHTS = new int[][]{{1, 3, 9, 27, 81, 32, 96, 77}, {20, 60, 180, 118, 143, 7, 21, 63}, {189, 145, 13, 39, 117, 140, 209, 205}, {193, 157, 49, 147, 19, 57, 171, 91}, {62, 186, 136, 197, 169, 85, 44, 132}, {185, 133, 188, 142, 4, 12, 36, 108}, {113, 128, 173, 97, 80, 29, 87, 50}, {150, 28, 84, 41, 123, 158, 52, 156}, {46, 138, 203, 187, 139, 206, 196, 166}, {76, 17, 51, 153, 37, 111, 122, 155}, {43, 129, 176, 106, 107, 110, 119, 146}, {16, 48, 144, 10, 30, 90, 59, 177}, {109, 116, 137, 200, 178, 112, 125, 164}, {70, 210, 208, 202, 184, 130, 179, 115}, {134, 191, 151, 31, 93, 68, 204, 190}, {148, 22, 66, 198, 172, 94, 71, 2}, {6, 18, 54, 162, 64, 192, 154, 40}, {120, 149, 25, 75, 14, 42, 126, 167}, {79, 26, 78, 23, 69, 207, 199, 175}, {103, 98, 83, 38, 114, 131, 182, 124}, {161, 61, 183, 127, 170, 88, 53, 159}, {55, 165, 73, 8, 24, 72, 5, 15}, {45, 135, 194, 160, 58, 174, 100, 89}};
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES = new int[][]{{0, 0}, {0, 1, 1}, {0, 2, 1, 3}, {0, 4, 1, 3, 2}, {0, 4, 1, 3, 3, 5}, {0, 4, 1, 3, 4, 5, 5}, {0, 0, 1, 1, 2, 2, 3, 3}, {0, 0, 1, 1, 2, 2, 3, 4, 4}, {0, 0, 1, 1, 2, 2, 3, 4, 5, 5}, {0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5}};
    private static final int MAX_PAIRS = 11;
    private final List<ExpandedPair> pairs = new ArrayList<ExpandedPair>(11);
    private final List<ExpandedRow> rows = new ArrayList<ExpandedRow>();
    private final int[] startEnd = new int[2];
    private boolean startFromEven = false;

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        this.pairs.clear();
        this.startFromEven = false;
        try {
            List<ExpandedPair> list = this.decodeRow2pairs(n2, bitArray);
            return RSSExpandedReader.constructResult(list);
        }
        catch (NotFoundException notFoundException) {
            this.pairs.clear();
            this.startFromEven = true;
            List<ExpandedPair> list = this.decodeRow2pairs(n2, bitArray);
            return RSSExpandedReader.constructResult(list);
        }
    }

    @Override
    public void reset() {
        this.pairs.clear();
        this.rows.clear();
    }

    List<ExpandedPair> decodeRow2pairs(int n2, BitArray bitArray) throws NotFoundException {
        try {
            while (true) {
                ExpandedPair expandedPair = this.retrieveNextPair(bitArray, this.pairs, n2);
                this.pairs.add(expandedPair);
            }
        }
        catch (NotFoundException notFoundException) {
            if (this.pairs.isEmpty()) {
                throw notFoundException;
            }
            if (this.checkChecksum()) {
                return this.pairs;
            }
            boolean bl2 = !this.rows.isEmpty();
            boolean bl3 = false;
            this.storeRow(n2, bl3);
            if (bl2) {
                List<ExpandedPair> list = this.checkRows(false);
                if (list != null) {
                    return list;
                }
                list = this.checkRows(true);
                if (list != null) {
                    return list;
                }
            }
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private List<ExpandedPair> checkRows(boolean bl2) {
        if (this.rows.size() > 25) {
            this.rows.clear();
            return null;
        }
        this.pairs.clear();
        if (bl2) {
            Collections.reverse(this.rows);
        }
        List<ExpandedPair> list = null;
        try {
            list = this.checkRows(new ArrayList<ExpandedRow>(), 0);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (bl2) {
            Collections.reverse(this.rows);
        }
        return list;
    }

    private List<ExpandedPair> checkRows(List<ExpandedRow> list, int n2) throws NotFoundException {
        for (int i2 = n2; i2 < this.rows.size(); ++i2) {
            ExpandedRow expandedRow = this.rows.get(i2);
            this.pairs.clear();
            int n3 = list.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                this.pairs.addAll(list.get(i3).getPairs());
            }
            this.pairs.addAll(expandedRow.getPairs());
            if (!RSSExpandedReader.isValidSequence(this.pairs)) continue;
            if (this.checkChecksum()) {
                return this.pairs;
            }
            ArrayList<ExpandedRow> arrayList = new ArrayList<ExpandedRow>();
            arrayList.addAll(list);
            arrayList.add(expandedRow);
            try {
                return this.checkRows(arrayList, i2 + 1);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static boolean isValidSequence(List<ExpandedPair> list) {
        for (int[] nArray : FINDER_PATTERN_SEQUENCES) {
            if (list.size() > nArray.length) continue;
            boolean bl2 = true;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (list.get(i2).getFinderPattern().getValue() == nArray[i2]) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private void storeRow(int n2, boolean bl2) {
        int n3;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n3 = 0; n3 < this.rows.size(); ++n3) {
            ExpandedRow expandedRow = this.rows.get(n3);
            if (expandedRow.getRowNumber() > n2) {
                bl4 = expandedRow.isEquivalent(this.pairs);
                break;
            }
            bl3 = expandedRow.isEquivalent(this.pairs);
        }
        if (bl4 || bl3) {
            return;
        }
        if (RSSExpandedReader.isPartialRow(this.pairs, this.rows)) {
            return;
        }
        this.rows.add(n3, new ExpandedRow(this.pairs, n2, bl2));
        RSSExpandedReader.removePartialRows(this.pairs, this.rows);
    }

    private static void removePartialRows(List<ExpandedPair> list, List<ExpandedRow> list2) {
        Iterator<ExpandedRow> iterator = list2.iterator();
        while (iterator.hasNext()) {
            ExpandedRow expandedRow = iterator.next();
            if (expandedRow.getPairs().size() == list.size()) continue;
            boolean bl2 = true;
            for (ExpandedPair expandedPair : expandedRow.getPairs()) {
                boolean bl3 = false;
                for (ExpandedPair expandedPair2 : list) {
                    if (!expandedPair.equals(expandedPair2)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            iterator.remove();
        }
    }

    private static boolean isPartialRow(Iterable<ExpandedPair> iterable, Iterable<ExpandedRow> iterable2) {
        for (ExpandedRow expandedRow : iterable2) {
            boolean bl2 = true;
            for (ExpandedPair expandedPair : iterable) {
                boolean bl3 = false;
                for (ExpandedPair expandedPair2 : expandedRow.getPairs()) {
                    if (!expandedPair.equals(expandedPair2)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    List<ExpandedRow> getRows() {
        return this.rows;
    }

    static Result constructResult(List<ExpandedPair> list) throws NotFoundException, FormatException {
        BitArray bitArray = BitArrayBuilder.buildBitArray(list);
        AbstractExpandedDecoder abstractExpandedDecoder = AbstractExpandedDecoder.createDecoder(bitArray);
        String string2 = abstractExpandedDecoder.parseInformation();
        ResultPoint[] resultPointArray = list.get(0).getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = list.get(list.size() - 1).getFinderPattern().getResultPoints();
        return new Result(string2, null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_EXPANDED);
    }

    private boolean checkChecksum() {
        int n2;
        ExpandedPair expandedPair = this.pairs.get(0);
        DataCharacter dataCharacter = expandedPair.getLeftChar();
        DataCharacter dataCharacter2 = expandedPair.getRightChar();
        if (dataCharacter2 == null) {
            return false;
        }
        int n3 = dataCharacter2.getChecksumPortion();
        int n4 = 2;
        for (n2 = 1; n2 < this.pairs.size(); ++n2) {
            ExpandedPair expandedPair2 = this.pairs.get(n2);
            n3 += expandedPair2.getLeftChar().getChecksumPortion();
            ++n4;
            DataCharacter dataCharacter3 = expandedPair2.getRightChar();
            if (dataCharacter3 == null) continue;
            n3 += dataCharacter3.getChecksumPortion();
            ++n4;
        }
        n2 = 211 * (n4 - 4) + (n3 %= 211);
        return n2 == dataCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray bitArray, int n2) {
        int n3;
        if (bitArray.get(n2)) {
            n3 = bitArray.getNextUnset(n2);
            n3 = bitArray.getNextSet(n3);
        } else {
            n3 = bitArray.getNextSet(n2);
            n3 = bitArray.getNextUnset(n3);
        }
        return n3;
    }

    ExpandedPair retrieveNextPair(BitArray bitArray, List<ExpandedPair> list, int n2) throws NotFoundException {
        DataCharacter dataCharacter;
        FinderPattern finderPattern;
        boolean bl2;
        boolean bl3 = bl2 = list.size() % 2 == 0;
        if (this.startFromEven) {
            bl2 = !bl2;
        }
        boolean bl4 = true;
        int n3 = -1;
        do {
            this.findNextPair(bitArray, list, n3);
            finderPattern = this.parseFoundFinderPattern(bitArray, n2, bl2);
            if (finderPattern == null) {
                n3 = RSSExpandedReader.getNextSecondBar(bitArray, this.startEnd[0]);
                continue;
            }
            bl4 = false;
        } while (bl4);
        DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, bl2, true);
        if (!list.isEmpty() && list.get(list.size() - 1).mustBeLast()) {
            throw NotFoundException.getNotFoundInstance();
        }
        try {
            dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, bl2, false);
        }
        catch (NotFoundException notFoundException) {
            dataCharacter = null;
        }
        boolean bl5 = true;
        return new ExpandedPair(dataCharacter2, dataCharacter, finderPattern, bl5);
    }

    private void findNextPair(BitArray bitArray, List<ExpandedPair> list, int n2) throws NotFoundException {
        boolean bl2;
        int n3;
        int[] nArray = this.getDecodeFinderCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n4 = bitArray.getSize();
        if (n2 >= 0) {
            n3 = n2;
        } else if (list.isEmpty()) {
            n3 = 0;
        } else {
            ExpandedPair expandedPair = list.get(list.size() - 1);
            n3 = expandedPair.getFinderPattern().getStartEnd()[1];
        }
        boolean bl3 = bl2 = list.size() % 2 != 0;
        if (this.startFromEven) {
            bl2 = !bl2;
        }
        boolean bl4 = false;
        while (n3 < n4) {
            boolean bl5 = bl4 = !bitArray.get(n3);
            if (!bl4) break;
            ++n3;
        }
        int n5 = 0;
        int n6 = n3;
        for (int i2 = n3; i2 < n4; ++i2) {
            if (bitArray.get(i2) ^ bl4) {
                int n7 = n5;
                nArray[n7] = nArray[n7] + 1;
                continue;
            }
            if (n5 == 3) {
                if (bl2) {
                    RSSExpandedReader.reverseCounters(nArray);
                }
                if (RSSExpandedReader.isFinderPattern(nArray)) {
                    this.startEnd[0] = n6;
                    this.startEnd[1] = i2;
                    return;
                }
                if (bl2) {
                    RSSExpandedReader.reverseCounters(nArray);
                }
                n6 += nArray[0] + nArray[1];
                nArray[0] = nArray[2];
                nArray[1] = nArray[3];
                nArray[2] = 0;
                nArray[3] = 0;
                --n5;
            } else {
                ++n5;
            }
            nArray[n5] = 1;
            bl4 = !bl4;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2 / 2; ++i2) {
            int n3 = nArray[i2];
            nArray[i2] = nArray[n2 - i2 - 1];
            nArray[n2 - i2 - 1] = n3;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n2, boolean bl2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (bl2) {
            int n7;
            for (n7 = this.startEnd[0] - 1; n7 >= 0 && !bitArray.get(n7); --n7) {
            }
            n6 = this.startEnd[0] - ++n7;
            n5 = n7;
            n4 = this.startEnd[1];
        } else {
            n5 = this.startEnd[0];
            n4 = bitArray.getNextUnset(this.startEnd[1] + 1);
            n6 = n4 - this.startEnd[1];
        }
        int[] nArray = this.getDecodeFinderCounters();
        System.arraycopy(nArray, 0, nArray, 1, nArray.length - 1);
        nArray[0] = n6;
        try {
            n3 = RSSExpandedReader.parseFinderValue(nArray, FINDER_PATTERNS);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        return new FinderPattern(n3, new int[]{n5, n4}, n5, n4, n2);
    }

    DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl2, boolean bl3) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = this.getDataCharacterCounters();
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl3) {
            RSSExpandedReader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSSExpandedReader.recordPattern(bitArray, finderPattern.getStartEnd()[1], nArray);
            n7 = 0;
            for (int i2 = nArray.length - 1; n7 < i2; ++n7, --i2) {
                int n8 = nArray[n7];
                nArray[n7] = nArray[i2];
                nArray[i2] = n8;
            }
        }
        n7 = 17;
        float f2 = (float)RSSExpandedReader.count(nArray) / (float)n7;
        float f3 = (float)(finderPattern.getStartEnd()[1] - finderPattern.getStartEnd()[0]) / 15.0f;
        if (Math.abs(f2 - f3) / f3 > 0.3f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int[] nArray2 = this.getOddCounts();
        int[] nArray3 = this.getEvenCounts();
        float[] fArray = this.getOddRoundingErrors();
        float[] fArray2 = this.getEvenRoundingErrors();
        for (n6 = 0; n6 < nArray.length; ++n6) {
            float f4 = 1.0f * (float)nArray[n6] / f2;
            n5 = (int)(f4 + 0.5f);
            if (n5 < 1) {
                if (f4 < 0.3f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n5 = 1;
            } else if (n5 > 8) {
                if (f4 > 8.7f) {
                    throw NotFoundException.getNotFoundInstance();
                }
                n5 = 8;
            }
            n4 = n6 / 2;
            if ((n6 & 1) == 0) {
                nArray2[n4] = n5;
                fArray[n4] = f4 - (float)n5;
                continue;
            }
            nArray3[n4] = n5;
            fArray2[n4] = f4 - (float)n5;
        }
        this.adjustOddEvenCounts(n7);
        n6 = 4 * finderPattern.getValue() + (bl2 ? 0 : 2) + (bl3 ? 0 : 1) - 1;
        int n9 = 0;
        n5 = 0;
        for (n4 = nArray2.length - 1; n4 >= 0; --n4) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl2, bl3)) {
                n3 = WEIGHTS[n6][2 * n4];
                n5 += nArray2[n4] * n3;
            }
            n9 += nArray2[n4];
        }
        n4 = 0;
        for (n3 = nArray3.length - 1; n3 >= 0; --n3) {
            if (!RSSExpandedReader.isNotA1left(finderPattern, bl2, bl3)) continue;
            n2 = WEIGHTS[n6][2 * n3 + 1];
            n4 += nArray3[n3] * n2;
        }
        n3 = n5 + n4;
        if ((n9 & 1) != 0 || n9 > 13 || n9 < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        n2 = (13 - n9) / 2;
        int n10 = SYMBOL_WIDEST[n2];
        int n11 = 9 - n10;
        int n12 = RSSUtils.getRSSvalue(nArray2, n10, true);
        int n13 = RSSUtils.getRSSvalue(nArray3, n11, false);
        int n14 = EVEN_TOTAL_SUBSET[n2];
        int n15 = GSUM[n2];
        int n16 = n12 * n14 + n13 + n15;
        return new DataCharacter(n16, n3);
    }

    private static boolean isNotA1left(FinderPattern finderPattern, boolean bl2, boolean bl3) {
        return finderPattern.getValue() != 0 || !bl2 || !bl3;
    }

    private void adjustOddEvenCounts(int n2) throws NotFoundException {
        int n3 = RSSExpandedReader.count(this.getOddCounts());
        int n4 = RSSExpandedReader.count(this.getEvenCounts());
        int n5 = n3 + n4 - n2;
        boolean bl2 = (n3 & 1) == 1;
        boolean bl3 = (n4 & 1) == 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n3 > 13) {
            bl5 = true;
        } else if (n3 < 4) {
            bl4 = true;
        }
        boolean bl6 = false;
        boolean bl7 = false;
        if (n4 > 13) {
            bl7 = true;
        } else if (n4 < 4) {
            bl6 = true;
        }
        if (n5 == 1) {
            if (bl2) {
                if (bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            } else {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl7 = true;
            }
        } else if (n5 == -1) {
            if (bl2) {
                if (bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl4 = true;
            } else {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            }
        } else if (n5 == 0) {
            if (bl2) {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n3 < n4) {
                    bl4 = true;
                    bl7 = true;
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else if (bl3) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl4) {
            if (bl5) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl5) {
            RSSExpandedReader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (bl6) {
            if (bl7) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (bl7) {
            RSSExpandedReader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

