/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.NotFoundException;

final class FieldParser {
    private static final Object VARIABLE_LENGTH = new Object();
    private static final Object[][] TWO_DIGIT_DATA_LENGTH = new Object[][]{{"00", 18}, {"01", 14}, {"02", 14}, {"10", VARIABLE_LENGTH, 20}, {"11", 6}, {"12", 6}, {"13", 6}, {"15", 6}, {"17", 6}, {"20", 2}, {"21", VARIABLE_LENGTH, 20}, {"22", VARIABLE_LENGTH, 29}, {"30", VARIABLE_LENGTH, 8}, {"37", VARIABLE_LENGTH, 8}, {"90", VARIABLE_LENGTH, 30}, {"91", VARIABLE_LENGTH, 30}, {"92", VARIABLE_LENGTH, 30}, {"93", VARIABLE_LENGTH, 30}, {"94", VARIABLE_LENGTH, 30}, {"95", VARIABLE_LENGTH, 30}, {"96", VARIABLE_LENGTH, 30}, {"97", VARIABLE_LENGTH, 30}, {"98", VARIABLE_LENGTH, 30}, {"99", VARIABLE_LENGTH, 30}};
    private static final Object[][] THREE_DIGIT_DATA_LENGTH = new Object[][]{{"240", VARIABLE_LENGTH, 30}, {"241", VARIABLE_LENGTH, 30}, {"242", VARIABLE_LENGTH, 6}, {"250", VARIABLE_LENGTH, 30}, {"251", VARIABLE_LENGTH, 30}, {"253", VARIABLE_LENGTH, 17}, {"254", VARIABLE_LENGTH, 20}, {"400", VARIABLE_LENGTH, 30}, {"401", VARIABLE_LENGTH, 30}, {"402", 17}, {"403", VARIABLE_LENGTH, 30}, {"410", 13}, {"411", 13}, {"412", 13}, {"413", 13}, {"414", 13}, {"420", VARIABLE_LENGTH, 20}, {"421", VARIABLE_LENGTH, 15}, {"422", 3}, {"423", VARIABLE_LENGTH, 15}, {"424", 3}, {"425", 3}, {"426", 3}};
    private static final Object[][] THREE_DIGIT_PLUS_DIGIT_DATA_LENGTH = new Object[][]{{"310", 6}, {"311", 6}, {"312", 6}, {"313", 6}, {"314", 6}, {"315", 6}, {"316", 6}, {"320", 6}, {"321", 6}, {"322", 6}, {"323", 6}, {"324", 6}, {"325", 6}, {"326", 6}, {"327", 6}, {"328", 6}, {"329", 6}, {"330", 6}, {"331", 6}, {"332", 6}, {"333", 6}, {"334", 6}, {"335", 6}, {"336", 6}, {"340", 6}, {"341", 6}, {"342", 6}, {"343", 6}, {"344", 6}, {"345", 6}, {"346", 6}, {"347", 6}, {"348", 6}, {"349", 6}, {"350", 6}, {"351", 6}, {"352", 6}, {"353", 6}, {"354", 6}, {"355", 6}, {"356", 6}, {"357", 6}, {"360", 6}, {"361", 6}, {"362", 6}, {"363", 6}, {"364", 6}, {"365", 6}, {"366", 6}, {"367", 6}, {"368", 6}, {"369", 6}, {"390", VARIABLE_LENGTH, 15}, {"391", VARIABLE_LENGTH, 18}, {"392", VARIABLE_LENGTH, 15}, {"393", VARIABLE_LENGTH, 18}, {"703", VARIABLE_LENGTH, 30}};
    private static final Object[][] FOUR_DIGIT_DATA_LENGTH = new Object[][]{{"7001", 13}, {"7002", VARIABLE_LENGTH, 30}, {"7003", 10}, {"8001", 14}, {"8002", VARIABLE_LENGTH, 20}, {"8003", VARIABLE_LENGTH, 30}, {"8004", VARIABLE_LENGTH, 30}, {"8005", 6}, {"8006", 18}, {"8007", VARIABLE_LENGTH, 30}, {"8008", VARIABLE_LENGTH, 12}, {"8018", 18}, {"8020", VARIABLE_LENGTH, 25}, {"8100", 6}, {"8101", 10}, {"8102", 2}, {"8110", VARIABLE_LENGTH, 70}, {"8200", VARIABLE_LENGTH, 70}};

    private FieldParser() {
    }

    static String parseFieldsInGeneralPurpose(String string2) throws NotFoundException {
        if (string2.isEmpty()) {
            return null;
        }
        if (string2.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string3 = string2.substring(0, 2);
        for (Object[] objectArray : TWO_DIGIT_DATA_LENGTH) {
            if (!objectArray[0].equals(string3)) continue;
            if (objectArray[1] == VARIABLE_LENGTH) {
                return FieldParser.processVariableAI(2, (Integer)objectArray[2], string2);
            }
            return FieldParser.processFixedAI(2, (Integer)objectArray[1], string2);
        }
        if (string2.length() < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string4 = string2.substring(0, 3);
        for (Object[] objectArray : THREE_DIGIT_DATA_LENGTH) {
            if (!objectArray[0].equals(string4)) continue;
            if (objectArray[1] == VARIABLE_LENGTH) {
                return FieldParser.processVariableAI(3, (Integer)objectArray[2], string2);
            }
            return FieldParser.processFixedAI(3, (Integer)objectArray[1], string2);
        }
        for (Object[] objectArray : THREE_DIGIT_PLUS_DIGIT_DATA_LENGTH) {
            if (!objectArray[0].equals(string4)) continue;
            if (objectArray[1] == VARIABLE_LENGTH) {
                return FieldParser.processVariableAI(4, (Integer)objectArray[2], string2);
            }
            return FieldParser.processFixedAI(4, (Integer)objectArray[1], string2);
        }
        if (string2.length() < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string5 = string2.substring(0, 4);
        for (Object[] objectArray : FOUR_DIGIT_DATA_LENGTH) {
            if (!objectArray[0].equals(string5)) continue;
            if (objectArray[1] == VARIABLE_LENGTH) {
                return FieldParser.processVariableAI(4, (Integer)objectArray[2], string2);
            }
            return FieldParser.processFixedAI(4, (Integer)objectArray[1], string2);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String processFixedAI(int n2, int n3, String string2) throws NotFoundException {
        if (string2.length() < n2) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string3 = string2.substring(0, n2);
        if (string2.length() < n2 + n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string4 = string2.substring(n2, n2 + n3);
        String string5 = string2.substring(n2 + n3);
        String string6 = '(' + string3 + ')' + string4;
        String string7 = FieldParser.parseFieldsInGeneralPurpose(string5);
        return string7 == null ? string6 : string6 + string7;
    }

    private static String processVariableAI(int n2, int n3, String string2) throws NotFoundException {
        String string3 = string2.substring(0, n2);
        int n4 = string2.length() < n2 + n3 ? string2.length() : n2 + n3;
        String string4 = string2.substring(n2, n4);
        String string5 = string2.substring(n4);
        String string6 = '(' + string3 + ')' + string4;
        String string7 = FieldParser.parseFieldsInGeneralPurpose(string5);
        return string7 == null ? string6 : string6 + string7;
    }
}

