/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.BlockParsedResult;
import com.google.zxing.oned.rss.expanded.decoders.CurrentParsingState;
import com.google.zxing.oned.rss.expanded.decoders.DecodedChar;
import com.google.zxing.oned.rss.expanded.decoders.DecodedInformation;
import com.google.zxing.oned.rss.expanded.decoders.DecodedNumeric;
import com.google.zxing.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final BitArray information;
    private final CurrentParsingState current = new CurrentParsingState();
    private final StringBuilder buffer = new StringBuilder();

    GeneralAppIdDecoder(BitArray bitArray) {
        this.information = bitArray;
    }

    String decodeAllCodes(StringBuilder stringBuilder, int n2) throws NotFoundException, FormatException {
        int n3 = n2;
        String string2 = null;
        while (true) {
            DecodedInformation decodedInformation;
            String string3;
            if ((string3 = FieldParser.parseFieldsInGeneralPurpose((decodedInformation = this.decodeGeneralPurposeField(n3, string2)).getNewString())) != null) {
                stringBuilder.append(string3);
            }
            string2 = decodedInformation.isRemaining() ? String.valueOf(decodedInformation.getRemainingValue()) : null;
            if (n3 == decodedInformation.getNewPosition()) break;
            n3 = decodedInformation.getNewPosition();
        }
        return stringBuilder.toString();
    }

    private boolean isStillNumeric(int n2) {
        if (n2 + 7 > this.information.getSize()) {
            return n2 + 4 <= this.information.getSize();
        }
        for (int i2 = n2; i2 < n2 + 3; ++i2) {
            if (!this.information.get(i2)) continue;
            return true;
        }
        return this.information.get(n2 + 3);
    }

    private DecodedNumeric decodeNumeric(int n2) throws FormatException {
        if (n2 + 7 > this.information.getSize()) {
            int n3 = this.extractNumericValueFromBitArray(n2, 4);
            if (n3 == 0) {
                return new DecodedNumeric(this.information.getSize(), 10, 10);
            }
            return new DecodedNumeric(this.information.getSize(), n3 - 1, 10);
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 7);
        int n5 = (n4 - 8) / 11;
        int n6 = (n4 - 8) % 11;
        return new DecodedNumeric(n2 + 7, n5, n6);
    }

    int extractNumericValueFromBitArray(int n2, int n3) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, n2, n3);
    }

    static int extractNumericValueFromBitArray(BitArray bitArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!bitArray.get(n2 + i2)) continue;
            n4 |= 1 << n3 - i2 - 1;
        }
        return n4;
    }

    DecodedInformation decodeGeneralPurposeField(int n2, String string2) throws FormatException {
        this.buffer.setLength(0);
        if (string2 != null) {
            this.buffer.append(string2);
        }
        this.current.setPosition(n2);
        DecodedInformation decodedInformation = this.parseBlocks();
        if (decodedInformation != null && decodedInformation.isRemaining()) {
            return new DecodedInformation(this.current.getPosition(), this.buffer.toString(), decodedInformation.getRemainingValue());
        }
        return new DecodedInformation(this.current.getPosition(), this.buffer.toString());
    }

    private DecodedInformation parseBlocks() throws FormatException {
        BlockParsedResult blockParsedResult;
        boolean bl2;
        boolean bl3;
        do {
            int n2 = this.current.getPosition();
            if (this.current.isAlpha()) {
                blockParsedResult = this.parseAlphaBlock();
                bl2 = blockParsedResult.isFinished();
            } else if (this.current.isIsoIec646()) {
                blockParsedResult = this.parseIsoIec646Block();
                bl2 = blockParsedResult.isFinished();
            } else {
                blockParsedResult = this.parseNumericBlock();
                bl2 = blockParsedResult.isFinished();
            }
            boolean bl4 = bl3 = n2 != this.current.getPosition();
        } while ((bl3 || bl2) && !bl2);
        return blockParsedResult.getDecodedInformation();
    }

    private BlockParsedResult parseNumericBlock() throws FormatException {
        while (this.isStillNumeric(this.current.getPosition())) {
            DecodedNumeric decodedNumeric = this.decodeNumeric(this.current.getPosition());
            this.current.setPosition(decodedNumeric.getNewPosition());
            if (decodedNumeric.isFirstDigitFNC1()) {
                DecodedInformation decodedInformation = decodedNumeric.isSecondDigitFNC1() ? new DecodedInformation(this.current.getPosition(), this.buffer.toString()) : new DecodedInformation(this.current.getPosition(), this.buffer.toString(), decodedNumeric.getSecondDigit());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedNumeric.getFirstDigit());
            if (decodedNumeric.isSecondDigitFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedNumeric.getSecondDigit());
        }
        if (this.isNumericToAlphaNumericLatch(this.current.getPosition())) {
            this.current.setAlpha();
            this.current.incrementPosition(4);
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseIsoIec646Block() throws FormatException {
        while (this.isStillIsoIec646(this.current.getPosition())) {
            DecodedChar decodedChar = this.decodeIsoIec646(this.current.getPosition());
            this.current.setPosition(decodedChar.getNewPosition());
            if (decodedChar.isFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            } else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setAlpha();
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseAlphaBlock() {
        while (this.isStillAlpha(this.current.getPosition())) {
            DecodedChar decodedChar = this.decodeAlphanumeric(this.current.getPosition());
            this.current.setPosition(decodedChar.getNewPosition());
            if (decodedChar.isFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.getPosition())) {
            if (this.current.getPosition() + 5 < this.information.getSize()) {
                this.current.incrementPosition(5);
            } else {
                this.current.setPosition(this.information.getSize());
            }
            this.current.setIsoIec646();
        }
        return new BlockParsedResult(false);
    }

    private boolean isStillIsoIec646(int n2) {
        if (n2 + 5 > this.information.getSize()) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 >= 5 && n3 < 16) {
            return true;
        }
        if (n2 + 7 > this.information.getSize()) {
            return false;
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 7);
        if (n4 >= 64 && n4 < 116) {
            return true;
        }
        if (n2 + 8 > this.information.getSize()) {
            return false;
        }
        int n5 = this.extractNumericValueFromBitArray(n2, 8);
        return n5 >= 232 && n5 < 253;
    }

    private DecodedChar decodeIsoIec646(int n2) throws FormatException {
        char c2;
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 == 15) {
            return new DecodedChar(n2 + 5, '$');
        }
        if (n3 >= 5 && n3 < 15) {
            return new DecodedChar(n2 + 5, (char)(48 + n3 - 5));
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 7);
        if (n4 >= 64 && n4 < 90) {
            return new DecodedChar(n2 + 7, (char)(n4 + 1));
        }
        if (n4 >= 90 && n4 < 116) {
            return new DecodedChar(n2 + 7, (char)(n4 + 7));
        }
        int n5 = this.extractNumericValueFromBitArray(n2, 8);
        switch (n5) {
            case 232: {
                c2 = '!';
                break;
            }
            case 233: {
                c2 = '\"';
                break;
            }
            case 234: {
                c2 = '%';
                break;
            }
            case 235: {
                c2 = '&';
                break;
            }
            case 236: {
                c2 = '\'';
                break;
            }
            case 237: {
                c2 = '(';
                break;
            }
            case 238: {
                c2 = ')';
                break;
            }
            case 239: {
                c2 = '*';
                break;
            }
            case 240: {
                c2 = '+';
                break;
            }
            case 241: {
                c2 = ',';
                break;
            }
            case 242: {
                c2 = '-';
                break;
            }
            case 243: {
                c2 = '.';
                break;
            }
            case 244: {
                c2 = '/';
                break;
            }
            case 245: {
                c2 = ':';
                break;
            }
            case 246: {
                c2 = ';';
                break;
            }
            case 247: {
                c2 = '<';
                break;
            }
            case 248: {
                c2 = '=';
                break;
            }
            case 249: {
                c2 = '>';
                break;
            }
            case 250: {
                c2 = '?';
                break;
            }
            case 251: {
                c2 = '_';
                break;
            }
            case 252: {
                c2 = ' ';
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        return new DecodedChar(n2 + 8, c2);
    }

    private boolean isStillAlpha(int n2) {
        if (n2 + 5 > this.information.getSize()) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 >= 5 && n3 < 16) {
            return true;
        }
        if (n2 + 6 > this.information.getSize()) {
            return false;
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 6);
        return n4 >= 16 && n4 < 63;
    }

    private DecodedChar decodeAlphanumeric(int n2) {
        char c2;
        int n3 = this.extractNumericValueFromBitArray(n2, 5);
        if (n3 == 15) {
            return new DecodedChar(n2 + 5, '$');
        }
        if (n3 >= 5 && n3 < 15) {
            return new DecodedChar(n2 + 5, (char)(48 + n3 - 5));
        }
        int n4 = this.extractNumericValueFromBitArray(n2, 6);
        if (n4 >= 32 && n4 < 58) {
            return new DecodedChar(n2 + 6, (char)(n4 + 33));
        }
        switch (n4) {
            case 58: {
                c2 = '*';
                break;
            }
            case 59: {
                c2 = ',';
                break;
            }
            case 60: {
                c2 = '-';
                break;
            }
            case 61: {
                c2 = '.';
                break;
            }
            case 62: {
                c2 = '/';
                break;
            }
            default: {
                throw new IllegalStateException("Decoding invalid alphanumeric value: " + n4);
            }
        }
        return new DecodedChar(n2 + 6, c2);
    }

    private boolean isAlphaTo646ToAlphaLatch(int n2) {
        if (n2 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i2 = 0; i2 < 5 && i2 + n2 < this.information.getSize(); ++i2) {
            if (!(i2 == 2 ? !this.information.get(n2 + 2) : this.information.get(n2 + i2))) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaOr646ToNumericLatch(int n2) {
        if (n2 + 3 > this.information.getSize()) {
            return false;
        }
        for (int i2 = n2; i2 < n2 + 3; ++i2) {
            if (!this.information.get(i2)) continue;
            return false;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int n2) {
        if (n2 + 1 > this.information.getSize()) {
            return false;
        }
        for (int i2 = 0; i2 < 4 && i2 + n2 < this.information.getSize(); ++i2) {
            if (!this.information.get(n2 + i2)) continue;
            return false;
        }
        return true;
    }
}

