/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    static final int WHITE_SPACE = 30;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got " + (Object)((Object)barcodeFormat));
        }
        PDF417 pDF417 = new PDF417();
        int n4 = 30;
        if (map != null) {
            Object object;
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                pDF417.setCompact((Boolean)map.get((Object)EncodeHintType.PDF417_COMPACT));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                pDF417.setCompaction((Compaction)((Object)map.get((Object)EncodeHintType.PDF417_COMPACTION)));
            }
            if (map.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                object = (Dimensions)map.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                pDF417.setDimensions(((Dimensions)object).getMaxCols(), ((Dimensions)object).getMinCols(), ((Dimensions)object).getMaxRows(), ((Dimensions)object).getMinRows());
            }
            if (map.containsKey((Object)EncodeHintType.MARGIN)) {
                n4 = ((Number)map.get((Object)EncodeHintType.MARGIN)).intValue();
            }
            if (map.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                object = (String)map.get((Object)EncodeHintType.CHARACTER_SET);
                pDF417.setEncoding(Charset.forName((String)object));
            }
        }
        return PDF417Writer.bitMatrixFromEncoder(pDF417, string2, n2, n3, n4);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    private static BitMatrix bitMatrixFromEncoder(PDF417 pDF417, String string2, int n2, int n3, int n4) throws WriterException {
        int n5;
        int n6;
        int n7;
        int n8 = 2;
        pDF417.generateBarcodeLogic(string2, n8);
        int n9 = 2;
        int n10 = 4;
        byte[][] byArray = pDF417.getBarcodeMatrix().getScaledMatrix(n9, n10 * n9);
        boolean bl2 = false;
        if (n3 > n2 ^ byArray[0].length < byArray.length) {
            byArray = PDF417Writer.rotateArray(byArray);
            bl2 = true;
        }
        if ((n7 = (n6 = n2 / byArray[0].length) < (n5 = n3 / byArray.length) ? n6 : n5) > 1) {
            byte[][] byArray2 = pDF417.getBarcodeMatrix().getScaledMatrix(n7 * n9, n7 * n10 * n9);
            if (bl2) {
                byArray2 = PDF417Writer.rotateArray(byArray2);
            }
            return PDF417Writer.bitMatrixFrombitArray(byArray2, n4);
        }
        return PDF417Writer.bitMatrixFrombitArray(byArray, n4);
    }

    private static BitMatrix bitMatrixFrombitArray(byte[][] byArray, int n2) {
        BitMatrix bitMatrix = new BitMatrix(byArray[0].length + 2 * n2, byArray.length + 2 * n2);
        bitMatrix.clear();
        int n3 = 0;
        int n4 = bitMatrix.getHeight() - n2 - 1;
        while (n3 < byArray.length) {
            for (int i2 = 0; i2 < byArray[0].length; ++i2) {
                if (byArray[n3][i2] != 1) continue;
                bitMatrix.set(i2 + n2, n4);
            }
            ++n3;
            --n4;
        }
        return bitMatrix;
    }

    private static byte[][] rotateArray(byte[][] byArray) {
        byte[][] byArray2 = new byte[byArray[0].length][byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray.length - i2 - 1;
            for (int i3 = 0; i3 < byArray[0].length; ++i3) {
                byArray2[i3][n2] = byArray[i2][i3];
            }
        }
        return byArray2;
    }
}

