/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;

final class BoundingBox {
    private BitMatrix image;
    private ResultPoint topLeft;
    private ResultPoint bottomLeft;
    private ResultPoint topRight;
    private ResultPoint bottomRight;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    BoundingBox(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        if (resultPoint == null && resultPoint3 == null || resultPoint2 == null && resultPoint4 == null || resultPoint != null && resultPoint2 == null || resultPoint3 != null && resultPoint4 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.init(bitMatrix, resultPoint, resultPoint2, resultPoint3, resultPoint4);
    }

    BoundingBox(BoundingBox boundingBox) {
        this.init(boundingBox.image, boundingBox.topLeft, boundingBox.bottomLeft, boundingBox.topRight, boundingBox.bottomRight);
    }

    private void init(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        this.image = bitMatrix;
        this.topLeft = resultPoint;
        this.bottomLeft = resultPoint2;
        this.topRight = resultPoint3;
        this.bottomRight = resultPoint4;
        this.calculateMinMaxValues();
    }

    static BoundingBox merge(BoundingBox boundingBox, BoundingBox boundingBox2) throws NotFoundException {
        if (boundingBox == null) {
            return boundingBox2;
        }
        if (boundingBox2 == null) {
            return boundingBox;
        }
        return new BoundingBox(boundingBox.image, boundingBox.topLeft, boundingBox.bottomLeft, boundingBox2.topRight, boundingBox2.bottomRight);
    }

    BoundingBox addMissingRows(int n2, int n3, boolean bl2) throws NotFoundException {
        ResultPoint resultPoint;
        int n4;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3 = this.topLeft;
        ResultPoint resultPoint4 = this.bottomLeft;
        ResultPoint resultPoint5 = this.topRight;
        ResultPoint resultPoint6 = this.bottomRight;
        if (n2 > 0) {
            resultPoint2 = bl2 ? this.topLeft : this.topRight;
            n4 = (int)resultPoint2.getY() - n2;
            if (n4 < 0) {
                n4 = 0;
            }
            resultPoint = new ResultPoint(resultPoint2.getX(), n4);
            if (bl2) {
                resultPoint3 = resultPoint;
            } else {
                resultPoint5 = resultPoint;
            }
        }
        if (n3 > 0) {
            resultPoint2 = bl2 ? this.bottomLeft : this.bottomRight;
            n4 = (int)resultPoint2.getY() + n3;
            if (n4 >= this.image.getHeight()) {
                n4 = this.image.getHeight() - 1;
            }
            resultPoint = new ResultPoint(resultPoint2.getX(), n4);
            if (bl2) {
                resultPoint4 = resultPoint;
            } else {
                resultPoint6 = resultPoint;
            }
        }
        this.calculateMinMaxValues();
        return new BoundingBox(this.image, resultPoint3, resultPoint4, resultPoint5, resultPoint6);
    }

    private void calculateMinMaxValues() {
        if (this.topLeft == null) {
            this.topLeft = new ResultPoint(0.0f, this.topRight.getY());
            this.bottomLeft = new ResultPoint(0.0f, this.bottomRight.getY());
        } else if (this.topRight == null) {
            this.topRight = new ResultPoint(this.image.getWidth() - 1, this.topLeft.getY());
            this.bottomRight = new ResultPoint(this.image.getWidth() - 1, this.bottomLeft.getY());
        }
        this.minX = (int)Math.min(this.topLeft.getX(), this.bottomLeft.getX());
        this.maxX = (int)Math.max(this.topRight.getX(), this.bottomRight.getX());
        this.minY = (int)Math.min(this.topLeft.getY(), this.topRight.getY());
        this.maxY = (int)Math.max(this.bottomLeft.getY(), this.bottomRight.getY());
    }

    int getMinX() {
        return this.minX;
    }

    int getMaxX() {
        return this.maxX;
    }

    int getMinY() {
        return this.minY;
    }

    int getMaxY() {
        return this.maxY;
    }

    ResultPoint getTopLeft() {
        return this.topLeft;
    }

    ResultPoint getTopRight() {
        return this.topRight;
    }

    ResultPoint getBottomLeft() {
        return this.bottomLeft;
    }

    ResultPoint getBottomRight() {
        return this.bottomRight;
    }
}

