/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import java.math.BigInteger;
import java.util.Arrays;

final class DecodedBitStreamParser {
    private static final int TEXT_COMPACTION_MODE_LATCH = 900;
    private static final int BYTE_COMPACTION_MODE_LATCH = 901;
    private static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    private static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    private static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    private static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    private static final int MACRO_PDF417_TERMINATOR = 922;
    private static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    private static final int MAX_NUMERIC_CODEWORDS = 15;
    private static final int PL = 25;
    private static final int LL = 27;
    private static final int AS = 27;
    private static final int ML = 28;
    private static final int AL = 28;
    private static final int PS = 29;
    private static final int PAL = 29;
    private static final char[] PUNCT_CHARS;
    private static final char[] MIXED_CHARS;
    private static final BigInteger[] EXP900;
    private static final int NUMBER_OF_SEQUENCE_CODEWORDS = 2;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(int[] nArray, String string2) throws FormatException {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 2);
        int n2 = 1;
        int n3 = nArray[n2++];
        PDF417ResultMetadata pDF417ResultMetadata = new PDF417ResultMetadata();
        while (n2 < nArray[0]) {
            switch (n3) {
                case 900: {
                    n2 = DecodedBitStreamParser.textCompaction(nArray, n2, stringBuilder);
                    break;
                }
                case 901: 
                case 913: 
                case 924: {
                    n2 = DecodedBitStreamParser.byteCompaction(n3, nArray, n2, stringBuilder);
                    break;
                }
                case 902: {
                    n2 = DecodedBitStreamParser.numericCompaction(nArray, n2, stringBuilder);
                    break;
                }
                case 928: {
                    n2 = DecodedBitStreamParser.decodeMacroBlock(nArray, n2, pDF417ResultMetadata);
                    break;
                }
                case 922: 
                case 923: {
                    throw FormatException.getFormatInstance();
                }
                default: {
                    --n2;
                    n2 = DecodedBitStreamParser.textCompaction(nArray, n2, stringBuilder);
                }
            }
            if (n2 < nArray.length) {
                n3 = nArray[n2++];
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        if (stringBuilder.length() == 0) {
            throw FormatException.getFormatInstance();
        }
        DecoderResult decoderResult = new DecoderResult(null, stringBuilder.toString(), null, string2);
        decoderResult.setOther(pDF417ResultMetadata);
        return decoderResult;
    }

    private static int decodeMacroBlock(int[] nArray, int n2, PDF417ResultMetadata pDF417ResultMetadata) throws FormatException {
        if (n2 + 2 > nArray[0]) {
            throw FormatException.getFormatInstance();
        }
        int[] nArray2 = new int[2];
        int n3 = 0;
        while (n3 < 2) {
            nArray2[n3] = nArray[n2];
            ++n3;
            ++n2;
        }
        pDF417ResultMetadata.setSegmentIndex(Integer.parseInt(DecodedBitStreamParser.decodeBase900toBase10(nArray2, 2)));
        StringBuilder stringBuilder = new StringBuilder();
        n2 = DecodedBitStreamParser.textCompaction(nArray, n2, stringBuilder);
        pDF417ResultMetadata.setFileId(stringBuilder.toString());
        if (nArray[n2] == 923) {
            int[] nArray3 = new int[nArray[0] - ++n2];
            int n4 = 0;
            boolean bl2 = false;
            block4: while (n2 < nArray[0] && !bl2) {
                int n5;
                if ((n5 = nArray[n2++]) < 900) {
                    nArray3[n4++] = n5;
                    continue;
                }
                switch (n5) {
                    case 922: {
                        pDF417ResultMetadata.setLastSegment(true);
                        ++n2;
                        bl2 = true;
                        continue block4;
                    }
                }
                throw FormatException.getFormatInstance();
            }
            pDF417ResultMetadata.setOptionalData(Arrays.copyOf(nArray3, n4));
        } else if (nArray[n2] == 922) {
            pDF417ResultMetadata.setLastSegment(true);
            ++n2;
        }
        return n2;
    }

    private static int textCompaction(int[] nArray, int n2, StringBuilder stringBuilder) {
        int[] nArray2 = new int[(nArray[0] - n2) * 2];
        int[] nArray3 = new int[(nArray[0] - n2) * 2];
        int n3 = 0;
        boolean bl2 = false;
        while (n2 < nArray[0] && !bl2) {
            int n4;
            if ((n4 = nArray[n2++]) < 900) {
                nArray2[n3] = n4 / 30;
                nArray2[n3 + 1] = n4 % 30;
                n3 += 2;
                continue;
            }
            switch (n4) {
                case 900: {
                    nArray2[n3++] = 900;
                    break;
                }
                case 901: 
                case 902: 
                case 922: 
                case 923: 
                case 924: 
                case 928: {
                    --n2;
                    bl2 = true;
                    break;
                }
                case 913: {
                    nArray2[n3] = 913;
                    nArray3[n3] = n4 = nArray[n2++];
                    ++n3;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(nArray2, nArray3, n3, stringBuilder);
        return n2;
    }

    private static void decodeTextCompaction(int[] nArray, int[] nArray2, int n2, StringBuilder stringBuilder) {
        Mode mode = Mode.ALPHA;
        Mode mode2 = Mode.ALPHA;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            int n4 = 0;
            switch (mode) {
                case ALPHA: {
                    if (n3 < 26) {
                        n4 = (char)(65 + n3);
                        break;
                    }
                    if (n3 == 26) {
                        n4 = 32;
                        break;
                    }
                    if (n3 == 27) {
                        mode = Mode.LOWER;
                        break;
                    }
                    if (n3 == 28) {
                        mode = Mode.MIXED;
                        break;
                    }
                    if (n3 == 29) {
                        mode2 = mode;
                        mode = Mode.PUNCT_SHIFT;
                        break;
                    }
                    if (n3 == 913) {
                        stringBuilder.append((char)nArray2[i2]);
                        break;
                    }
                    if (n3 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case LOWER: {
                    if (n3 < 26) {
                        n4 = (char)(97 + n3);
                        break;
                    }
                    if (n3 == 26) {
                        n4 = 32;
                        break;
                    }
                    if (n3 == 27) {
                        mode2 = mode;
                        mode = Mode.ALPHA_SHIFT;
                        break;
                    }
                    if (n3 == 28) {
                        mode = Mode.MIXED;
                        break;
                    }
                    if (n3 == 29) {
                        mode2 = mode;
                        mode = Mode.PUNCT_SHIFT;
                        break;
                    }
                    if (n3 == 913) {
                        stringBuilder.append((char)nArray2[i2]);
                        break;
                    }
                    if (n3 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case MIXED: {
                    if (n3 < 25) {
                        n4 = MIXED_CHARS[n3];
                        break;
                    }
                    if (n3 == 25) {
                        mode = Mode.PUNCT;
                        break;
                    }
                    if (n3 == 26) {
                        n4 = 32;
                        break;
                    }
                    if (n3 == 27) {
                        mode = Mode.LOWER;
                        break;
                    }
                    if (n3 == 28) {
                        mode = Mode.ALPHA;
                        break;
                    }
                    if (n3 == 29) {
                        mode2 = mode;
                        mode = Mode.PUNCT_SHIFT;
                        break;
                    }
                    if (n3 == 913) {
                        stringBuilder.append((char)nArray2[i2]);
                        break;
                    }
                    if (n3 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case PUNCT: {
                    if (n3 < 29) {
                        n4 = PUNCT_CHARS[n3];
                        break;
                    }
                    if (n3 == 29) {
                        mode = Mode.ALPHA;
                        break;
                    }
                    if (n3 == 913) {
                        stringBuilder.append((char)nArray2[i2]);
                        break;
                    }
                    if (n3 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case ALPHA_SHIFT: {
                    mode = mode2;
                    if (n3 < 26) {
                        n4 = (char)(65 + n3);
                        break;
                    }
                    if (n3 == 26) {
                        n4 = 32;
                        break;
                    }
                    if (n3 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case PUNCT_SHIFT: {
                    mode = mode2;
                    if (n3 < 29) {
                        n4 = PUNCT_CHARS[n3];
                        break;
                    }
                    if (n3 == 29) {
                        mode = Mode.ALPHA;
                        break;
                    }
                    if (n3 == 913) {
                        stringBuilder.append((char)nArray2[i2]);
                        break;
                    }
                    if (n3 != 900) break;
                    mode = Mode.ALPHA;
                }
            }
            if (n4 == 0) continue;
            stringBuilder.append((char)n4);
        }
    }

    private static int byteCompaction(int n2, int[] nArray, int n3, StringBuilder stringBuilder) {
        block11: {
            block10: {
                int n4;
                if (n2 != 901) break block10;
                int n5 = 0;
                long l2 = 0L;
                char[] cArray = new char[6];
                int[] nArray2 = new int[6];
                boolean bl2 = false;
                int n6 = nArray[n3++];
                while (n3 < nArray[0] && !bl2) {
                    nArray2[n5++] = n6;
                    l2 = 900L * l2 + (long)n6;
                    if ((n6 = nArray[n3++]) == 900 || n6 == 901 || n6 == 902 || n6 == 924 || n6 == 928 || n6 == 923 || n6 == 922) {
                        --n3;
                        bl2 = true;
                        continue;
                    }
                    if (n5 % 5 != 0 || n5 <= 0) continue;
                    for (n4 = 0; n4 < 6; ++n4) {
                        cArray[5 - n4] = (char)(l2 % 256L);
                        l2 >>= 8;
                    }
                    stringBuilder.append(cArray);
                    n5 = 0;
                }
                if (n3 == nArray[0] && n6 < 900) {
                    nArray2[n5++] = n6;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    stringBuilder.append((char)nArray2[n4]);
                }
                break block11;
            }
            if (n2 != 924) break block11;
            int n7 = 0;
            long l3 = 0L;
            boolean bl3 = false;
            while (n3 < nArray[0] && !bl3) {
                int n8;
                if ((n8 = nArray[n3++]) < 900) {
                    ++n7;
                    l3 = 900L * l3 + (long)n8;
                } else if (n8 == 900 || n8 == 901 || n8 == 902 || n8 == 924 || n8 == 928 || n8 == 923 || n8 == 922) {
                    --n3;
                    bl3 = true;
                }
                if (n7 % 5 != 0 || n7 <= 0) continue;
                char[] cArray = new char[6];
                for (int i2 = 0; i2 < 6; ++i2) {
                    cArray[5 - i2] = (char)(l3 & 0xFFL);
                    l3 >>= 8;
                }
                stringBuilder.append(cArray);
                n7 = 0;
            }
        }
        return n3;
    }

    private static int numericCompaction(int[] nArray, int n2, StringBuilder stringBuilder) throws FormatException {
        int n3 = 0;
        boolean bl2 = false;
        int[] nArray2 = new int[15];
        while (n2 < nArray[0] && !bl2) {
            int n4 = nArray[n2++];
            if (n2 == nArray[0]) {
                bl2 = true;
            }
            if (n4 < 900) {
                nArray2[n3] = n4;
                ++n3;
            } else if (n4 == 900 || n4 == 901 || n4 == 924 || n4 == 928 || n4 == 923 || n4 == 922) {
                --n2;
                bl2 = true;
            }
            if (n3 % 15 != 0 && n4 != 902 && !bl2) continue;
            String string2 = DecodedBitStreamParser.decodeBase900toBase10(nArray2, n3);
            stringBuilder.append(string2);
            n3 = 0;
        }
        return n2;
    }

    private static String decodeBase900toBase10(int[] nArray, int n2) throws FormatException {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i2 = 0; i2 < n2; ++i2) {
            bigInteger = bigInteger.add(EXP900[n2 - i2 - 1].multiply(BigInteger.valueOf(nArray[i2])));
        }
        String string2 = bigInteger.toString();
        if (string2.charAt(0) != '1') {
            throw FormatException.getFormatInstance();
        }
        return string2.substring(1);
    }

    static {
        BigInteger bigInteger;
        PUNCT_CHARS = new char[]{';', '<', '>', '@', '[', '\\', ']', '_', '`', '~', '!', '\r', '\t', ',', ':', '\n', '-', '.', '$', '/', '\"', '|', '*', '(', ')', '?', '{', '}', '\''};
        MIXED_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '&', '\r', '\t', ',', ':', '#', '-', '.', '$', '/', '+', '%', '*', '=', '^'};
        EXP900 = new BigInteger[16];
        DecodedBitStreamParser.EXP900[0] = BigInteger.ONE;
        DecodedBitStreamParser.EXP900[1] = bigInteger = BigInteger.valueOf(900L);
        for (int i2 = 2; i2 < EXP900.length; ++i2) {
            DecodedBitStreamParser.EXP900[i2] = EXP900[i2 - 1].multiply(bigInteger);
        }
    }

    private static enum Mode {
        ALPHA,
        LOWER,
        MIXED,
        PUNCT,
        ALPHA_SHIFT,
        PUNCT_SHIFT;

    }
}

