/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import java.util.Formatter;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final BarcodeMetadata barcodeMetadata;
    private final DetectionResultColumn[] detectionResultColumns;
    private BoundingBox boundingBox;
    private final int barcodeColumnCount;

    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        this.detectionResultColumns = new DetectionResultColumn[this.barcodeColumnCount + 2];
    }

    DetectionResultColumn[] getDetectionResultColumns() {
        int n2;
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[0]);
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[this.barcodeColumnCount + 1]);
        int n3 = 928;
        do {
            n2 = n3;
        } while ((n3 = this.adjustRowNumbers()) > 0 && n3 < n2);
        return this.detectionResultColumns;
    }

    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            ((DetectionResultRowIndicatorColumn)detectionResultColumn).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    private int adjustRowNumbers() {
        int n2 = this.adjustRowNumbersByRow();
        if (n2 == 0) {
            return 0;
        }
        for (int i2 = 1; i2 < this.barcodeColumnCount + 1; ++i2) {
            Codeword[] codewordArray = this.detectionResultColumns[i2].getCodewords();
            for (int i3 = 0; i3 < codewordArray.length; ++i3) {
                if (codewordArray[i3] == null || codewordArray[i3].hasValidRowNumber()) continue;
                this.adjustRowNumbers(i2, i3, codewordArray);
            }
        }
        return n2;
    }

    private int adjustRowNumbersByRow() {
        this.adjustRowNumbersFromBothRI();
        int n2 = this.adjustRowNumbersFromLRI();
        return n2 + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        if (this.detectionResultColumns[0] == null || this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return;
        }
        Codeword[] codewordArray = this.detectionResultColumns[0].getCodewords();
        Codeword[] codewordArray2 = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            if (codewordArray[i2] == null || codewordArray2[i2] == null || codewordArray[i2].getRowNumber() != codewordArray2[i2].getRowNumber()) continue;
            for (int i3 = 1; i3 <= this.barcodeColumnCount; ++i3) {
                Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                if (codeword == null) continue;
                codeword.setRowNumber(codewordArray[i2].getRowNumber());
                if (codeword.hasValidRowNumber()) continue;
                this.detectionResultColumns[i3].getCodewords()[i2] = null;
            }
        }
    }

    private int adjustRowNumbersFromRRI() {
        if (this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return 0;
        }
        int n2 = 0;
        Codeword[] codewordArray = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            if (codewordArray[i2] == null) continue;
            int n3 = codewordArray[i2].getRowNumber();
            int n4 = 0;
            for (int i3 = this.barcodeColumnCount + 1; i3 > 0 && n4 < 2; --i3) {
                Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                if (codeword == null) continue;
                n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++n2;
            }
        }
        return n2;
    }

    private int adjustRowNumbersFromLRI() {
        if (this.detectionResultColumns[0] == null) {
            return 0;
        }
        int n2 = 0;
        Codeword[] codewordArray = this.detectionResultColumns[0].getCodewords();
        for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            if (codewordArray[i2] == null) continue;
            int n3 = codewordArray[i2].getRowNumber();
            int n4 = 0;
            for (int i3 = 1; i3 < this.barcodeColumnCount + 1 && n4 < 2; ++i3) {
                Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                if (codeword == null) continue;
                n4 = DetectionResult.adjustRowNumberIfValid(n3, n4, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++n2;
            }
        }
        return n2;
    }

    private static int adjustRowNumberIfValid(int n2, int n3, Codeword codeword) {
        if (codeword == null) {
            return n3;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(n2)) {
                codeword.setRowNumber(n2);
                n3 = 0;
            } else {
                ++n3;
            }
        }
        return n3;
    }

    private void adjustRowNumbers(int n2, int n3, Codeword[] codewordArray) {
        Codeword[] codewordArray2;
        Codeword codeword = codewordArray[n3];
        Codeword[] codewordArray3 = codewordArray2 = this.detectionResultColumns[n2 - 1].getCodewords();
        if (this.detectionResultColumns[n2 + 1] != null) {
            codewordArray3 = this.detectionResultColumns[n2 + 1].getCodewords();
        }
        Codeword[] codewordArray4 = new Codeword[14];
        codewordArray4[2] = codewordArray2[n3];
        codewordArray4[3] = codewordArray3[n3];
        if (n3 > 0) {
            codewordArray4[0] = codewordArray[n3 - 1];
            codewordArray4[4] = codewordArray2[n3 - 1];
            codewordArray4[5] = codewordArray3[n3 - 1];
        }
        if (n3 > 1) {
            codewordArray4[8] = codewordArray[n3 - 2];
            codewordArray4[10] = codewordArray2[n3 - 2];
            codewordArray4[11] = codewordArray3[n3 - 2];
        }
        if (n3 < codewordArray.length - 1) {
            codewordArray4[1] = codewordArray[n3 + 1];
            codewordArray4[6] = codewordArray2[n3 + 1];
            codewordArray4[7] = codewordArray3[n3 + 1];
        }
        if (n3 < codewordArray.length - 2) {
            codewordArray4[9] = codewordArray[n3 + 2];
            codewordArray4[12] = codewordArray2[n3 + 2];
            codewordArray4[13] = codewordArray3[n3 + 2];
        }
        for (Codeword codeword2 : codewordArray4) {
            if (!DetectionResult.adjustRowNumber(codeword, codeword2)) continue;
            return;
        }
    }

    private static boolean adjustRowNumber(Codeword codeword, Codeword codeword2) {
        if (codeword2 == null) {
            return false;
        }
        if (codeword2.hasValidRowNumber() && codeword2.getBucket() == codeword.getBucket()) {
            codeword.setRowNumber(codeword2.getRowNumber());
            return true;
        }
        return false;
    }

    int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    void setDetectionResultColumn(int n2, DetectionResultColumn detectionResultColumn) {
        this.detectionResultColumns[n2] = detectionResultColumn;
    }

    DetectionResultColumn getDetectionResultColumn(int n2) {
        return this.detectionResultColumns[n2];
    }

    public String toString() {
        DetectionResultColumn detectionResultColumn = this.detectionResultColumns[0];
        if (detectionResultColumn == null) {
            detectionResultColumn = this.detectionResultColumns[this.barcodeColumnCount + 1];
        }
        Formatter formatter = new Formatter();
        for (int i2 = 0; i2 < detectionResultColumn.getCodewords().length; ++i2) {
            formatter.format("CW %3d:", i2);
            for (int i3 = 0; i3 < this.barcodeColumnCount + 2; ++i3) {
                if (this.detectionResultColumns[i3] == null) {
                    formatter.format("    |   ", new Object[0]);
                    continue;
                }
                Codeword codeword = this.detectionResultColumns[i3].getCodewords()[i2];
                if (codeword == null) {
                    formatter.format("    |   ", new Object[0]);
                    continue;
                }
                formatter.format(" %3d|%3d", codeword.getRowNumber(), codeword.getValue());
            }
            formatter.format("%n", new Object[0]);
        }
        String string2 = formatter.toString();
        formatter.close();
        return string2;
    }
}

