/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final Codeword getCodewordNearby(int n2) {
        Codeword codeword = this.getCodeword(n2);
        if (codeword != null) {
            return codeword;
        }
        for (int i2 = 1; i2 < 5; ++i2) {
            int n3 = this.imageRowToCodewordIndex(n2) - i2;
            if (n3 >= 0 && (codeword = this.codewords[n3]) != null) {
                return codeword;
            }
            n3 = this.imageRowToCodewordIndex(n2) + i2;
            if (n3 >= this.codewords.length || (codeword = this.codewords[n3]) == null) continue;
            return codeword;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int n2) {
        return n2 - this.boundingBox.getMinY();
    }

    final void setCodeword(int n2, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)n2)] = codeword;
    }

    final Codeword getCodeword(int n2) {
        return this.codewords[this.imageRowToCodewordIndex(n2)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    public String toString() {
        Formatter formatter = new Formatter();
        int n2 = 0;
        for (Codeword codeword : this.codewords) {
            if (codeword == null) {
                formatter.format("%3d:    |   %n", n2++);
                continue;
            }
            formatter.format("%3d: %3d|%3d%n", n2++, codeword.getRowNumber(), codeword.getValue());
        }
        String string2 = formatter.toString();
        formatter.close();
        return string2;
    }
}

