/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.ResultPoint;
import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BarcodeValue;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;

final class DetectionResultRowIndicatorColumn
extends DetectionResultColumn {
    private final boolean isLeft;

    DetectionResultRowIndicatorColumn(BoundingBox boundingBox, boolean bl2) {
        super(boundingBox);
        this.isLeft = bl2;
    }

    void setRowNumbers() {
        for (Codeword codeword : this.getCodewords()) {
            if (codeword == null) continue;
            codeword.setRowNumberAsRowIndicatorColumn();
        }
    }

    int adjustCompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        Codeword[] codewordArray = this.getCodewords();
        this.setRowNumbers();
        this.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        BoundingBox boundingBox = this.getBoundingBox();
        ResultPoint resultPoint = this.isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        ResultPoint resultPoint2 = this.isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        int n2 = this.imageRowToCodewordIndex((int)resultPoint.getY());
        int n3 = this.imageRowToCodewordIndex((int)resultPoint2.getY());
        float f2 = (float)(n3 - n2) / (float)barcodeMetadata.getRowCount();
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (codewordArray[i2] == null) continue;
            Codeword codeword = codewordArray[i2];
            int n7 = codeword.getRowNumber() - n4;
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n7 == 1) {
                n5 = Math.max(n5, n6);
                n6 = 1;
                n4 = codeword.getRowNumber();
                continue;
            }
            if (n7 < 0 || codeword.getRowNumber() >= barcodeMetadata.getRowCount() || n7 > i2) {
                codewordArray[i2] = null;
                continue;
            }
            int n8 = n5 > 2 ? (n5 - 2) * n7 : n7;
            boolean bl2 = n8 >= i2;
            for (int i3 = 1; i3 <= n8 && !bl2; ++i3) {
                bl2 = codewordArray[i2 - i3] != null;
            }
            if (bl2) {
                codewordArray[i2] = null;
                continue;
            }
            n4 = codeword.getRowNumber();
            n6 = 1;
        }
        return (int)((double)f2 + 0.5);
    }

    int[] getRowHeights() throws FormatException {
        BarcodeMetadata barcodeMetadata = this.getBarcodeMetadata();
        if (barcodeMetadata == null) {
            return null;
        }
        this.adjustIncompleteIndicatorColumnRowNumbers(barcodeMetadata);
        int[] nArray = new int[barcodeMetadata.getRowCount()];
        for (Codeword codeword : this.getCodewords()) {
            if (codeword == null) continue;
            int n2 = codeword.getRowNumber();
            if (n2 >= nArray.length) {
                throw FormatException.getFormatInstance();
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        return nArray;
    }

    int adjustIncompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        BoundingBox boundingBox = this.getBoundingBox();
        ResultPoint resultPoint = this.isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        ResultPoint resultPoint2 = this.isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        int n2 = this.imageRowToCodewordIndex((int)resultPoint.getY());
        int n3 = this.imageRowToCodewordIndex((int)resultPoint2.getY());
        float f2 = (float)(n3 - n2) / (float)barcodeMetadata.getRowCount();
        Codeword[] codewordArray = this.getCodewords();
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (codewordArray[i2] == null) continue;
            Codeword codeword = codewordArray[i2];
            codeword.setRowNumberAsRowIndicatorColumn();
            int n7 = codeword.getRowNumber() - n4;
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n7 == 1) {
                n5 = Math.max(n5, n6);
                n6 = 1;
                n4 = codeword.getRowNumber();
                continue;
            }
            if (codeword.getRowNumber() >= barcodeMetadata.getRowCount()) {
                codewordArray[i2] = null;
                continue;
            }
            n4 = codeword.getRowNumber();
            n6 = 1;
        }
        return (int)((double)f2 + 0.5);
    }

    BarcodeMetadata getBarcodeMetadata() {
        Codeword[] codewordArray = this.getCodewords();
        BarcodeValue barcodeValue = new BarcodeValue();
        BarcodeValue barcodeValue2 = new BarcodeValue();
        BarcodeValue barcodeValue3 = new BarcodeValue();
        BarcodeValue barcodeValue4 = new BarcodeValue();
        block5: for (Codeword codeword : codewordArray) {
            if (codeword == null) continue;
            codeword.setRowNumberAsRowIndicatorColumn();
            int n2 = codeword.getValue() % 30;
            int n3 = codeword.getRowNumber();
            if (!this.isLeft) {
                n3 += 2;
            }
            switch (n3 % 3) {
                case 0: {
                    barcodeValue2.setValue(n2 * 3 + 1);
                    continue block5;
                }
                case 1: {
                    barcodeValue4.setValue(n2 / 3);
                    barcodeValue3.setValue(n2 % 3);
                    continue block5;
                }
                case 2: {
                    barcodeValue.setValue(n2 + 1);
                }
            }
        }
        if (barcodeValue.getValue().length == 0 || barcodeValue2.getValue().length == 0 || barcodeValue3.getValue().length == 0 || barcodeValue4.getValue().length == 0 || barcodeValue.getValue()[0] < 1 || barcodeValue2.getValue()[0] + barcodeValue3.getValue()[0] < 3 || barcodeValue2.getValue()[0] + barcodeValue3.getValue()[0] > 90) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = new BarcodeMetadata(barcodeValue.getValue()[0], barcodeValue2.getValue()[0], barcodeValue3.getValue()[0], barcodeValue4.getValue()[0]);
        this.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        return barcodeMetadata;
    }

    private void removeIncorrectCodewords(Codeword[] codewordArray, BarcodeMetadata barcodeMetadata) {
        block5: for (int i2 = 0; i2 < codewordArray.length; ++i2) {
            Codeword codeword = codewordArray[i2];
            if (codewordArray[i2] == null) continue;
            int n2 = codeword.getValue() % 30;
            int n3 = codeword.getRowNumber();
            if (n3 > barcodeMetadata.getRowCount()) {
                codewordArray[i2] = null;
                continue;
            }
            if (!this.isLeft) {
                n3 += 2;
            }
            switch (n3 % 3) {
                case 0: {
                    if (n2 * 3 + 1 == barcodeMetadata.getRowCountUpperPart()) continue block5;
                    codewordArray[i2] = null;
                    continue block5;
                }
                case 1: {
                    if (n2 / 3 == barcodeMetadata.getErrorCorrectionLevel() && n2 % 3 == barcodeMetadata.getRowCountLowerPart()) continue block5;
                    codewordArray[i2] = null;
                    continue block5;
                }
                case 2: {
                    if (n2 + 1 == barcodeMetadata.getColumnCount()) continue block5;
                    codewordArray[i2] = null;
                }
            }
        }
    }

    boolean isLeft() {
        return this.isLeft;
    }

    @Override
    public String toString() {
        return "IsLeft: " + this.isLeft + '\n' + super.toString();
    }
}

