/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.pdf417.PDF417Common;
import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BarcodeValue;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DecodedBitStreamParser;
import com.google.zxing.pdf417.decoder.DetectionResult;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.google.zxing.pdf417.decoder.PDF417CodewordDecoder;
import com.google.zxing.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    public static DecoderResult decode(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2, int n3) throws NotFoundException, FormatException, ChecksumException {
        int n4;
        BoundingBox boundingBox = new BoundingBox(bitMatrix, resultPoint, resultPoint2, resultPoint3, resultPoint4);
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = null;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = null;
        DetectionResult detectionResult = null;
        for (n4 = 0; n4 < 2; ++n4) {
            if (resultPoint != null) {
                detectionResultRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox, resultPoint, true, n2, n3);
            }
            if (resultPoint3 != null) {
                detectionResultRowIndicatorColumn2 = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox, resultPoint3, false, n2, n3);
            }
            if ((detectionResult = PDF417ScanningDecoder.merge(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2)) == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            if (n4 != 0 || detectionResult.getBoundingBox() == null || detectionResult.getBoundingBox().getMinY() >= boundingBox.getMinY() && detectionResult.getBoundingBox().getMaxY() <= boundingBox.getMaxY()) {
                detectionResult.setBoundingBox(boundingBox);
                break;
            }
            boundingBox = detectionResult.getBoundingBox();
        }
        n4 = detectionResult.getBarcodeColumnCount() + 1;
        detectionResult.setDetectionResultColumn(0, detectionResultRowIndicatorColumn);
        detectionResult.setDetectionResultColumn(n4, detectionResultRowIndicatorColumn2);
        boolean bl2 = detectionResultRowIndicatorColumn != null;
        for (int i2 = 1; i2 <= n4; ++i2) {
            int n5;
            int n6;
            int n7 = n6 = bl2 ? i2 : n4 - i2;
            if (detectionResult.getDetectionResultColumn(n6) != null) continue;
            DetectionResultColumn detectionResultColumn = n6 == 0 || n6 == n4 ? new DetectionResultRowIndicatorColumn(boundingBox, n6 == 0) : new DetectionResultColumn(boundingBox);
            detectionResult.setDetectionResultColumn(n6, detectionResultColumn);
            int n8 = n5 = -1;
            for (int i3 = boundingBox.getMinY(); i3 <= boundingBox.getMaxY(); ++i3) {
                Codeword codeword;
                n5 = PDF417ScanningDecoder.getStartColumn(detectionResult, n6, i3, bl2);
                if (n5 < 0 || n5 > boundingBox.getMaxX()) {
                    if (n8 == -1) continue;
                    n5 = n8;
                }
                if ((codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, boundingBox.getMinX(), boundingBox.getMaxX(), bl2, n5, i3, n2, n3)) == null) continue;
                detectionResultColumn.setCodeword(i3, codeword);
                n8 = n5;
                n2 = Math.min(n2, codeword.getWidth());
                n3 = Math.max(n3, codeword.getWidth());
            }
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) throws NotFoundException, FormatException {
        if (detectionResultRowIndicatorColumn == null && detectionResultRowIndicatorColumn2 == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2);
        if (barcodeMetadata == null) {
            return null;
        }
        BoundingBox boundingBox = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn2));
        return new DetectionResult(barcodeMetadata, boundingBox);
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException, FormatException {
        int n2;
        if (detectionResultRowIndicatorColumn == null) {
            return null;
        }
        int[] nArray = detectionResultRowIndicatorColumn.getRowHeights();
        if (nArray == null) {
            return null;
        }
        int n3 = PDF417ScanningDecoder.getMax(nArray);
        int n4 = 0;
        for (int n5 : nArray) {
            n4 += n3 - n5;
            if (n5 > 0) break;
        }
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        int n6 = 0;
        while (n4 > 0 && codewordArray[n6] == null) {
            --n4;
            ++n6;
        }
        n6 = 0;
        for (n2 = nArray.length - 1; n2 >= 0; --n2) {
            n6 += n3 - nArray[n2];
            if (nArray[n2] > 0) break;
        }
        n2 = codewordArray.length - 1;
        while (n6 > 0 && codewordArray[n2] == null) {
            --n6;
            --n2;
        }
        return detectionResultRowIndicatorColumn.getBoundingBox().addMissingRows(n4, n6, detectionResultRowIndicatorColumn.isLeft());
    }

    private static int getMax(int[] nArray) {
        int n2 = -1;
        for (int n3 : nArray) {
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) {
        BarcodeMetadata barcodeMetadata;
        BarcodeMetadata barcodeMetadata2;
        if (detectionResultRowIndicatorColumn == null || (barcodeMetadata2 = detectionResultRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return detectionResultRowIndicatorColumn2 == null ? null : detectionResultRowIndicatorColumn2.getBarcodeMetadata();
        }
        if (detectionResultRowIndicatorColumn2 == null || (barcodeMetadata = detectionResultRowIndicatorColumn2.getBarcodeMetadata()) == null) {
            return barcodeMetadata2;
        }
        if (barcodeMetadata2.getColumnCount() != barcodeMetadata.getColumnCount() && barcodeMetadata2.getErrorCorrectionLevel() != barcodeMetadata.getErrorCorrectionLevel() && barcodeMetadata2.getRowCount() != barcodeMetadata.getRowCount()) {
            return null;
        }
        return barcodeMetadata2;
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix bitMatrix, BoundingBox boundingBox, ResultPoint resultPoint, boolean bl2, int n2, int n3) {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, bl2);
        for (int i2 = 0; i2 < 2; ++i2) {
            int n4 = i2 == 0 ? 1 : -1;
            int n5 = (int)resultPoint.getX();
            for (int i3 = (int)resultPoint.getY(); i3 <= boundingBox.getMaxY() && i3 >= boundingBox.getMinY(); i3 += n4) {
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, 0, bitMatrix.getWidth(), bl2, n5, i3, n2, n3);
                if (codeword == null) continue;
                detectionResultRowIndicatorColumn.setCodeword(i3, codeword);
                n5 = bl2 ? codeword.getStartX() : codeword.getEndX();
            }
        }
        return detectionResultRowIndicatorColumn;
    }

    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeValueArray) throws NotFoundException {
        int[] nArray = barcodeValueArray[0][1].getValue();
        int n2 = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (nArray.length == 0) {
            if (n2 < 1 || n2 > 928) {
                throw NotFoundException.getNotFoundInstance();
            }
            barcodeValueArray[0][1].setValue(n2);
        } else if (nArray[0] != n2) {
            barcodeValueArray[0][1].setValue(n2);
        }
    }

    private static DecoderResult createDecoderResult(DetectionResult detectionResult) throws FormatException, ChecksumException, NotFoundException {
        int n2;
        BarcodeValue[][] barcodeValueArray = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeValueArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = new int[detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount()];
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i2 = 0; i2 < detectionResult.getBarcodeRowCount(); ++i2) {
            for (n2 = 0; n2 < detectionResult.getBarcodeColumnCount(); ++n2) {
                int[] nArray2 = barcodeValueArray[i2][n2 + 1].getValue();
                int n3 = i2 * detectionResult.getBarcodeColumnCount() + n2;
                if (nArray2.length == 0) {
                    arrayList.add(n3);
                    continue;
                }
                if (nArray2.length == 1) {
                    nArray[n3] = nArray2[0];
                    continue;
                }
                arrayList3.add(n3);
                arrayList2.add(nArray2);
            }
        }
        int[][] nArrayArray = new int[arrayList2.size()][];
        for (n2 = 0; n2 < nArrayArray.length; ++n2) {
            nArrayArray[n2] = (int[])arrayList2.get(n2);
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult.getBarcodeECLevel(), nArray, PDF417Common.toIntArray(arrayList), PDF417Common.toIntArray(arrayList3), nArrayArray);
    }

    private static DecoderResult createDecoderResultFromAmbiguousValues(int n2, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4) throws FormatException, ChecksumException {
        int[] nArray5 = new int[nArray3.length];
        int n3 = 100;
        block2: while (n3-- > 0) {
            int n4;
            for (n4 = 0; n4 < nArray5.length; ++n4) {
                nArray[nArray3[n4]] = nArray4[n4][nArray5[n4]];
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(nArray, n2, nArray2);
            }
            catch (ChecksumException checksumException) {
                if (nArray5.length == 0) {
                    throw ChecksumException.getChecksumInstance();
                }
                for (n4 = 0; n4 < nArray5.length; ++n4) {
                    if (nArray5[n4] < nArray4[n4].length - 1) {
                        int n5 = n4;
                        nArray5[n5] = nArray5[n5] + 1;
                        continue block2;
                    }
                    nArray5[n4] = 0;
                    if (n4 != nArray5.length - 1) continue;
                    throw ChecksumException.getChecksumInstance();
                }
            }
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) throws FormatException {
        int n2;
        BarcodeValue[][] barcodeValueArray = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        for (n2 = 0; n2 < barcodeValueArray.length; ++n2) {
            for (int i2 = 0; i2 < barcodeValueArray[n2].length; ++i2) {
                barcodeValueArray[n2][i2] = new BarcodeValue();
            }
        }
        n2 = 0;
        for (DetectionResultColumn detectionResultColumn : detectionResult.getDetectionResultColumns()) {
            if (detectionResultColumn != null) {
                for (Codeword codeword : detectionResultColumn.getCodewords()) {
                    int n3;
                    if (codeword == null || (n3 = codeword.getRowNumber()) < 0) continue;
                    if (n3 >= barcodeValueArray.length) {
                        throw FormatException.getFormatInstance();
                    }
                    barcodeValueArray[n3][n2].setValue(codeword.getValue());
                }
            }
            ++n2;
        }
        return barcodeValueArray;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int n2) {
        return n2 >= 0 && n2 <= detectionResult.getBarcodeColumnCount() + 1;
    }

    private static int getStartColumn(DetectionResult detectionResult, int n2, int n3, boolean bl2) {
        int n4 = bl2 ? 1 : -1;
        Codeword codeword = null;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n2 - n4)) {
            codeword = detectionResult.getDetectionResultColumn(n2 - n4).getCodeword(n3);
        }
        if (codeword != null) {
            return bl2 ? codeword.getEndX() : codeword.getStartX();
        }
        codeword = detectionResult.getDetectionResultColumn(n2).getCodewordNearby(n3);
        if (codeword != null) {
            return bl2 ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n2 - n4)) {
            codeword = detectionResult.getDetectionResultColumn(n2 - n4).getCodewordNearby(n3);
        }
        if (codeword != null) {
            return bl2 ? codeword.getEndX() : codeword.getStartX();
        }
        int n5 = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n2 - n4)) {
            for (Codeword codeword2 : detectionResult.getDetectionResultColumn(n2 -= n4).getCodewords()) {
                if (codeword2 == null) continue;
                return (bl2 ? codeword2.getEndX() : codeword2.getStartX()) + n4 * n5 * (codeword2.getEndX() - codeword2.getStartX());
            }
            ++n5;
        }
        return bl2 ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    }

    private static Codeword detectCodeword(BitMatrix bitMatrix, int n2, int n3, boolean bl2, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int[] nArray = PDF417ScanningDecoder.getModuleBitCount(bitMatrix, n2, n3, bl2, n4 = PDF417ScanningDecoder.adjustCodewordStartColumn(bitMatrix, n2, n3, bl2, n4, n5), n5);
        if (nArray == null) {
            return null;
        }
        int n11 = PDF417Common.getBitCountSum(nArray);
        if (bl2) {
            n10 = n4 + n11;
        } else {
            for (n9 = 0; n9 < nArray.length / 2; ++n9) {
                n8 = nArray[n9];
                nArray[n9] = nArray[nArray.length - 1 - n9];
                nArray[nArray.length - 1 - n9] = n8;
            }
            n10 = n4;
            n4 = n10 - n11;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(n11, n6, n7)) {
            return null;
        }
        n9 = PDF417CodewordDecoder.getDecodedValue(nArray);
        n8 = PDF417Common.getCodeword(n9);
        if (n8 == -1) {
            return null;
        }
        return new Codeword(n4, n10, PDF417ScanningDecoder.getCodewordBucketNumber(n9), n8);
    }

    private static int[] getModuleBitCount(BitMatrix bitMatrix, int n2, int n3, boolean bl2, int n4, int n5) {
        int n6 = n4;
        int[] nArray = new int[8];
        int n7 = 0;
        int n8 = bl2 ? 1 : -1;
        boolean bl3 = bl2;
        while ((bl2 && n6 < n3 || !bl2 && n6 >= n2) && n7 < nArray.length) {
            if (bitMatrix.get(n6, n5) == bl3) {
                int n9 = n7;
                nArray[n9] = nArray[n9] + 1;
                n6 += n8;
                continue;
            }
            ++n7;
            bl3 = !bl3;
        }
        if (n7 == nArray.length || (bl2 && n6 == n3 || !bl2 && n6 == n2) && n7 == nArray.length - 1) {
            return nArray;
        }
        return null;
    }

    private static int getNumberOfECCodeWords(int n2) {
        return 2 << n2;
    }

    private static int adjustCodewordStartColumn(BitMatrix bitMatrix, int n2, int n3, boolean bl2, int n4, int n5) {
        int n6 = n4;
        int n7 = bl2 ? -1 : 1;
        for (int i2 = 0; i2 < 2; ++i2) {
            while ((bl2 && n6 >= n2 || !bl2 && n6 < n3) && bl2 == bitMatrix.get(n6, n5)) {
                if (Math.abs(n4 - n6) > 2) {
                    return n4;
                }
                n6 += n7;
            }
            n7 = -n7;
            bl2 = !bl2;
        }
        return n6;
    }

    private static boolean checkCodewordSkew(int n2, int n3, int n4) {
        return n3 - 2 <= n2 && n2 <= n4 + 2;
    }

    private static DecoderResult decodeCodewords(int[] nArray, int n2, int[] nArray2) throws FormatException, ChecksumException {
        if (nArray.length == 0) {
            throw FormatException.getFormatInstance();
        }
        int n3 = 1 << n2 + 1;
        int n4 = PDF417ScanningDecoder.correctErrors(nArray, nArray2, n3);
        PDF417ScanningDecoder.verifyCodewordCount(nArray, n3);
        DecoderResult decoderResult = DecodedBitStreamParser.decode(nArray, String.valueOf(n2));
        decoderResult.setErrorsCorrected(n4);
        decoderResult.setErasures(nArray2.length);
        return decoderResult;
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n2) throws ChecksumException {
        if (nArray2 != null && nArray2.length > n2 / 2 + 3 || n2 < 0 || n2 > 512) {
            throw ChecksumException.getChecksumInstance();
        }
        return errorCorrection.decode(nArray, n2, nArray2);
    }

    private static void verifyCodewordCount(int[] nArray, int n2) throws FormatException {
        if (nArray.length < 4) {
            throw FormatException.getFormatInstance();
        }
        int n3 = nArray[0];
        if (n3 > nArray.length) {
            throw FormatException.getFormatInstance();
        }
        if (n3 == 0) {
            if (n2 < nArray.length) {
                nArray[0] = nArray.length - n2;
            } else {
                throw FormatException.getFormatInstance();
            }
        }
    }

    private static int[] getBitCountForCodeword(int n2) {
        int[] nArray = new int[8];
        int n3 = 0;
        int n4 = nArray.length - 1;
        while (true) {
            if ((n2 & 1) != n3) {
                n3 = n2 & 1;
                if (--n4 < 0) break;
            }
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
            n2 >>= 1;
        }
        return nArray;
    }

    private static int getCodewordBucketNumber(int n2) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(n2));
    }

    private static int getCodewordBucketNumber(int[] nArray) {
        return (nArray[0] - nArray[2] + nArray[4] - nArray[6] + 9) % 9;
    }

    public static String toString(BarcodeValue[][] barcodeValueArray) {
        Formatter formatter = new Formatter();
        for (int i2 = 0; i2 < barcodeValueArray.length; ++i2) {
            formatter.format("Row %2d: ", i2);
            for (int i3 = 0; i3 < barcodeValueArray[i2].length; ++i3) {
                BarcodeValue barcodeValue = barcodeValueArray[i2][i3];
                if (barcodeValue.getValue().length == 0) {
                    formatter.format("        ", (Object[])null);
                    continue;
                }
                formatter.format("%4d(%2d)", barcodeValue.getValue()[0], barcodeValue.getConfidence(barcodeValue.getValue()[0]));
            }
            formatter.format("%n", new Object[0]);
        }
        String string2 = formatter.toString();
        formatter.close();
        return string2;
    }
}

