/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.ChecksumException;
import com.google.zxing.pdf417.decoder.ec.ModulusGF;
import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    public int decode(int[] nArray, int n2, int[] nArray2) throws ChecksumException {
        Object object;
        ModulusPoly modulusPoly = new ModulusPoly(this.field, nArray);
        int[] nArray3 = new int[n2];
        boolean bl2 = false;
        for (int i2 = n2; i2 > 0; --i2) {
            int n3;
            nArray3[n2 - i2] = n3 = modulusPoly.evaluateAt(this.field.exp(i2));
            if (n3 == 0) continue;
            bl2 = true;
        }
        if (!bl2) {
            return 0;
        }
        ModulusPoly modulusPoly2 = this.field.getOne();
        if (nArray2 != null) {
            for (int n4 : nArray2) {
                int n5 = this.field.exp(nArray.length - 1 - n4);
                object = new ModulusPoly(this.field, new int[]{this.field.subtract(0, n5), 1});
                modulusPoly2 = modulusPoly2.multiply((ModulusPoly)object);
            }
        }
        ModulusPoly modulusPoly3 = new ModulusPoly(this.field, nArray3);
        ModulusPoly[] modulusPolyArray = this.runEuclideanAlgorithm(this.field.buildMonomial(n2, 1), modulusPoly3, n2);
        ModulusPoly modulusPoly4 = modulusPolyArray[0];
        ModulusPoly modulusPoly5 = modulusPolyArray[1];
        int[] nArray4 = this.findErrorLocations(modulusPoly4);
        object = this.findErrorMagnitudes(modulusPoly5, modulusPoly4, nArray4);
        for (int i3 = 0; i3 < nArray4.length; ++i3) {
            int n6 = nArray.length - 1 - this.field.log(nArray4[i3]);
            if (n6 < 0) {
                throw ChecksumException.getChecksumInstance();
            }
            nArray[n6] = this.field.subtract(nArray[n6], object[i3]);
        }
        return nArray4.length;
    }

    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int n2) throws ChecksumException {
        ModulusPoly modulusPoly3;
        ModulusPoly modulusPoly4;
        if (modulusPoly.getDegree() < modulusPoly2.getDegree()) {
            modulusPoly4 = modulusPoly;
            modulusPoly = modulusPoly2;
            modulusPoly2 = modulusPoly4;
        }
        modulusPoly4 = modulusPoly;
        ModulusPoly modulusPoly5 = modulusPoly2;
        ModulusPoly modulusPoly6 = this.field.getZero();
        ModulusPoly modulusPoly7 = this.field.getOne();
        while (modulusPoly5.getDegree() >= n2 / 2) {
            ModulusPoly modulusPoly8 = modulusPoly4;
            ModulusPoly modulusPoly9 = modulusPoly6;
            modulusPoly4 = modulusPoly5;
            modulusPoly6 = modulusPoly7;
            if (modulusPoly4.isZero()) {
                throw ChecksumException.getChecksumInstance();
            }
            modulusPoly5 = modulusPoly8;
            modulusPoly3 = this.field.getZero();
            int n3 = modulusPoly4.getCoefficient(modulusPoly4.getDegree());
            int n4 = this.field.inverse(n3);
            while (modulusPoly5.getDegree() >= modulusPoly4.getDegree() && !modulusPoly5.isZero()) {
                int n5 = modulusPoly5.getDegree() - modulusPoly4.getDegree();
                int n6 = this.field.multiply(modulusPoly5.getCoefficient(modulusPoly5.getDegree()), n4);
                modulusPoly3 = modulusPoly3.add(this.field.buildMonomial(n5, n6));
                modulusPoly5 = modulusPoly5.subtract(modulusPoly4.multiplyByMonomial(n5, n6));
            }
            modulusPoly7 = modulusPoly3.multiply(modulusPoly6).subtract(modulusPoly9).negative();
        }
        int n7 = modulusPoly7.getCoefficient(0);
        if (n7 == 0) {
            throw ChecksumException.getChecksumInstance();
        }
        int n8 = this.field.inverse(n7);
        modulusPoly3 = modulusPoly7.multiply(n8);
        ModulusPoly modulusPoly10 = modulusPoly5.multiply(n8);
        return new ModulusPoly[]{modulusPoly3, modulusPoly10};
    }

    private int[] findErrorLocations(ModulusPoly modulusPoly) throws ChecksumException {
        int n2 = modulusPoly.getDegree();
        int[] nArray = new int[n2];
        int n3 = 0;
        for (int i2 = 1; i2 < this.field.getSize() && n3 < n2; ++i2) {
            if (modulusPoly.evaluateAt(i2) != 0) continue;
            nArray[n3] = this.field.inverse(i2);
            ++n3;
        }
        if (n3 != n2) {
            throw ChecksumException.getChecksumInstance();
        }
        return nArray;
    }

    private int[] findErrorMagnitudes(ModulusPoly modulusPoly, ModulusPoly modulusPoly2, int[] nArray) {
        int n2 = modulusPoly2.getDegree();
        int[] nArray2 = new int[n2];
        for (int i2 = 1; i2 <= n2; ++i2) {
            nArray2[n2 - i2] = this.field.multiply(i2, modulusPoly2.getCoefficient(i2));
        }
        ModulusPoly modulusPoly3 = new ModulusPoly(this.field, nArray2);
        int n3 = nArray.length;
        int[] nArray3 = new int[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            int n4 = this.field.inverse(nArray[i3]);
            int n5 = this.field.subtract(0, modulusPoly.evaluateAt(n4));
            int n6 = this.field.inverse(modulusPoly3.evaluateAt(n4));
            nArray3[i3] = this.field.multiply(n5, n6);
        }
        return nArray3;
    }
}

