/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final ModulusPoly zero;
    private final ModulusPoly one;
    private final int modulus;

    private ModulusGF(int n2, int n3) {
        int n4;
        this.modulus = n2;
        this.expTable = new int[n2];
        this.logTable = new int[n2];
        int n5 = 1;
        for (n4 = 0; n4 < n2; ++n4) {
            this.expTable[n4] = n5;
            n5 = n5 * n3 % n2;
        }
        for (n4 = 0; n4 < n2 - 1; ++n4) {
            this.logTable[this.expTable[n4]] = n4;
        }
        this.zero = new ModulusPoly(this, new int[]{0});
        this.one = new ModulusPoly(this, new int[]{1});
    }

    ModulusPoly getZero() {
        return this.zero;
    }

    ModulusPoly getOne() {
        return this.one;
    }

    ModulusPoly buildMonomial(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n3 == 0) {
            return this.zero;
        }
        int[] nArray = new int[n2 + 1];
        nArray[0] = n3;
        return new ModulusPoly(this, nArray);
    }

    int add(int n2, int n3) {
        return (n2 + n3) % this.modulus;
    }

    int subtract(int n2, int n3) {
        return (this.modulus + n2 - n3) % this.modulus;
    }

    int exp(int n2) {
        return this.expTable[n2];
    }

    int log(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[n2];
    }

    int inverse(int n2) {
        if (n2 == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.modulus - this.logTable[n2] - 1];
    }

    int multiply(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[n2] + this.logTable[n3]) % (this.modulus - 1)];
    }

    int getSize() {
        return this.modulus;
    }
}

