/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.pdf417.decoder.ec.ModulusGF;

final class ModulusPoly {
    private final ModulusGF field;
    private final int[] coefficients;

    ModulusPoly(ModulusGF modulusGF, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = modulusGF;
        int n2 = nArray.length;
        if (n2 > 1 && nArray[0] == 0) {
            int n3;
            for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
            }
            if (n3 == n2) {
                this.coefficients = new int[]{0};
            } else {
                this.coefficients = new int[n2 - n3];
                System.arraycopy(nArray, n3, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n2) {
        return this.coefficients[this.coefficients.length - 1 - n2];
    }

    int evaluateAt(int n2) {
        if (n2 == 0) {
            return this.getCoefficient(0);
        }
        int n3 = this.coefficients.length;
        if (n2 == 1) {
            int n4 = 0;
            for (int n5 : this.coefficients) {
                n4 = this.field.add(n4, n5);
            }
            return n4;
        }
        int n6 = this.coefficients[0];
        for (int i2 = 1; i2 < n3; ++i2) {
            n6 = this.field.add(this.field.multiply(n2, n6), this.coefficients[i2]);
        }
        return n6;
    }

    ModulusPoly add(ModulusPoly modulusPoly) {
        int[] nArray;
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (this.isZero()) {
            return modulusPoly;
        }
        if (modulusPoly.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = modulusPoly.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n2 = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n2);
        for (int i2 = n2; i2 < nArray3.length; ++i2) {
            nArray[i2] = this.field.add(nArray2[i2 - n2], nArray3[i2]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly subtract(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (modulusPoly.isZero()) {
            return this;
        }
        return this.add(modulusPoly.negative());
    }

    ModulusPoly multiply(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (this.isZero() || modulusPoly.isZero()) {
            return this.field.getZero();
        }
        int[] nArray = this.coefficients;
        int n2 = nArray.length;
        int[] nArray2 = modulusPoly.coefficients;
        int n3 = nArray2.length;
        int[] nArray3 = new int[n2 + n3 - 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                nArray3[i2 + i3] = this.field.add(nArray3[i2 + i3], this.field.multiply(n4, nArray2[i3]));
            }
        }
        return new ModulusPoly(this.field, nArray3);
    }

    ModulusPoly negative() {
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = this.field.subtract(0, this.coefficients[i2]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiply(int n2) {
        if (n2 == 0) {
            return this.field.getZero();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.field.multiply(this.coefficients[i2], n2);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiplyByMonomial(int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n3 == 0) {
            return this.field.getZero();
        }
        int n4 = this.coefficients.length;
        int[] nArray = new int[n4 + n2];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = this.field.multiply(this.coefficients[i2], n3);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly[] divide(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (modulusPoly.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        ModulusPoly modulusPoly2 = this.field.getZero();
        ModulusPoly modulusPoly3 = this;
        int n2 = modulusPoly.getCoefficient(modulusPoly.getDegree());
        int n3 = this.field.inverse(n2);
        while (modulusPoly3.getDegree() >= modulusPoly.getDegree() && !modulusPoly3.isZero()) {
            int n4 = modulusPoly3.getDegree() - modulusPoly.getDegree();
            int n5 = this.field.multiply(modulusPoly3.getCoefficient(modulusPoly3.getDegree()), n3);
            ModulusPoly modulusPoly4 = modulusPoly.multiplyByMonomial(n4, n5);
            ModulusPoly modulusPoly5 = this.field.buildMonomial(n4, n5);
            modulusPoly2 = modulusPoly2.add(modulusPoly5);
            modulusPoly3 = modulusPoly3.subtract(modulusPoly4);
        }
        return new ModulusPoly[]{modulusPoly2, modulusPoly3};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(8 * this.getDegree());
        for (int i2 = this.getDegree(); i2 >= 0; --i2) {
            int n2 = this.getCoefficient(i2);
            if (n2 == 0) continue;
            if (n2 < 0) {
                stringBuilder.append(" - ");
                n2 = -n2;
            } else if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            if (i2 == 0 || n2 != 1) {
                stringBuilder.append(n2);
            }
            if (i2 == 0) continue;
            if (i2 == 1) {
                stringBuilder.append('x');
                continue;
            }
            stringBuilder.append("x^");
            stringBuilder.append(i2);
        }
        return stringBuilder.toString();
    }
}

