/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map, boolean bl2) throws NotFoundException {
        BitMatrix bitMatrix = binaryBitmap.getBlackMatrix();
        List<ResultPoint[]> list = Detector.detect(bl2, bitMatrix);
        if (list.isEmpty()) {
            bitMatrix = bitMatrix.clone();
            bitMatrix.rotate180();
            list = Detector.detect(bl2, bitMatrix);
        }
        return new PDF417DetectorResult(bitMatrix, list);
    }

    private static List<ResultPoint[]> detect(boolean bl2, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        while (n2 < bitMatrix.getHeight()) {
            ResultPoint[] resultPointArray = Detector.findVertices(bitMatrix, n2, n3);
            if (resultPointArray[0] == null && resultPointArray[3] == null) {
                if (!bl3) break;
                bl3 = false;
                n3 = 0;
                for (ResultPoint[] resultPointArray2 : arrayList) {
                    if (resultPointArray2[1] != null) {
                        n2 = (int)Math.max((float)n2, resultPointArray2[1].getY());
                    }
                    if (resultPointArray2[3] == null) continue;
                    n2 = Math.max(n2, (int)resultPointArray2[3].getY());
                }
                n2 += 5;
                continue;
            }
            bl3 = true;
            arrayList.add(resultPointArray);
            if (!bl2) break;
            if (resultPointArray[2] != null) {
                n3 = (int)resultPointArray[2].getX();
                n2 = (int)resultPointArray[2].getY();
                continue;
            }
            n3 = (int)resultPointArray[4].getX();
            n2 = (int)resultPointArray[4].getY();
        }
        return arrayList;
    }

    private static ResultPoint[] findVertices(BitMatrix bitMatrix, int n2, int n3) {
        int n4 = bitMatrix.getHeight();
        int n5 = bitMatrix.getWidth();
        ResultPoint[] resultPointArray = new ResultPoint[8];
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n4, n5, n2, n3, START_PATTERN), INDEXES_START_PATTERN);
        if (resultPointArray[4] != null) {
            n3 = (int)resultPointArray[4].getX();
            n2 = (int)resultPointArray[4].getY();
        }
        Detector.copyToResult(resultPointArray, Detector.findRowsWithPattern(bitMatrix, n4, n5, n2, n3, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return resultPointArray;
    }

    private static void copyToResult(ResultPoint[] resultPointArray, ResultPoint[] resultPointArray2, int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            resultPointArray[nArray[i2]] = resultPointArray2[i2];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix bitMatrix, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        ResultPoint[] resultPointArray = new ResultPoint[4];
        boolean bl2 = false;
        int[] nArray2 = new int[nArray.length];
        while (n4 < n2) {
            int[] nArray3 = Detector.findGuardPattern(bitMatrix, n5, n4, n3, false, nArray, nArray2);
            if (nArray3 != null) {
                while (n4 > 0) {
                    int[] nArray4;
                    if ((nArray4 = Detector.findGuardPattern(bitMatrix, n5, --n4, n3, false, nArray, nArray2)) != null) {
                        nArray3 = nArray4;
                        continue;
                    }
                    ++n4;
                    break;
                }
                resultPointArray[0] = new ResultPoint(nArray3[0], n4);
                resultPointArray[1] = new ResultPoint(nArray3[1], n4);
                bl2 = true;
                break;
            }
            n4 += 5;
        }
        if (bl2) {
            int n7 = 0;
            int[] nArray5 = new int[]{(int)resultPointArray[0].getX(), (int)resultPointArray[1].getX()};
            for (n6 = n4 + 1; n6 < n2; ++n6) {
                int[] nArray6 = Detector.findGuardPattern(bitMatrix, nArray5[0], n6, n3, false, nArray, nArray2);
                if (nArray6 != null && Math.abs(nArray5[0] - nArray6[0]) < 5 && Math.abs(nArray5[1] - nArray6[1]) < 5) {
                    nArray5 = nArray6;
                    n7 = 0;
                    continue;
                }
                if (n7 > 25) break;
                ++n7;
            }
            resultPointArray[2] = new ResultPoint(nArray5[0], n6 -= n7 + 1);
            resultPointArray[3] = new ResultPoint(nArray5[1], n6);
        }
        if (n6 - n4 < 10) {
            for (int i2 = 0; i2 < resultPointArray.length; ++i2) {
                resultPointArray[i2] = null;
            }
        }
        return resultPointArray;
    }

    private static int[] findGuardPattern(BitMatrix bitMatrix, int n2, int n3, int n4, boolean bl2, int[] nArray, int[] nArray2) {
        int n5;
        int n6;
        Arrays.fill(nArray2, 0, nArray2.length, 0);
        int n7 = nArray.length;
        boolean bl3 = bl2;
        int n8 = 0;
        for (n6 = n2; bitMatrix.get(n6, n3) && n6 > 0 && n8++ < 3; --n6) {
        }
        int n9 = 0;
        for (n5 = n6; n5 < n4; ++n5) {
            boolean bl4 = bitMatrix.get(n5, n3);
            if (bl4 ^ bl3) {
                int n10 = n9;
                nArray2[n10] = nArray2[n10] + 1;
                continue;
            }
            if (n9 == n7 - 1) {
                if (Detector.patternMatchVariance(nArray2, nArray, 0.8f) < 0.42f) {
                    return new int[]{n6, n5};
                }
                n6 += nArray2[0] + nArray2[1];
                System.arraycopy(nArray2, 2, nArray2, 0, n7 - 2);
                nArray2[n7 - 2] = 0;
                nArray2[n7 - 1] = 0;
                --n9;
            } else {
                ++n9;
            }
            nArray2[n9] = 1;
            bl3 = !bl3;
        }
        if (n9 == n7 - 1 && Detector.patternMatchVariance(nArray2, nArray, 0.8f) < 0.42f) {
            return new int[]{n6, n5 - 1};
        }
        return null;
    }

    private static float patternMatchVariance(int[] nArray, int[] nArray2, float f2) {
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += nArray[i2];
            n4 += nArray2[i2];
        }
        if (n3 < n4) {
            return Float.POSITIVE_INFINITY;
        }
        float f3 = (float)n3 / (float)n4;
        f2 *= f3;
        float f4 = 0.0f;
        for (int i3 = 0; i3 < n2; ++i3) {
            float f5;
            int n5 = nArray[i3];
            float f6 = (float)nArray2[i3] * f3;
            float f7 = f5 = (float)n5 > f6 ? (float)n5 - f6 : f6 - (float)n5;
            if (f5 > f2) {
                return Float.POSITIVE_INFINITY;
            }
            f4 += f5;
        }
        return f4 / (float)n3;
    }
}

