/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.encoder;

import com.google.zxing.WriterException;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.List;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;
    private static final List<String> DEFAULT_ENCODING_NAMES;

    private PDF417HighLevelEncoder() {
    }

    static String encodeHighLevel(String string2, Compaction compaction, Charset charset) throws WriterException {
        CharacterSetECI characterSetECI;
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        if (charset != null && !DEFAULT_ENCODING_NAMES.contains(charset.name()) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName(charset.name())) != null) {
            PDF417HighLevelEncoder.encodingECI(characterSetECI.getValue(), stringBuilder);
        }
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        if (compaction == Compaction.TEXT) {
            PDF417HighLevelEncoder.encodeText(string2, n3, n2, stringBuilder, n4);
        } else if (compaction == Compaction.BYTE) {
            byArray = PDF417HighLevelEncoder.toBytes(string2, charset);
            PDF417HighLevelEncoder.encodeBinary(byArray, n3, byArray.length, 1, stringBuilder);
        } else if (compaction == Compaction.NUMERIC) {
            stringBuilder.append('\u0386');
            PDF417HighLevelEncoder.encodeNumeric(string2, n3, n2, stringBuilder);
        } else {
            int n5 = 0;
            while (n3 < n2) {
                int n6;
                int n7 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(string2, n3);
                if (n7 >= 13) {
                    stringBuilder.append('\u0386');
                    n5 = 2;
                    n4 = 0;
                    PDF417HighLevelEncoder.encodeNumeric(string2, n3, n7, stringBuilder);
                    n3 += n7;
                    continue;
                }
                int n8 = PDF417HighLevelEncoder.determineConsecutiveTextCount(string2, n3);
                if (n8 >= 5 || n7 == n2) {
                    if (n5 != 0) {
                        stringBuilder.append('\u0384');
                        n5 = 0;
                        n4 = 0;
                    }
                    n4 = PDF417HighLevelEncoder.encodeText(string2, n3, n8, stringBuilder, n4);
                    n3 += n8;
                    continue;
                }
                if (byArray == null) {
                    byArray = PDF417HighLevelEncoder.toBytes(string2, charset);
                }
                if ((n6 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(string2, byArray, n3)) == 0) {
                    n6 = 1;
                }
                if (n6 == 1 && n5 == 0) {
                    PDF417HighLevelEncoder.encodeBinary(byArray, n3, 1, 0, stringBuilder);
                } else {
                    PDF417HighLevelEncoder.encodeBinary(byArray, n3, n6, n5, stringBuilder);
                    n5 = 1;
                    n4 = 0;
                }
                n3 += n6;
            }
        }
        return stringBuilder.toString();
    }

    private static byte[] toBytes(String string2, Charset charset) throws WriterException {
        if (charset == null) {
            for (String string3 : DEFAULT_ENCODING_NAMES) {
                try {
                    charset = Charset.forName(string3);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {}
            }
            if (charset == null) {
                throw new WriterException("No support for any encoding: " + DEFAULT_ENCODING_NAMES);
            }
        }
        return string2.getBytes(charset);
    }

    private static int encodeText(CharSequence charSequence, int n2, int n3, StringBuilder stringBuilder, int n4) {
        int n5;
        char c2;
        StringBuilder stringBuilder2 = new StringBuilder(n3);
        int n6 = n4;
        int n7 = 0;
        block5: while (true) {
            c2 = charSequence.charAt(n2 + n7);
            switch (n6) {
                case 0: {
                    if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        if (c2 == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c2 - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        n6 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        n6 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c2]);
                    break;
                }
                case 1: {
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        if (c2 == ' ') {
                            stringBuilder2.append('\u001a');
                            break;
                        }
                        stringBuilder2.append((char)(c2 - 97));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        stringBuilder2.append('\u001b');
                        stringBuilder2.append((char)(c2 - 65));
                        break;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        n6 = 2;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c2]);
                    break;
                }
                case 2: {
                    if (PDF417HighLevelEncoder.isMixed(c2)) {
                        stringBuilder2.append((char)MIXED[c2]);
                        break;
                    }
                    if (PDF417HighLevelEncoder.isAlphaUpper(c2)) {
                        n6 = 0;
                        stringBuilder2.append('\u001c');
                        continue block5;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c2)) {
                        n6 = 1;
                        stringBuilder2.append('\u001b');
                        continue block5;
                    }
                    if (n2 + n7 + 1 < n3 && PDF417HighLevelEncoder.isPunctuation((char)(n5 = (int)charSequence.charAt(n2 + n7 + 1)))) {
                        n6 = 3;
                        stringBuilder2.append('\u0019');
                        continue block5;
                    }
                    stringBuilder2.append('\u001d');
                    stringBuilder2.append((char)PUNCTUATION[c2]);
                    break;
                }
                default: {
                    if (PDF417HighLevelEncoder.isPunctuation(c2)) {
                        stringBuilder2.append((char)PUNCTUATION[c2]);
                        break;
                    }
                    n6 = 0;
                    stringBuilder2.append('\u001d');
                    continue block5;
                }
            }
            if (++n7 >= n3) break;
        }
        c2 = '\u0000';
        n5 = stringBuilder2.length();
        for (int i2 = 0; i2 < n5; ++i2) {
            boolean bl2;
            boolean bl3 = bl2 = i2 % 2 != 0;
            if (bl2) {
                c2 = (char)(c2 * 30 + stringBuilder2.charAt(i2));
                stringBuilder.append(c2);
                continue;
            }
            c2 = stringBuilder2.charAt(i2);
        }
        if (n5 % 2 != 0) {
            stringBuilder.append((char)(c2 * 30 + 29));
        }
        return n6;
    }

    private static void encodeBinary(byte[] byArray, int n2, int n3, int n4, StringBuilder stringBuilder) {
        int n5;
        if (n3 == 1 && n4 == 0) {
            stringBuilder.append('\u0391');
        } else {
            int n6 = n5 = n3 % 6 == 0 ? 1 : 0;
            if (n5 != 0) {
                stringBuilder.append('\u039c');
            } else {
                stringBuilder.append('\u0385');
            }
        }
        n5 = n2;
        if (n3 >= 6) {
            char[] cArray = new char[5];
            while (n2 + n3 - n5 >= 6) {
                int n7;
                long l2 = 0L;
                for (n7 = 0; n7 < 6; ++n7) {
                    l2 <<= 8;
                    l2 += (long)(byArray[n5 + n7] & 0xFF);
                }
                for (n7 = 0; n7 < 5; ++n7) {
                    cArray[n7] = (char)(l2 % 900L);
                    l2 /= 900L;
                }
                for (n7 = cArray.length - 1; n7 >= 0; --n7) {
                    stringBuilder.append(cArray[n7]);
                }
                n5 += 6;
            }
        }
        for (int i2 = n5; i2 < n2 + n3; ++i2) {
            int n8 = byArray[i2] & 0xFF;
            stringBuilder.append((char)n8);
        }
    }

    private static void encodeNumeric(String string2, int n2, int n3, StringBuilder stringBuilder) {
        int n4;
        StringBuilder stringBuilder2 = new StringBuilder(n3 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i2 = 0; i2 < n3 - 1; i2 += n4) {
            stringBuilder2.setLength(0);
            n4 = Math.min(44, n3 - i2);
            String string3 = '1' + string2.substring(n2 + i2, n2 + i2 + n4);
            BigInteger bigInteger3 = new BigInteger(string3);
            do {
                stringBuilder2.append((char)bigInteger3.mod(bigInteger).intValue());
            } while (!(bigInteger3 = bigInteger3.divide(bigInteger)).equals(bigInteger2));
            for (int i3 = stringBuilder2.length() - 1; i3 >= 0; --i3) {
                stringBuilder.append(stringBuilder2.charAt(i3));
            }
        }
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isAlphaUpper(char c2) {
        return c2 == ' ' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isAlphaLower(char c2) {
        return c2 == ' ' || c2 >= 'a' && c2 <= 'z';
    }

    private static boolean isMixed(char c2) {
        return MIXED[c2] != -1;
    }

    private static boolean isPunctuation(char c2) {
        return PUNCTUATION[c2] != -1;
    }

    private static boolean isText(char c2) {
        return c2 == '\t' || c2 == '\n' || c2 == '\r' || c2 >= ' ' && c2 <= '~';
    }

    private static int determineConsecutiveDigitCount(CharSequence charSequence, int n2) {
        int n3 = 0;
        int n4 = n2;
        int n5 = charSequence.length();
        if (n4 < n5) {
            char c2 = charSequence.charAt(n4);
            while (PDF417HighLevelEncoder.isDigit(c2) && n4 < n5) {
                ++n3;
                if (++n4 >= n5) continue;
                c2 = charSequence.charAt(n4);
            }
        }
        return n3;
    }

    private static int determineConsecutiveTextCount(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        int n4 = n2;
        while (n4 < n3) {
            int n5;
            char c2 = charSequence.charAt(n4);
            for (n5 = 0; n5 < 13 && PDF417HighLevelEncoder.isDigit(c2) && n4 < n3; ++n5) {
                if (++n4 >= n3) continue;
                c2 = charSequence.charAt(n4);
            }
            if (n5 >= 13) {
                return n4 - n2 - n5;
            }
            if (n5 > 0) continue;
            c2 = charSequence.charAt(n4);
            if (!PDF417HighLevelEncoder.isText(c2)) break;
            ++n4;
        }
        return n4 - n2;
    }

    private static int determineConsecutiveBinaryCount(CharSequence charSequence, byte[] byArray, int n2) throws WriterException {
        int n3;
        int n4 = charSequence.length();
        for (n3 = n2; n3 < n4; ++n3) {
            int n5;
            int n6;
            char c2 = charSequence.charAt(n3);
            int n7 = 0;
            while (n7 < 13 && PDF417HighLevelEncoder.isDigit(c2) && (n6 = n3 + ++n7) < n4) {
                c2 = charSequence.charAt(n6);
            }
            if (n7 >= 13) {
                return n3 - n2;
            }
            n6 = 0;
            while (n6 < 5 && PDF417HighLevelEncoder.isText(c2) && (n5 = n3 + ++n6) < n4) {
                c2 = charSequence.charAt(n5);
            }
            if (n6 >= 5) {
                return n3 - n2;
            }
            c2 = charSequence.charAt(n3);
            if (byArray[n3] != 63 || c2 == '?') continue;
            throw new WriterException("Non-encodable character detected: " + c2 + " (Unicode: " + c2 + ')');
        }
        return n3 - n2;
    }

    private static void encodingECI(int n2, StringBuilder stringBuilder) throws WriterException {
        if (n2 >= 0 && n2 < 900) {
            stringBuilder.append('\u039f');
            stringBuilder.append((char)n2);
        } else if (n2 < 810900) {
            stringBuilder.append('\u039e');
            stringBuilder.append((char)(n2 / 900 - 1));
            stringBuilder.append((char)(n2 % 900));
        } else if (n2 < 811800) {
            stringBuilder.append('\u039d');
            stringBuilder.append((char)(810900 - n2));
        } else {
            throw new WriterException("ECI number not in valid range from 0..811799, but was " + n2);
        }
    }

    static {
        byte by2;
        int n2;
        TEXT_MIXED_RAW = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 38, 13, 9, 44, 58, 35, 45, 46, 36, 47, 43, 37, 42, 61, 94, 0, 32, 0, 0, 0};
        TEXT_PUNCTUATION_RAW = new byte[]{59, 60, 62, 64, 91, 92, 93, 95, 96, 126, 33, 13, 9, 44, 58, 10, 45, 46, 36, 47, 34, 124, 42, 40, 41, 63, 123, 125, 39, 0};
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        DEFAULT_ENCODING_NAMES = Arrays.asList("Cp437", "IBM437");
        Arrays.fill(MIXED, (byte)-1);
        for (n2 = 0; n2 < TEXT_MIXED_RAW.length; n2 = (int)((byte)(n2 + 1))) {
            by2 = TEXT_MIXED_RAW[n2];
            if (by2 <= 0) continue;
            PDF417HighLevelEncoder.MIXED[by2] = n2;
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        for (n2 = 0; n2 < TEXT_PUNCTUATION_RAW.length; n2 = (int)((byte)(n2 + 1))) {
            by2 = TEXT_PUNCTUATION_RAW[n2];
            if (by2 <= 0) continue;
            PDF417HighLevelEncoder.PUNCTUATION[by2] = n2;
        }
    }
}

