/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.decoder.Decoder;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.detector.Detector;
import java.util.List;
import java.util.Map;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    protected final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        String string2;
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = QRCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object, map);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect(map);
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits(), map);
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
            ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(resultPointArray);
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
        List<byte[]> list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string2 = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string2);
        }
        if (decoderResult.hasStructuredAppend()) {
            ((Result)object).putMetadata(ResultMetadataType.STRUCTURED_APPEND_SEQUENCE, decoderResult.getStructuredAppendSequenceNumber());
            ((Result)object).putMetadata(ResultMetadataType.STRUCTURED_APPEND_PARITY, decoderResult.getStructuredAppendParity());
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        float f2 = QRCodeReader.moduleSize(nArray, bitMatrix);
        int n3 = nArray[1];
        int n4 = nArray2[1];
        int n5 = nArray[0];
        int n6 = nArray2[0];
        if (n5 >= n6 || n3 >= n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n4 - n3 != n6 - n5) {
            n6 = n5 + (n4 - n3);
        }
        int n7 = Math.round((float)(n6 - n5 + 1) / f2);
        int n8 = Math.round((float)(n4 - n3 + 1) / f2);
        if (n7 <= 0 || n8 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n8 != n7) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n9 = (int)(f2 / 2.0f);
        n3 += n9;
        int n10 = (n5 += n9) + (int)((float)(n7 - 1) * f2) - (n6 - 1);
        if (n10 > 0) {
            if (n10 > n9) {
                throw NotFoundException.getNotFoundInstance();
            }
            n5 -= n10;
        }
        if ((n2 = n3 + (int)((float)(n8 - 1) * f2) - (n4 - 1)) > 0) {
            if (n2 > n9) {
                throw NotFoundException.getNotFoundInstance();
            }
            n3 -= n2;
        }
        BitMatrix bitMatrix2 = new BitMatrix(n7, n8);
        for (int i2 = 0; i2 < n8; ++i2) {
            int n11 = n3 + (int)((float)i2 * f2);
            for (int i3 = 0; i3 < n7; ++i3) {
                if (!bitMatrix.get(n5 + (int)((float)i3 * f2), n11)) continue;
                bitMatrix2.set(i3, i2);
            }
        }
        return bitMatrix2;
    }

    private static float moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n2;
        int n3 = bitMatrix.getHeight();
        int n4 = bitMatrix.getWidth();
        int n5 = nArray[0];
        boolean bl2 = true;
        int n6 = 0;
        for (n2 = nArray[1]; n5 < n4 && n2 < n3; ++n5, ++n2) {
            if (bl2 == bitMatrix.get(n5, n2)) continue;
            if (++n6 == 5) break;
            bl2 = !bl2;
        }
        if (n5 == n4 || n2 == n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        return (float)(n5 - nArray[0]) / 7.0f;
    }
}

