/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.Map;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3) throws WriterException {
        return this.encode(string2, barcodeFormat, n2, n3, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        Object object;
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + (Object)((Object)barcodeFormat));
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n2 + 'x' + n3);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        int n4 = 4;
        if (map != null) {
            Integer n5;
            object = (ErrorCorrectionLevel)((Object)map.get((Object)EncodeHintType.ERROR_CORRECTION));
            if (object != null) {
                errorCorrectionLevel = object;
            }
            if ((n5 = (Integer)map.get((Object)EncodeHintType.MARGIN)) != null) {
                n4 = n5;
            }
        }
        object = Encoder.encode(string2, errorCorrectionLevel, map);
        return QRCodeWriter.renderResult((QRCode)object, n2, n3, n4);
    }

    private static BitMatrix renderResult(QRCode qRCode, int n2, int n3, int n4) {
        ByteMatrix byteMatrix = qRCode.getMatrix();
        if (byteMatrix == null) {
            throw new IllegalStateException();
        }
        int n5 = byteMatrix.getWidth();
        int n6 = byteMatrix.getHeight();
        int n7 = n5 + n4 * 2;
        int n8 = n6 + n4 * 2;
        int n9 = Math.max(n2, n7);
        int n10 = Math.max(n3, n8);
        int n11 = Math.min(n9 / n7, n10 / n8);
        int n12 = (n9 - n5 * n11) / 2;
        int n13 = (n10 - n6 * n11) / 2;
        BitMatrix bitMatrix = new BitMatrix(n9, n10);
        int n14 = 0;
        int n15 = n13;
        while (n14 < n6) {
            int n16 = 0;
            int n17 = n12;
            while (n16 < n5) {
                if (byteMatrix.get(n16, n14) == 1) {
                    bitMatrix.setRegion(n17, n15, n11, n11);
                }
                ++n16;
                n17 += n11;
            }
            ++n14;
            n15 += n11;
        }
        return bitMatrix;
    }
}

