/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.DataMask;
import com.google.zxing.qrcode.decoder.FormatInformation;
import com.google.zxing.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n2 = bitMatrix.getHeight();
        if (n2 < 21 || (n2 & 3) != 1) {
            throw FormatException.getFormatInstance();
        }
        this.bitMatrix = bitMatrix;
    }

    FormatInformation readFormatInformation() throws FormatException {
        int n2;
        int n3;
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int n4 = 0;
        for (n3 = 0; n3 < 6; ++n3) {
            n4 = this.copyBit(n3, 8, n4);
        }
        n4 = this.copyBit(7, 8, n4);
        n4 = this.copyBit(8, 8, n4);
        n4 = this.copyBit(8, 7, n4);
        for (n3 = 5; n3 >= 0; --n3) {
            n4 = this.copyBit(8, n3, n4);
        }
        n3 = this.bitMatrix.getHeight();
        int n5 = 0;
        int n6 = n3 - 7;
        for (n2 = n3 - 1; n2 >= n6; --n2) {
            n5 = this.copyBit(8, n2, n5);
        }
        for (n2 = n3 - 8; n2 < n3; ++n2) {
            n5 = this.copyBit(n2, 8, n5);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(n4, n5);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() throws FormatException {
        int n2;
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        int n3 = this.bitMatrix.getHeight();
        int n4 = (n3 - 17) / 4;
        if (n4 <= 6) {
            return Version.getVersionForNumber(n4);
        }
        int n5 = 0;
        int n6 = n3 - 11;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (n2 = n3 - 9; n2 >= n6; --n2) {
                n5 = this.copyBit(n2, i2, n5);
            }
        }
        Version version = Version.decodeVersionInformation(n5);
        if (version != null && version.getDimensionForVersion() == n3) {
            this.parsedVersion = version;
            return version;
        }
        n5 = 0;
        for (n2 = 5; n2 >= 0; --n2) {
            for (int i3 = n3 - 9; i3 >= n6; --i3) {
                n5 = this.copyBit(n2, i3, n5);
            }
        }
        version = Version.decodeVersionInformation(n5);
        if (version != null && version.getDimensionForVersion() == n3) {
            this.parsedVersion = version;
            return version;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int n2, int n3, int n4) {
        boolean bl2 = this.mirror ? this.bitMatrix.get(n3, n2) : this.bitMatrix.get(n2, n3);
        return bl2 ? n4 << 1 | 1 : n4 << 1;
    }

    byte[] readCodewords() throws FormatException {
        FormatInformation formatInformation = this.readFormatInformation();
        Version version = this.readVersion();
        DataMask dataMask = DataMask.forReference(formatInformation.getDataMask());
        int n2 = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n2);
        BitMatrix bitMatrix = version.buildFunctionPattern();
        boolean bl2 = true;
        byte[] byArray = new byte[version.getTotalCodewords()];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i2 = n2 - 1; i2 > 0; i2 -= 2) {
            if (i2 == 6) {
                --i2;
            }
            for (int i3 = 0; i3 < n2; ++i3) {
                int n6 = bl2 ? n2 - 1 - i3 : i3;
                for (int i4 = 0; i4 < 2; ++i4) {
                    if (bitMatrix.get(i2 - i4, n6)) continue;
                    ++n5;
                    n4 <<= 1;
                    if (this.bitMatrix.get(i2 - i4, n6)) {
                        n4 |= 1;
                    }
                    if (n5 != 8) continue;
                    byArray[n3++] = (byte)n4;
                    n5 = 0;
                    n4 = 0;
                }
            }
            bl2 ^= true;
        }
        if (n3 != version.getTotalCodewords()) {
            throw FormatException.getFormatInstance();
        }
        return byArray;
    }

    void remask() {
        if (this.parsedFormatInfo == null) {
            return;
        }
        DataMask dataMask = DataMask.forReference(this.parsedFormatInfo.getDataMask());
        int n2 = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n2);
    }

    void setMirror(boolean bl2) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.mirror = bl2;
    }

    void mirror() {
        for (int i2 = 0; i2 < this.bitMatrix.getWidth(); ++i2) {
            for (int i3 = i2 + 1; i3 < this.bitMatrix.getHeight(); ++i3) {
                if (this.bitMatrix.get(i2, i3) == this.bitMatrix.get(i3, i2)) continue;
                this.bitMatrix.flip(i3, i2);
                this.bitMatrix.flip(i2, i3);
            }
        }
    }
}

