/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int n2, byte[] byArray) {
        this.numDataCodewords = n2;
        this.codewords = byArray;
    }

    static DataBlock[] getDataBlocks(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel) {
        int n2;
        int n3;
        int n4;
        int n5;
        if (byArray.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel);
        int n6 = 0;
        Version.ECB[] eCBArray = eCBlocks.getECBlocks();
        for (Version.ECB eCB : eCBArray) {
            n6 += eCB.getCount();
        }
        Object[] objectArray = new DataBlock[n6];
        int n7 = 0;
        Version.ECB[] eCBArray2 = eCBArray;
        int n8 = eCBArray2.length;
        for (n5 = 0; n5 < n8; ++n5) {
            Version.ECB eCB = eCBArray2[n5];
            for (n4 = 0; n4 < eCB.getCount(); ++n4) {
                n3 = eCB.getDataCodewords();
                n2 = eCBlocks.getECCodewordsPerBlock() + n3;
                objectArray[n7++] = new DataBlock(n3, new byte[n2]);
            }
        }
        int n9 = ((DataBlock)objectArray[0]).codewords.length;
        for (n8 = objectArray.length - 1; n8 >= 0 && (n5 = ((DataBlock)objectArray[n8]).codewords.length) != n9; --n8) {
        }
        ++n8;
        n5 = n9 - eCBlocks.getECCodewordsPerBlock();
        int n10 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n7; ++n3) {
                ((DataBlock)objectArray[n3]).codewords[n4] = byArray[n10++];
            }
        }
        for (n4 = n8; n4 < n7; ++n4) {
            ((DataBlock)objectArray[n4]).codewords[n5] = byArray[n10++];
        }
        n4 = ((DataBlock)objectArray[0]).codewords.length;
        for (n3 = n5; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n7; ++n2) {
                int n11 = n2 < n8 ? n3 : n3 + 1;
                ((DataBlock)objectArray[n2]).codewords[n11] = byArray[n10++];
            }
        }
        return objectArray;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

