/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.StringUtils;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class DecodedBitStreamParser {
    private static final char[] ALPHANUMERIC_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel, Map<DecodeHintType, ?> map) throws FormatException {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(50);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        int n2 = -1;
        int n3 = -1;
        try {
            Mode mode;
            CharacterSetECI characterSetECI = null;
            boolean bl2 = false;
            do {
                int n4;
                if ((mode = bitSource.available() < 4 ? Mode.TERMINATOR : Mode.forBits(bitSource.readBits(4))) == Mode.TERMINATOR) continue;
                if (mode == Mode.FNC1_FIRST_POSITION || mode == Mode.FNC1_SECOND_POSITION) {
                    bl2 = true;
                    continue;
                }
                if (mode == Mode.STRUCTURED_APPEND) {
                    if (bitSource.available() < 16) {
                        throw FormatException.getFormatInstance();
                    }
                    n2 = bitSource.readBits(8);
                    n3 = bitSource.readBits(8);
                    continue;
                }
                if (mode == Mode.ECI) {
                    n4 = DecodedBitStreamParser.parseECIValue(bitSource);
                    characterSetECI = CharacterSetECI.getCharacterSetECIByValue(n4);
                    if (characterSetECI != null) continue;
                    throw FormatException.getFormatInstance();
                }
                if (mode == Mode.HANZI) {
                    n4 = bitSource.readBits(4);
                    int n5 = bitSource.readBits(mode.getCharacterCountBits(version));
                    if (n4 != 1) continue;
                    DecodedBitStreamParser.decodeHanziSegment(bitSource, stringBuilder, n5);
                    continue;
                }
                n4 = bitSource.readBits(mode.getCharacterCountBits(version));
                if (mode == Mode.NUMERIC) {
                    DecodedBitStreamParser.decodeNumericSegment(bitSource, stringBuilder, n4);
                    continue;
                }
                if (mode == Mode.ALPHANUMERIC) {
                    DecodedBitStreamParser.decodeAlphanumericSegment(bitSource, stringBuilder, n4, bl2);
                    continue;
                }
                if (mode == Mode.BYTE) {
                    DecodedBitStreamParser.decodeByteSegment(bitSource, stringBuilder, n4, characterSetECI, arrayList, map);
                    continue;
                }
                if (mode == Mode.KANJI) {
                    DecodedBitStreamParser.decodeKanjiSegment(bitSource, stringBuilder, n4);
                    continue;
                }
                throw FormatException.getFormatInstance();
            } while (mode != Mode.TERMINATOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FormatException.getFormatInstance();
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, errorCorrectionLevel == null ? null : errorCorrectionLevel.toString(), n2, n3);
    }

    private static void decodeHanziSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        if (n2 * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = bitSource.readBits(13);
            int n5 = n4 / 96 << 8 | n4 % 96;
            n5 = n5 < 959 ? (n5 += 41377) : (n5 += 42657);
            byArray[n3] = (byte)(n5 >> 8 & 0xFF);
            byArray[n3 + 1] = (byte)(n5 & 0xFF);
            n3 += 2;
            --n2;
        }
        try {
            stringBuilder.append(new String(byArray, "GB2312"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeKanjiSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        if (n2 * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = bitSource.readBits(13);
            int n5 = n4 / 192 << 8 | n4 % 192;
            n5 = n5 < 7936 ? (n5 += 33088) : (n5 += 49472);
            byArray[n3] = (byte)(n5 >> 8);
            byArray[n3 + 1] = (byte)n5;
            n3 += 2;
            --n2;
        }
        try {
            stringBuilder.append(new String(byArray, "SJIS"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void decodeByteSegment(BitSource bitSource, StringBuilder stringBuilder, int n2, CharacterSetECI characterSetECI, Collection<byte[]> collection, Map<DecodeHintType, ?> map) throws FormatException {
        if (8 * n2 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)bitSource.readBits(8);
        }
        String string2 = characterSetECI == null ? StringUtils.guessEncoding(byArray, map) : characterSetECI.name();
        try {
            stringBuilder.append(new String(byArray, string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
        collection.add(byArray);
    }

    private static char toAlphaNumericChar(int n2) throws FormatException {
        if (n2 >= ALPHANUMERIC_CHARS.length) {
            throw FormatException.getFormatInstance();
        }
        return ALPHANUMERIC_CHARS[n2];
    }

    private static void decodeAlphanumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n2, boolean bl2) throws FormatException {
        int n3;
        int n4 = stringBuilder.length();
        while (n2 > 1) {
            if (bitSource.available() < 11) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(11);
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 45));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 % 45));
            n2 -= 2;
        }
        if (n2 == 1) {
            if (bitSource.available() < 6) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(bitSource.readBits(6)));
        }
        if (bl2) {
            for (n3 = n4; n3 < stringBuilder.length(); ++n3) {
                if (stringBuilder.charAt(n3) != '%') continue;
                if (n3 < stringBuilder.length() - 1 && stringBuilder.charAt(n3 + 1) == '%') {
                    stringBuilder.deleteCharAt(n3 + 1);
                    continue;
                }
                stringBuilder.setCharAt(n3, '\u001d');
            }
        }
    }

    private static void decodeNumericSegment(BitSource bitSource, StringBuilder stringBuilder, int n2) throws FormatException {
        int n3;
        while (n2 >= 3) {
            if (bitSource.available() < 10) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(10);
            if (n3 >= 1000) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 100));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 10 % 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 % 10));
            n2 -= 3;
        }
        if (n2 == 2) {
            if (bitSource.available() < 7) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(7);
            if (n3 >= 100) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 / 10));
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3 % 10));
        } else if (n2 == 1) {
            if (bitSource.available() < 4) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(4);
            if (n3 >= 10) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.toAlphaNumericChar(n3));
        }
    }

    private static int parseECIValue(BitSource bitSource) throws FormatException {
        int n2 = bitSource.readBits(8);
        if ((n2 & 0x80) == 0) {
            return n2 & 0x7F;
        }
        if ((n2 & 0xC0) == 128) {
            int n3 = bitSource.readBits(8);
            return (n2 & 0x3F) << 8 | n3;
        }
        if ((n2 & 0xE0) == 192) {
            int n4 = bitSource.readBits(16);
            return (n2 & 0x1F) << 16 | n4;
        }
        throw FormatException.getFormatInstance();
    }
}

