/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.qrcode.decoder.BitMatrixParser;
import com.google.zxing.qrcode.decoder.DataBlock;
import com.google.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    public DecoderResult decode(boolean[][] blArray) throws ChecksumException, FormatException {
        return this.decode(blArray, null);
    }

    public DecoderResult decode(boolean[][] blArray, Map<DecodeHintType, ?> map) throws ChecksumException, FormatException {
        int n2 = blArray.length;
        BitMatrix bitMatrix = new BitMatrix(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!blArray[i2][i3]) continue;
                bitMatrix.set(i3, i2);
            }
        }
        return this.decode(bitMatrix, map);
    }

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        FormatException formatException = null;
        ChecksumException checksumException = null;
        try {
            return this.decode(bitMatrixParser, map);
        }
        catch (FormatException formatException2) {
            formatException = formatException2;
        }
        catch (ChecksumException checksumException2) {
            checksumException = checksumException2;
        }
        try {
            bitMatrixParser.remask();
            bitMatrixParser.setMirror(true);
            bitMatrixParser.readVersion();
            bitMatrixParser.readFormatInformation();
            bitMatrixParser.mirror();
            DecoderResult decoderResult = this.decode(bitMatrixParser, map);
            decoderResult.setOther(new QRCodeDecoderMetaData(true));
            return decoderResult;
        }
        catch (ChecksumException | FormatException readerException) {
            if (formatException != null) {
                throw formatException;
            }
            if (checksumException != null) {
                throw checksumException;
            }
            throw readerException;
        }
    }

    private DecoderResult decode(BitMatrixParser bitMatrixParser, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        Version version = bitMatrixParser.readVersion();
        ErrorCorrectionLevel errorCorrectionLevel = bitMatrixParser.readFormatInformation().getErrorCorrectionLevel();
        byte[] byArray = bitMatrixParser.readCodewords();
        DataBlock[] dataBlockArray = DataBlock.getDataBlocks(byArray, version, errorCorrectionLevel);
        int n2 = 0;
        for (DataBlock dataBlock : dataBlockArray) {
            n2 += dataBlock.getNumDataCodewords();
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (DataBlock dataBlock : dataBlockArray) {
            byte[] byArray3 = dataBlock.getCodewords();
            int n4 = dataBlock.getNumDataCodewords();
            this.correctErrors(byArray3, n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray2[n3++] = byArray3[i2];
            }
        }
        return DecodedBitStreamParser.decode(byArray2, version, errorCorrectionLevel, map);
    }

    private void correctErrors(byte[] byArray, int n2) throws ChecksumException {
        int n3;
        int n4 = byArray.length;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = byArray[n3] & 0xFF;
        }
        n3 = byArray.length - n2;
        try {
            this.rsDecoder.decode(nArray, n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)nArray[i2];
        }
    }
}

