/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP = new int[][]{{21522, 0}, {20773, 1}, {24188, 2}, {23371, 3}, {17913, 4}, {16590, 5}, {20375, 6}, {19104, 7}, {30660, 8}, {29427, 9}, {32170, 10}, {30877, 11}, {26159, 12}, {25368, 13}, {27713, 14}, {26998, 15}, {5769, 16}, {5054, 17}, {7399, 18}, {6608, 19}, {1890, 20}, {597, 21}, {3340, 22}, {2107, 23}, {13663, 24}, {12392, 25}, {16177, 26}, {14854, 27}, {9396, 28}, {8579, 29}, {11994, 30}, {11245, 31}};
    private static final int[] BITS_SET_IN_HALF_BYTE = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final byte dataMask;

    private FormatInformation(int n2) {
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(n2 >> 3 & 3);
        this.dataMask = (byte)(n2 & 7);
    }

    static int numBitsDiffering(int n2, int n3) {
        return BITS_SET_IN_HALF_BYTE[(n2 ^= n3) & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 4 & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 8 & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 12 & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 16 & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 20 & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 24 & 0xF] + BITS_SET_IN_HALF_BYTE[n2 >>> 28 & 0xF];
    }

    static FormatInformation decodeFormatInformation(int n2, int n3) {
        FormatInformation formatInformation = FormatInformation.doDecodeFormatInformation(n2, n3);
        if (formatInformation != null) {
            return formatInformation;
        }
        return FormatInformation.doDecodeFormatInformation(n2 ^ 0x5412, n3 ^ 0x5412);
    }

    private static FormatInformation doDecodeFormatInformation(int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        for (int[] nArray : FORMAT_INFO_DECODE_LOOKUP) {
            int n6 = nArray[0];
            if (n6 == n2 || n6 == n3) {
                return new FormatInformation(nArray[1]);
            }
            int n7 = FormatInformation.numBitsDiffering(n2, n6);
            if (n7 < n4) {
                n5 = nArray[1];
                n4 = n7;
            }
            if (n2 == n3 || (n7 = FormatInformation.numBitsDiffering(n3, n6)) >= n4) continue;
            n5 = nArray[1];
            n4 = n7;
        }
        if (n4 <= 3) {
            return new FormatInformation(n5);
        }
        return null;
    }

    ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    byte getDataMask() {
        return this.dataMask;
    }

    public int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormatInformation)) {
            return false;
        }
        FormatInformation formatInformation = (FormatInformation)object;
        return this.errorCorrectionLevel == formatInformation.errorCorrectionLevel && this.dataMask == formatInformation.dataMask;
    }
}

