/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import java.util.ArrayList;
import java.util.List;

final class AlignmentPatternFinder {
    private final BitMatrix image;
    private final List<AlignmentPattern> possibleCenters;
    private final int startX;
    private final int startY;
    private final int width;
    private final int height;
    private final float moduleSize;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    AlignmentPatternFinder(BitMatrix bitMatrix, int n2, int n3, int n4, int n5, float f2, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList<AlignmentPattern>(5);
        this.startX = n2;
        this.startY = n3;
        this.width = n4;
        this.height = n5;
        this.moduleSize = f2;
        this.crossCheckStateCount = new int[3];
        this.resultPointCallback = resultPointCallback;
    }

    AlignmentPattern find() throws NotFoundException {
        int n2 = this.startX;
        int n3 = this.height;
        int n4 = n2 + this.width;
        int n5 = this.startY + n3 / 2;
        int[] nArray = new int[3];
        for (int i2 = 0; i2 < n3; ++i2) {
            AlignmentPattern alignmentPattern;
            int n6;
            int n7 = n5 + ((i2 & 1) == 0 ? (i2 + 1) / 2 : -((i2 + 1) / 2));
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            for (n6 = n2; n6 < n4 && !this.image.get(n6, n7); ++n6) {
            }
            int n8 = 0;
            while (n6 < n4) {
                if (this.image.get(n6, n7)) {
                    if (n8 == 1) {
                        int n9 = n8;
                        nArray[n9] = nArray[n9] + 1;
                    } else if (n8 == 2) {
                        if (this.foundPatternCross(nArray) && (alignmentPattern = this.handlePossibleCenter(nArray, n7, n6)) != null) {
                            return alignmentPattern;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = 1;
                        nArray[2] = 0;
                        n8 = 1;
                    } else {
                        int n10 = ++n8;
                        nArray[n10] = nArray[n10] + 1;
                    }
                } else {
                    if (n8 == 1) {
                        // empty if block
                    }
                    int n11 = ++n8;
                    nArray[n11] = nArray[n11] + 1;
                }
                ++n6;
            }
            if (!this.foundPatternCross(nArray) || (alignmentPattern = this.handlePossibleCenter(nArray, n7, n4)) == null) continue;
            return alignmentPattern;
        }
        if (!this.possibleCenters.isEmpty()) {
            return this.possibleCenters.get(0);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static float centerFromEnd(int[] nArray, int n2) {
        return (float)(n2 - nArray[2]) - (float)nArray[1] / 2.0f;
    }

    private boolean foundPatternCross(int[] nArray) {
        float f2 = this.moduleSize;
        float f3 = f2 / 2.0f;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!(Math.abs(f2 - (float)nArray[i2]) >= f3)) continue;
            return false;
        }
        return true;
    }

    private float crossCheckVertical(int n2, int n3, int n4, int n5) {
        int n6;
        BitMatrix bitMatrix = this.image;
        int n7 = bitMatrix.getHeight();
        int[] nArray = this.crossCheckStateCount;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n3, n6) && nArray[1] <= n4; --n6) {
            nArray[1] = nArray[1] + 1;
        }
        if (n6 < 0 || nArray[1] > n4) {
            return Float.NaN;
        }
        while (n6 >= 0 && !bitMatrix.get(n3, n6) && nArray[0] <= n4) {
            nArray[0] = nArray[0] + 1;
            --n6;
        }
        if (nArray[0] > n4) {
            return Float.NaN;
        }
        for (n6 = n2 + 1; n6 < n7 && bitMatrix.get(n3, n6) && nArray[1] <= n4; ++n6) {
            nArray[1] = nArray[1] + 1;
        }
        if (n6 == n7 || nArray[1] > n4) {
            return Float.NaN;
        }
        while (n6 < n7 && !bitMatrix.get(n3, n6) && nArray[2] <= n4) {
            nArray[2] = nArray[2] + 1;
            ++n6;
        }
        if (nArray[2] > n4) {
            return Float.NaN;
        }
        int n8 = nArray[0] + nArray[1] + nArray[2];
        if (5 * Math.abs(n8 - n5) >= 2 * n5) {
            return Float.NaN;
        }
        return this.foundPatternCross(nArray) ? AlignmentPatternFinder.centerFromEnd(nArray, n6) : Float.NaN;
    }

    private AlignmentPattern handlePossibleCenter(int[] nArray, int n2, int n3) {
        int n4 = nArray[0] + nArray[1] + nArray[2];
        float f2 = AlignmentPatternFinder.centerFromEnd(nArray, n3);
        float f3 = this.crossCheckVertical(n2, (int)f2, 2 * nArray[1], n4);
        if (!Float.isNaN(f3)) {
            float f4 = (float)(nArray[0] + nArray[1] + nArray[2]) / 3.0f;
            for (AlignmentPattern alignmentPattern : this.possibleCenters) {
                if (!alignmentPattern.aboutEquals(f4, f3, f2)) continue;
                return alignmentPattern.combineEstimate(f3, f2, f4);
            }
            AlignmentPattern alignmentPattern = new AlignmentPattern(f2, f3, f4);
            this.possibleCenters.add(alignmentPattern);
            if (this.resultPointCallback != null) {
                this.resultPointCallback.foundPossibleResultPoint(alignmentPattern);
            }
        }
        return null;
    }
}

