/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import com.google.zxing.qrcode.detector.AlignmentPatternFinder;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Map;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    public DetectorResult detect() throws NotFoundException, FormatException {
        return this.detect(null);
    }

    public final DetectorResult detect(Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        this.resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        FinderPatternFinder finderPatternFinder = new FinderPatternFinder(this.image, this.resultPointCallback);
        FinderPatternInfo finderPatternInfo = finderPatternFinder.find(map);
        return this.processFinderPatternInfo(finderPatternInfo);
    }

    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo finderPatternInfo) throws NotFoundException, FormatException {
        FinderPattern finderPattern;
        FinderPattern finderPattern2;
        FinderPattern finderPattern3 = finderPatternInfo.getTopLeft();
        float f2 = this.calculateModuleSize(finderPattern3, finderPattern2 = finderPatternInfo.getTopRight(), finderPattern = finderPatternInfo.getBottomLeft());
        if (f2 < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n2 = Detector.computeDimension(finderPattern3, finderPattern2, finderPattern, f2);
        Version version = Version.getProvisionalVersionForDimension(n2);
        int n3 = version.getDimensionForVersion() - 7;
        AlignmentPattern alignmentPattern = null;
        if (version.getAlignmentPatternCenters().length > 0) {
            float f3 = finderPattern2.getX() - finderPattern3.getX() + finderPattern.getX();
            float f4 = finderPattern2.getY() - finderPattern3.getY() + finderPattern.getY();
            float f5 = 1.0f - 3.0f / (float)n3;
            int n4 = (int)(finderPattern3.getX() + f5 * (f3 - finderPattern3.getX()));
            int n5 = (int)(finderPattern3.getY() + f5 * (f4 - finderPattern3.getY()));
            for (int i2 = 4; i2 <= 16; i2 <<= 1) {
                try {
                    alignmentPattern = this.findAlignmentInRegion(f2, n4, n5, i2);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    continue;
                }
            }
        }
        PerspectiveTransform perspectiveTransform = Detector.createTransform(finderPattern3, finderPattern2, finderPattern, alignmentPattern, n2);
        BitMatrix bitMatrix = Detector.sampleGrid(this.image, perspectiveTransform, n2);
        ResultPoint[] resultPointArray = alignmentPattern == null ? new ResultPoint[]{finderPattern, finderPattern3, finderPattern2} : new ResultPoint[]{finderPattern, finderPattern3, finderPattern2, alignmentPattern};
        return new DetectorResult(bitMatrix, resultPointArray);
    }

    private static PerspectiveTransform createTransform(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n2) {
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = (float)n2 - 3.5f;
        if (resultPoint4 != null) {
            f5 = resultPoint4.getX();
            f4 = resultPoint4.getY();
            f2 = f3 = f6 - 3.0f;
        } else {
            f5 = resultPoint2.getX() - resultPoint.getX() + resultPoint3.getX();
            f4 = resultPoint2.getY() - resultPoint.getY() + resultPoint3.getY();
            f3 = f6;
            f2 = f6;
        }
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, f6, 3.5f, f3, f2, 3.5f, f6, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), f5, f4, resultPoint3.getX(), resultPoint3.getY());
    }

    private static BitMatrix sampleGrid(BitMatrix bitMatrix, PerspectiveTransform perspectiveTransform, int n2) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n2, n2, perspectiveTransform);
    }

    private static int computeDimension(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, float f2) throws NotFoundException {
        int n2 = MathUtils.round(ResultPoint.distance(resultPoint, resultPoint2) / f2);
        int n3 = MathUtils.round(ResultPoint.distance(resultPoint, resultPoint3) / f2);
        int n4 = (n2 + n3) / 2 + 7;
        switch (n4 & 3) {
            case 0: {
                ++n4;
                break;
            }
            case 2: {
                --n4;
                break;
            }
            case 3: {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        return n4;
    }

    protected final float calculateModuleSize(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3) {
        return (this.calculateModuleSizeOneWay(resultPoint, resultPoint2) + this.calculateModuleSizeOneWay(resultPoint, resultPoint3)) / 2.0f;
    }

    private float calculateModuleSizeOneWay(ResultPoint resultPoint, ResultPoint resultPoint2) {
        float f2 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint.getX(), (int)resultPoint.getY(), (int)resultPoint2.getX(), (int)resultPoint2.getY());
        float f3 = this.sizeOfBlackWhiteBlackRunBothWays((int)resultPoint2.getX(), (int)resultPoint2.getY(), (int)resultPoint.getX(), (int)resultPoint.getY());
        if (Float.isNaN(f2)) {
            return f3 / 7.0f;
        }
        if (Float.isNaN(f3)) {
            return f2 / 7.0f;
        }
        return (f2 + f3) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int n2, int n3, int n4, int n5) {
        float f2 = this.sizeOfBlackWhiteBlackRun(n2, n3, n4, n5);
        float f3 = 1.0f;
        int n6 = n2 - (n4 - n2);
        if (n6 < 0) {
            f3 = (float)n2 / (float)(n2 - n6);
            n6 = 0;
        } else if (n6 >= this.image.getWidth()) {
            f3 = (float)(this.image.getWidth() - 1 - n2) / (float)(n6 - n2);
            n6 = this.image.getWidth() - 1;
        }
        int n7 = (int)((float)n3 - (float)(n5 - n3) * f3);
        f3 = 1.0f;
        if (n7 < 0) {
            f3 = (float)n3 / (float)(n3 - n7);
            n7 = 0;
        } else if (n7 >= this.image.getHeight()) {
            f3 = (float)(this.image.getHeight() - 1 - n3) / (float)(n7 - n3);
            n7 = this.image.getHeight() - 1;
        }
        n6 = (int)((float)n2 + (float)(n6 - n2) * f3);
        return (f2 += this.sizeOfBlackWhiteBlackRun(n2, n3, n6, n7)) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int n2, int n3, int n4, int n5) {
        int n6;
        boolean bl2;
        boolean bl3 = bl2 = Math.abs(n5 - n3) > Math.abs(n4 - n2);
        if (bl2) {
            n6 = n2;
            n2 = n3;
            n3 = n6;
            n6 = n4;
            n4 = n5;
            n5 = n6;
        }
        n6 = Math.abs(n4 - n2);
        int n7 = Math.abs(n5 - n3);
        int n8 = -n6 / 2;
        int n9 = n2 < n4 ? 1 : -1;
        int n10 = n3 < n5 ? 1 : -1;
        int n11 = 0;
        int n12 = n4 + n9;
        int n13 = n3;
        for (int i2 = n2; i2 != n12; i2 += n9) {
            int n14;
            int n15;
            if (n11 == 1 == this.image.get(n15 = bl2 ? n13 : i2, n14 = bl2 ? i2 : n13)) {
                if (n11 == 2) {
                    return MathUtils.distance(i2, n13, n2, n3);
                }
                ++n11;
            }
            if ((n8 += n7) <= 0) continue;
            if (n13 == n5) break;
            n13 += n10;
            n8 -= n6;
        }
        if (n11 == 2) {
            return MathUtils.distance(n4 + n9, n5, n2, n3);
        }
        return Float.NaN;
    }

    protected final AlignmentPattern findAlignmentInRegion(float f2, int n2, int n3, float f3) throws NotFoundException {
        int n4 = (int)(f3 * f2);
        int n5 = Math.max(0, n2 - n4);
        int n6 = Math.min(this.image.getWidth() - 1, n2 + n4);
        if ((float)(n6 - n5) < f2 * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n7 = Math.max(0, n3 - n4);
        int n8 = Math.min(this.image.getHeight() - 1, n3 + n4);
        if ((float)(n8 - n7) < f2 * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        AlignmentPatternFinder alignmentPatternFinder = new AlignmentPatternFinder(this.image, n5, n7, n6 - n5, n8 - n7, f2, this.resultPointCallback);
        return alignmentPatternFinder.find();
    }
}

