/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class FinderPatternFinder {
    private static final int CENTER_QUORUM = 2;
    protected static final int MIN_SKIP = 3;
    protected static final int MAX_MODULES = 57;
    private final BitMatrix image;
    private final List<FinderPattern> possibleCenters;
    private boolean hasSkipped;
    private final int[] crossCheckStateCount;
    private final ResultPointCallback resultPointCallback;

    public FinderPatternFinder(BitMatrix bitMatrix) {
        this(bitMatrix, null);
    }

    public FinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        this.image = bitMatrix;
        this.possibleCenters = new ArrayList<FinderPattern>();
        this.crossCheckStateCount = new int[5];
        this.resultPointCallback = resultPointCallback;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final List<FinderPattern> getPossibleCenters() {
        return this.possibleCenters;
    }

    final FinderPatternInfo find(Map<DecodeHintType, ?> map) throws NotFoundException {
        boolean bl2 = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        boolean bl3 = map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE);
        int n2 = this.image.getHeight();
        int n3 = this.image.getWidth();
        int n4 = 3 * n2 / 228;
        if (n4 < 3 || bl2) {
            n4 = 3;
        }
        boolean bl4 = false;
        int[] nArray = new int[5];
        for (int i2 = n4 - 1; i2 < n2 && !bl4; i2 += n4) {
            int n5;
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n6 = 0;
            for (n5 = 0; n5 < n3; ++n5) {
                block5: {
                    block6: {
                        block7: {
                            block10: {
                                block8: {
                                    block9: {
                                        if (this.image.get(n5, i2)) {
                                            if (n6 & true) {
                                                // empty if block
                                            }
                                            int n7 = ++n6;
                                            nArray[n7] = nArray[n7] + 1;
                                            continue;
                                        }
                                        if (n6 & true) break block5;
                                        if (n6 != 4) break block6;
                                        if (!FinderPatternFinder.foundPatternCross(nArray)) break block7;
                                        boolean bl5 = this.handlePossibleCenter(nArray, i2, n5, bl3);
                                        if (!bl5) break block8;
                                        n4 = 2;
                                        if (!this.hasSkipped) break block9;
                                        bl4 = this.haveMultiplyConfirmedCenters();
                                        break block10;
                                    }
                                    int n8 = this.findRowSkip();
                                    if (n8 <= nArray[2]) break block10;
                                    i2 += n8 - nArray[2] - n4;
                                    n5 = n3 - 1;
                                    break block10;
                                }
                                nArray[0] = nArray[2];
                                nArray[1] = nArray[3];
                                nArray[2] = nArray[4];
                                nArray[3] = 1;
                                nArray[4] = 0;
                                n6 = 3;
                                continue;
                            }
                            n6 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = nArray[3];
                        nArray[2] = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n6 = 3;
                        continue;
                    }
                    int n9 = ++n6;
                    nArray[n9] = nArray[n9] + 1;
                    continue;
                }
                int n10 = n6;
                nArray[n10] = nArray[n10] + 1;
            }
            if (!FinderPatternFinder.foundPatternCross(nArray) || (n5 = (int)(this.handlePossibleCenter(nArray, i2, n3, bl3) ? 1 : 0)) == 0) continue;
            n4 = nArray[0];
            if (!this.hasSkipped) continue;
            bl4 = this.haveMultiplyConfirmedCenters();
        }
        ResultPoint[] resultPointArray = this.selectBestPatterns();
        ResultPoint.orderBestPatterns(resultPointArray);
        return new FinderPatternInfo((FinderPattern[])resultPointArray);
    }

    private static float centerFromEnd(int[] nArray, int n2) {
        return (float)(n2 - nArray[4] - nArray[3]) - (float)nArray[2] / 2.0f;
    }

    protected static boolean foundPatternCross(int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            int n3 = nArray[i2];
            if (n3 == 0) {
                return false;
            }
            n2 += n3;
        }
        if (n2 < 7) {
            return false;
        }
        float f2 = (float)n2 / 7.0f;
        float f3 = f2 / 2.0f;
        return Math.abs(f2 - (float)nArray[0]) < f3 && Math.abs(f2 - (float)nArray[1]) < f3 && Math.abs(3.0f * f2 - (float)nArray[2]) < 3.0f * f3 && Math.abs(f2 - (float)nArray[3]) < f3 && Math.abs(f2 - (float)nArray[4]) < f3;
    }

    private int[] getCrossCheckStateCount() {
        this.crossCheckStateCount[0] = 0;
        this.crossCheckStateCount[1] = 0;
        this.crossCheckStateCount[2] = 0;
        this.crossCheckStateCount[3] = 0;
        this.crossCheckStateCount[4] = 0;
        return this.crossCheckStateCount;
    }

    private boolean crossCheckDiagonal(int n2, int n3, int n4, int n5) {
        int n6;
        int[] nArray = this.getCrossCheckStateCount();
        for (n6 = 0; n2 >= n6 && n3 >= n6 && this.image.get(n3 - n6, n2 - n6); ++n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n2 < n6 || n3 < n6) {
            return false;
        }
        while (n2 >= n6 && n3 >= n6 && !this.image.get(n3 - n6, n2 - n6) && nArray[1] <= n4) {
            nArray[1] = nArray[1] + 1;
            ++n6;
        }
        if (n2 < n6 || n3 < n6 || nArray[1] > n4) {
            return false;
        }
        while (n2 >= n6 && n3 >= n6 && this.image.get(n3 - n6, n2 - n6) && nArray[0] <= n4) {
            nArray[0] = nArray[0] + 1;
            ++n6;
        }
        if (nArray[0] > n4) {
            return false;
        }
        int n7 = this.image.getHeight();
        int n8 = this.image.getWidth();
        n6 = 1;
        while (n2 + n6 < n7 && n3 + n6 < n8 && this.image.get(n3 + n6, n2 + n6)) {
            nArray[2] = nArray[2] + 1;
            ++n6;
        }
        if (n2 + n6 >= n7 || n3 + n6 >= n8) {
            return false;
        }
        while (n2 + n6 < n7 && n3 + n6 < n8 && !this.image.get(n3 + n6, n2 + n6) && nArray[3] < n4) {
            nArray[3] = nArray[3] + 1;
            ++n6;
        }
        if (n2 + n6 >= n7 || n3 + n6 >= n8 || nArray[3] >= n4) {
            return false;
        }
        while (n2 + n6 < n7 && n3 + n6 < n8 && this.image.get(n3 + n6, n2 + n6) && nArray[4] < n4) {
            nArray[4] = nArray[4] + 1;
            ++n6;
        }
        if (nArray[4] >= n4) {
            return false;
        }
        int n9 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        return Math.abs(n9 - n5) < 2 * n5 && FinderPatternFinder.foundPatternCross(nArray);
    }

    private float crossCheckVertical(int n2, int n3, int n4, int n5) {
        int n6;
        BitMatrix bitMatrix = this.image;
        int n7 = bitMatrix.getHeight();
        int[] nArray = this.getCrossCheckStateCount();
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n3, n6); --n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 < 0) {
            return Float.NaN;
        }
        while (n6 >= 0 && !bitMatrix.get(n3, n6) && nArray[1] <= n4) {
            nArray[1] = nArray[1] + 1;
            --n6;
        }
        if (n6 < 0 || nArray[1] > n4) {
            return Float.NaN;
        }
        while (n6 >= 0 && bitMatrix.get(n3, n6) && nArray[0] <= n4) {
            nArray[0] = nArray[0] + 1;
            --n6;
        }
        if (nArray[0] > n4) {
            return Float.NaN;
        }
        for (n6 = n2 + 1; n6 < n7 && bitMatrix.get(n3, n6); ++n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 == n7) {
            return Float.NaN;
        }
        while (n6 < n7 && !bitMatrix.get(n3, n6) && nArray[3] < n4) {
            nArray[3] = nArray[3] + 1;
            ++n6;
        }
        if (n6 == n7 || nArray[3] >= n4) {
            return Float.NaN;
        }
        while (n6 < n7 && bitMatrix.get(n3, n6) && nArray[4] < n4) {
            nArray[4] = nArray[4] + 1;
            ++n6;
        }
        if (nArray[4] >= n4) {
            return Float.NaN;
        }
        int n8 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        if (5 * Math.abs(n8 - n5) >= 2 * n5) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(nArray) ? FinderPatternFinder.centerFromEnd(nArray, n6) : Float.NaN;
    }

    private float crossCheckHorizontal(int n2, int n3, int n4, int n5) {
        int n6;
        BitMatrix bitMatrix = this.image;
        int n7 = bitMatrix.getWidth();
        int[] nArray = this.getCrossCheckStateCount();
        for (n6 = n2; n6 >= 0 && bitMatrix.get(n6, n3); --n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 < 0) {
            return Float.NaN;
        }
        while (n6 >= 0 && !bitMatrix.get(n6, n3) && nArray[1] <= n4) {
            nArray[1] = nArray[1] + 1;
            --n6;
        }
        if (n6 < 0 || nArray[1] > n4) {
            return Float.NaN;
        }
        while (n6 >= 0 && bitMatrix.get(n6, n3) && nArray[0] <= n4) {
            nArray[0] = nArray[0] + 1;
            --n6;
        }
        if (nArray[0] > n4) {
            return Float.NaN;
        }
        for (n6 = n2 + 1; n6 < n7 && bitMatrix.get(n6, n3); ++n6) {
            nArray[2] = nArray[2] + 1;
        }
        if (n6 == n7) {
            return Float.NaN;
        }
        while (n6 < n7 && !bitMatrix.get(n6, n3) && nArray[3] < n4) {
            nArray[3] = nArray[3] + 1;
            ++n6;
        }
        if (n6 == n7 || nArray[3] >= n4) {
            return Float.NaN;
        }
        while (n6 < n7 && bitMatrix.get(n6, n3) && nArray[4] < n4) {
            nArray[4] = nArray[4] + 1;
            ++n6;
        }
        if (nArray[4] >= n4) {
            return Float.NaN;
        }
        int n8 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        if (5 * Math.abs(n8 - n5) >= n5) {
            return Float.NaN;
        }
        return FinderPatternFinder.foundPatternCross(nArray) ? FinderPatternFinder.centerFromEnd(nArray, n6) : Float.NaN;
    }

    protected final boolean handlePossibleCenter(int[] nArray, int n2, int n3, boolean bl2) {
        int n4 = nArray[0] + nArray[1] + nArray[2] + nArray[3] + nArray[4];
        float f2 = FinderPatternFinder.centerFromEnd(nArray, n3);
        float f3 = this.crossCheckVertical(n2, (int)f2, nArray[2], n4);
        if (!(Float.isNaN(f3) || Float.isNaN(f2 = this.crossCheckHorizontal((int)f2, (int)f3, nArray[2], n4)) || bl2 && !this.crossCheckDiagonal((int)f3, (int)f2, nArray[2], n4))) {
            float f4 = (float)n4 / 7.0f;
            boolean bl3 = false;
            for (int i2 = 0; i2 < this.possibleCenters.size(); ++i2) {
                FinderPattern finderPattern = this.possibleCenters.get(i2);
                if (!finderPattern.aboutEquals(f4, f3, f2)) continue;
                this.possibleCenters.set(i2, finderPattern.combineEstimate(f3, f2, f4));
                bl3 = true;
                break;
            }
            if (!bl3) {
                FinderPattern finderPattern = new FinderPattern(f2, f3, f4);
                this.possibleCenters.add(finderPattern);
                if (this.resultPointCallback != null) {
                    this.resultPointCallback.foundPossibleResultPoint(finderPattern);
                }
            }
            return true;
        }
        return false;
    }

    private int findRowSkip() {
        int n2 = this.possibleCenters.size();
        if (n2 <= 1) {
            return 0;
        }
        FinderPattern finderPattern = null;
        for (FinderPattern finderPattern2 : this.possibleCenters) {
            if (finderPattern2.getCount() < 2) continue;
            if (finderPattern == null) {
                finderPattern = finderPattern2;
                continue;
            }
            this.hasSkipped = true;
            return (int)(Math.abs(finderPattern.getX() - finderPattern2.getX()) - Math.abs(finderPattern.getY() - finderPattern2.getY())) / 2;
        }
        return 0;
    }

    private boolean haveMultiplyConfirmedCenters() {
        int n2 = 0;
        float f2 = 0.0f;
        int n3 = this.possibleCenters.size();
        for (FinderPattern finderPattern : this.possibleCenters) {
            if (finderPattern.getCount() < 2) continue;
            ++n2;
            f2 += finderPattern.getEstimatedModuleSize();
        }
        if (n2 < 3) {
            return false;
        }
        float f3 = f2 / (float)n3;
        float f4 = 0.0f;
        for (FinderPattern finderPattern : this.possibleCenters) {
            f4 += Math.abs(finderPattern.getEstimatedModuleSize() - f3);
        }
        return f4 <= 0.05f * f2;
    }

    private FinderPattern[] selectBestPatterns() throws NotFoundException {
        float f2;
        int n2 = this.possibleCenters.size();
        if (n2 < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n2 > 3) {
            float f3;
            f2 = 0.0f;
            float f4 = 0.0f;
            for (FinderPattern finderPattern : this.possibleCenters) {
                f3 = finderPattern.getEstimatedModuleSize();
                f2 += f3;
                f4 += f3 * f3;
            }
            float f5 = f2 / (float)n2;
            float f6 = (float)Math.sqrt(f4 / (float)n2 - f5 * f5);
            Collections.sort(this.possibleCenters, new FurthestFromAverageComparator(f5));
            f3 = Math.max(0.2f * f5, f6);
            for (int i2 = 0; i2 < this.possibleCenters.size() && this.possibleCenters.size() > 3; ++i2) {
                FinderPattern finderPattern = this.possibleCenters.get(i2);
                if (!(Math.abs(finderPattern.getEstimatedModuleSize() - f5) > f3)) continue;
                this.possibleCenters.remove(i2);
                --i2;
            }
        }
        if (this.possibleCenters.size() > 3) {
            f2 = 0.0f;
            for (FinderPattern finderPattern : this.possibleCenters) {
                f2 += finderPattern.getEstimatedModuleSize();
            }
            float f7 = f2 / (float)this.possibleCenters.size();
            Collections.sort(this.possibleCenters, new CenterComparator(f7));
            this.possibleCenters.subList(3, this.possibleCenters.size()).clear();
        }
        return new FinderPattern[]{this.possibleCenters.get(0), this.possibleCenters.get(1), this.possibleCenters.get(2)};
    }

    private static final class CenterComparator
    implements Serializable,
    Comparator<FinderPattern> {
        private final float average;

        private CenterComparator(float f2) {
            this.average = f2;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            if (finderPattern2.getCount() == finderPattern.getCount()) {
                float f2;
                float f3 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
                return f3 < (f2 = Math.abs(finderPattern.getEstimatedModuleSize() - this.average)) ? 1 : (f3 == f2 ? 0 : -1);
            }
            return finderPattern2.getCount() - finderPattern.getCount();
        }
    }

    private static final class FurthestFromAverageComparator
    implements Serializable,
    Comparator<FinderPattern> {
        private final float average;

        private FurthestFromAverageComparator(float f2) {
            this.average = f2;
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            float f2;
            float f3 = Math.abs(finderPattern2.getEstimatedModuleSize() - this.average);
            return f3 < (f2 = Math.abs(finderPattern.getEstimatedModuleSize() - this.average)) ? -1 : (f3 == f2 ? 0 : 1);
        }
    }
}

