/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int width;
    private final int height;

    public ByteMatrix(int n2, int n3) {
        this.bytes = new byte[n3][n2];
        this.width = n2;
        this.height = n3;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte get(int n2, int n3) {
        return this.bytes[n3][n2];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int n2, int n3, byte by2) {
        this.bytes[n3][n2] = by2;
    }

    public void set(int n2, int n3, int n4) {
        this.bytes[n3][n2] = (byte)n4;
    }

    public void set(int n2, int n3, boolean bl2) {
        this.bytes[n3][n2] = (byte)(bl2 ? 1 : 0);
    }

    public void clear(byte by2) {
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                this.bytes[i2][i3] = by2;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.width * this.height + 2);
        for (int i2 = 0; i2 < this.height; ++i2) {
            block5: for (int i3 = 0; i3 < this.width; ++i3) {
                switch (this.bytes[i2][i3]) {
                    case 0: {
                        stringBuilder.append(" 0");
                        continue block5;
                    }
                    case 1: {
                        stringBuilder.append(" 1");
                        continue block5;
                    }
                    default: {
                        stringBuilder.append("  ");
                    }
                }
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

